/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra;

import blue.Tables;
import blue.automation.Automatable;
import blue.automation.ParameterList;
import blue.orchestra.AbstractInstrument;
import blue.orchestra.Instrument;
import blue.orchestra.InstrumentUtilities;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.orchestra.blueSynthBuilder.StringChannel;
import blue.udo.OpcodeList;
import blue.utility.TextUtilities;
import blue.utility.UDOUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.HashMap;

public class BlueSynthBuilder
extends AbstractInstrument
implements Automatable {
    BSBGraphicInterface graphicInterface;
    ParameterList parameterList;
    PresetGroup presetGroup;
    OpcodeList opcodeList;
    String instrumentText;
    private String alwaysOnInstrumentText;
    String globalOrc;
    String globalSco;
    boolean editEnabled = true;
    private transient BSBCompilationUnit bsbCompilationUnit;
    private transient HashMap udoReplacementValues;

    public BlueSynthBuilder() {
        this(true);
    }

    private BlueSynthBuilder(boolean init) {
        if (init) {
            this.graphicInterface = new BSBGraphicInterface();
            this.parameterList = new ParameterList();
            this.graphicInterface.getRootGroup().setParameterList(this.parameterList);
            this.presetGroup = new PresetGroup();
            this.opcodeList = new OpcodeList();
        }
        this.instrumentText = "";
        this.alwaysOnInstrumentText = "";
        this.globalOrc = "";
        this.globalSco = "";
    }

    public BlueSynthBuilder(BlueSynthBuilder bsb) {
        super(bsb);
        this.graphicInterface = new BSBGraphicInterface(bsb.graphicInterface);
        this.parameterList = new ParameterList(bsb.parameterList);
        this.graphicInterface.getRootGroup().setParameterList(this.parameterList);
        this.presetGroup = new PresetGroup(bsb.presetGroup);
        this.opcodeList = new OpcodeList(bsb.opcodeList);
        this.instrumentText = bsb.instrumentText;
        this.alwaysOnInstrumentText = bsb.alwaysOnInstrumentText;
        this.globalOrc = bsb.globalOrc;
        this.globalSco = bsb.globalSco;
    }

    @Override
    public void generateUserDefinedOpcodes(OpcodeList udoList) {
        this.udoReplacementValues = UDOUtilities.appendUserDefinedOpcodes(this.opcodeList, udoList);
    }

    @Override
    public void generateFTables(Tables tables) {
        this.doPreCompilation();
    }

    @Override
    public String generateGlobalOrc() {
        String retVal = this.bsbCompilationUnit.replaceBSBValues(this.getGlobalOrc());
        return retVal;
    }

    @Override
    public String generateInstrument() {
        String retVal = this.bsbCompilationUnit.replaceBSBValues(this.getInstrumentText());
        if (this.udoReplacementValues != null) {
            retVal = TextUtilities.replaceOpcodeNames(this.udoReplacementValues, retVal);
        }
        return retVal;
    }

    @Override
    public String generateAlwaysOnInstrument() {
        String retVal = this.bsbCompilationUnit.replaceBSBValues(this.getAlwaysOnInstrumentText());
        if (this.udoReplacementValues != null) {
            retVal = TextUtilities.replaceOpcodeNames(this.udoReplacementValues, retVal);
            this.udoReplacementValues = null;
        }
        return retVal;
    }

    @Override
    public String generateGlobalSco() {
        String retVal = this.bsbCompilationUnit.replaceBSBValues(this.getGlobalSco());
        return retVal;
    }

    private void doPreCompilation() {
        this.bsbCompilationUnit = new BSBCompilationUnit();
        this.graphicInterface.setupForCompilation(this.bsbCompilationUnit);
    }

    public static Instrument loadFromXML(Element data) throws Exception {
        BlueSynthBuilder bsb = new BlueSynthBuilder(false);
        InstrumentUtilities.initBasicFromXML(data, bsb);
        String editEnabledStr = data.getAttributeValue("editEnabled");
        if (editEnabledStr != null) {
            bsb.setEditEnabled(Boolean.valueOf(editEnabledStr));
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "globalOrc": {
                    bsb.setGlobalOrc(node.getTextString());
                    break;
                }
                case "globalSco": {
                    bsb.setGlobalSco(node.getTextString());
                    break;
                }
                case "instrumentText": {
                    bsb.setInstrumentText(node.getTextString());
                    break;
                }
                case "alwaysOnInstrumentText": {
                    bsb.setAlwaysOnInstrumentText(node.getTextString());
                    break;
                }
                case "graphicInterface": {
                    bsb.setGraphicInterface(BSBGraphicInterface.loadFromXML(node));
                    break;
                }
                case "presetGroup": {
                    bsb.setPresetGroup(PresetGroup.loadFromXML(node));
                    break;
                }
                case "bsbParameterList": 
                case "parameterList": {
                    bsb.parameterList = ParameterList.loadFromXML(node);
                    break;
                }
                case "opcodeList": {
                    bsb.opcodeList = OpcodeList.loadFromXML(node);
                }
            }
        }
        if (bsb.presetGroup == null) {
            bsb.presetGroup = new PresetGroup();
        }
        if (bsb.graphicInterface == null) {
            bsb.graphicInterface = new BSBGraphicInterface();
        }
        if (bsb.parameterList == null) {
            bsb.parameterList = new ParameterList();
        }
        if (bsb.opcodeList == null) {
            bsb.opcodeList = new OpcodeList();
        }
        bsb.graphicInterface.getRootGroup().setParameterList(bsb.parameterList);
        return bsb;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = InstrumentUtilities.getBasicXML(this);
        retVal.setAttribute("editEnabled", Boolean.toString(this.editEnabled));
        retVal.addElement("globalOrc").setText(this.getGlobalOrc());
        retVal.addElement("globalSco").setText(this.getGlobalSco());
        retVal.addElement("instrumentText").setText(this.getInstrumentText());
        retVal.addElement("alwaysOnInstrumentText").setText(this.getAlwaysOnInstrumentText());
        retVal.addElement(this.graphicInterface.saveAsXML());
        retVal.addElement(this.parameterList.saveAsXML());
        retVal.addElement(this.presetGroup.saveAsXML());
        retVal.addElement(this.opcodeList.saveAsXML());
        return retVal;
    }

    public String toString() {
        return this.name;
    }

    public BSBGraphicInterface getGraphicInterface() {
        return this.graphicInterface;
    }

    public void setGraphicInterface(BSBGraphicInterface graphicInterface) {
        this.graphicInterface = graphicInterface;
    }

    public String getInstrumentText() {
        return this.instrumentText;
    }

    public void setInstrumentText(String instrumentText) {
        this.instrumentText = instrumentText == null ? "" : instrumentText;
    }

    public String getAlwaysOnInstrumentText() {
        return this.alwaysOnInstrumentText;
    }

    public void setAlwaysOnInstrumentText(String alwaysOnInstrumentText) {
        this.alwaysOnInstrumentText = alwaysOnInstrumentText == null ? "" : alwaysOnInstrumentText;
    }

    public String getGlobalOrc() {
        return this.globalOrc;
    }

    public void setGlobalOrc(String globalOrc) {
        this.globalOrc = globalOrc;
    }

    public String getGlobalSco() {
        return this.globalSco;
    }

    public void setGlobalSco(String globalSco) {
        this.globalSco = globalSco;
    }

    public PresetGroup getPresetGroup() {
        return this.presetGroup;
    }

    public void setPresetGroup(PresetGroup presetGroup) {
        this.presetGroup = presetGroup;
    }

    @Override
    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void clearParameters() {
        this.graphicInterface.getRootGroup().resetSubChannels();
        this.parameterList = new ParameterList();
        this.graphicInterface.getRootGroup().setParameterList(this.parameterList);
    }

    public boolean isEditEnabled() {
        return this.editEnabled;
    }

    public void setEditEnabled(boolean editEnabled) {
        this.editEnabled = editEnabled;
    }

    public OpcodeList getOpcodeList() {
        return this.opcodeList;
    }

    public void setOpcodeList(OpcodeList opcodeList) {
        this.opcodeList = opcodeList;
    }

    @Override
    public ArrayList<StringChannel> getStringChannels() {
        ArrayList<StringChannel> stringChannels = new ArrayList<StringChannel>();
        this.graphicInterface.getRootGroup().getStringChannels(stringChannels);
        return stringChannels;
    }

    @Override
    public BlueSynthBuilder deepCopy() {
        return new BlueSynthBuilder(this);
    }
}

