/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.pianoRoll.Scale;
import electric.xml.Element;
import electric.xml.Elements;
import java.io.File;

public class TuningProcessor
implements NoteProcessor {
    Scale scale;
    int pfield = 4;

    public TuningProcessor() {
        this.scale = Scale.get12TET();
    }

    public TuningProcessor(TuningProcessor tp) {
        this.scale = new Scale(tp.scale);
        this.pfield = tp.pfield;
    }

    public String toString() {
        return "[tuning]";
    }

    @Override
    public void processNotes(NoteList in) throws NoteProcessorException {
        int pcount = 0;
        double freq = 0.0;
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            pcount = temp.getPCount();
            if (this.pfield < 1 || this.pfield > pcount) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
            String val = temp.getPField(this.pfield).trim();
            try {
                freq = this.convert(val, this.scale);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.scaleFileConvert"), this.pfield);
            }
            temp.setPField(Double.toString(freq), this.pfield);
        }
    }

    private double convert(String val, Scale scale) {
        double pch;
        int oct;
        int index = val.indexOf(46);
        if (index == -1) {
            oct = Integer.parseInt(val);
            pch = 0.0;
        } else {
            oct = Integer.parseInt(val.substring(0, index));
            pch = Double.parseDouble(val.substring(index + 1));
        }
        int pitchIndex = (int)pch;
        int numScaleDegrees = scale.getNumScaleDegrees();
        if (pitchIndex >= numScaleDegrees) {
            oct += pitchIndex / numScaleDegrees;
            pitchIndex %= numScaleDegrees;
        }
        return scale.getFrequency(oct, pitchIndex);
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        int p = Integer.parseInt(pfield);
        if (p > 3) {
            this.pfield = p;
        }
    }

    public static NoteProcessor loadFromXML(Element data) {
        TuningProcessor tp = new TuningProcessor();
        Elements nodes = data.getElements();
        double baseFreq = -1.0;
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            switch (node.getName()) {
                case "baseFrequency": {
                    baseFreq = Double.parseDouble(node.getTextString());
                    break;
                }
                case "pfield": {
                    tp.setPfield(node.getTextString());
                    break;
                }
                case "scale": {
                    Scale scale;
                    if (node.getElements().size() == 0) {
                        String scaleDir = BlueSystem.getUserConfigurationDirectory() + File.separator + "scl";
                        String scalePath = scaleDir + File.separator + node.getTextString();
                        File scaleFile = new File(scalePath);
                        scale = Scale.loadScale(scaleFile);
                    } else {
                        scale = Scale.loadFromXML(node);
                    }
                    tp.setScale(scale);
                }
            }
        }
        if (baseFreq > 0.0) {
            tp.getScale().setBaseFrequency(baseFreq);
        }
        return tp;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(Integer.toString(this.pfield));
        retVal.addElement(this.scale.saveAsXML());
        return retVal;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public String getBaseFrequency() {
        return Double.toString(this.scale.getBaseFrequency());
    }

    public void setBaseFrequency(String baseFrequency) {
        this.scale.setBaseFrequency(Double.parseDouble(baseFrequency));
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 30; ++i) {
            try {
                n.add(Note.createNote("i1 " + i + " " + i + " 6." + i + " 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        TuningProcessor tp = new TuningProcessor();
        tp.setPfield("4");
        try {
            tp.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    @Override
    public TuningProcessor deepCopy() {
        return new TuningProcessor(this);
    }
}

