/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;

public class SwitchProcessor
implements NoteProcessor {
    int pfield1 = 4;
    int pfield2 = 5;

    public SwitchProcessor() {
    }

    public SwitchProcessor(SwitchProcessor sp) {
        this.pfield1 = sp.pfield1;
        this.pfield2 = sp.pfield2;
    }

    public String toString() {
        return "[switch]";
    }

    public String getPfield1() {
        return Integer.toString(this.pfield1);
    }

    public void setPfield1(String pfield1) {
        this.pfield1 = Integer.parseInt(pfield1);
    }

    public String getPfield2() {
        return Integer.toString(this.pfield2);
    }

    public void setPfield2(String pfield2) {
        this.pfield2 = Integer.parseInt(pfield2);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        int pcount = 0;
        for (int i = 0; i < in.size(); ++i) {
            Note temp = (Note)in.get(i);
            pcount = temp.getPCount();
            if (this.pfield1 < 1 || this.pfield1 >= pcount) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield1);
            }
            if (this.pfield2 < 1 || this.pfield2 >= pcount) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield2);
            }
            String tempPField = temp.getPField(this.pfield1);
            temp.setPField(temp.getPField(this.pfield2), this.pfield1);
            temp.setPField(tempPField, this.pfield2);
        }
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i * 2 + " 2 3 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        SwitchProcessor sp = new SwitchProcessor();
        sp.setPfield1("5");
        sp.setPfield2("4");
        try {
            sp.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        SwitchProcessor ap = new SwitchProcessor();
        ap.setPfield1(data.getElement("pfield1").getTextString());
        ap.setPfield2(data.getElement("pfield2").getTextString());
        return ap;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield1").setText(this.getPfield1());
        retVal.addElement("pfield2").setText(this.getPfield2());
        return retVal;
    }

    @Override
    public SwitchProcessor deepCopy() {
        return new SwitchProcessor(this);
    }
}

