/*
 * Decompiled with CFR 0.152.
 */
package blue.utilities;

import blue.utilities.TextUtilities;

public class MidiUtilities {
    private static final String NOTE_TEMPLATE = "i<INSTR_ID> <START> <DUR> <KEY> <VELOCITY>";

    public static String processNoteTemplate(String noteTemplate, String instrId, double start, double duration, int key, int velocity) {
        String note = noteTemplate;
        String midiKey = Integer.toString(key);
        int scaleDegree = key % 12;
        String scaleDegreeStr = scaleDegree < 10 ? "0" + scaleDegree : Integer.toString(scaleDegree);
        String midiPch = key / 12 + 3 + "." + scaleDegreeStr;
        String midiOct = Double.toString((float)key / 12.0f + 3.0f);
        String midiCps = Double.toString(MidiUtilities.cpsmid(key));
        String midiVel = Integer.toString(velocity);
        double velf = velocity;
        String midiVelAmp = Double.toString(velf * velf / 16239.0 * 32768.0);
        note = TextUtilities.replaceAll(note, "<INSTR_ID>", instrId);
        note = TextUtilities.replaceAll(note, "<START>", Double.toString(start));
        note = TextUtilities.replaceAll(note, "<DUR>", Double.toString(duration));
        note = TextUtilities.replaceAll(note, "<KEY>", midiKey);
        note = TextUtilities.replaceAll(note, "<KEY_PCH>", midiPch);
        note = TextUtilities.replaceAll(note, "<KEY_OCT>", midiOct);
        note = TextUtilities.replaceAll(note, "<KEY_CPS>", midiCps);
        note = TextUtilities.replaceAll(note, "<VELOCITY>", midiVel);
        note = TextUtilities.replaceAll(note, "<VELOCITY_AMP>", midiVelAmp);
        return note;
    }

    public static double cpsmid(int midi) {
        return 440.0 * Math.exp(Math.log(2.0) * ((double)(midi - 69) / 12.0));
    }

    private static class MNote {
        public int velocity = -1;
        public double start = -1.0;

        private MNote() {
        }

        public void clear() {
            this.velocity = -1;
            this.start = -1.0;
        }
    }
}

