/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities.jconsole;

public class CommandHistory {
    private int length;
    private Node top;
    private Node current;
    private int capacity;

    public CommandHistory() {
        this(64);
    }

    public CommandHistory(int capacity) {
        this.current = this.top = new Node("");
        this.top.next = this.top;
        this.top.prev = this.top;
        this.length = 1;
        this.capacity = capacity;
    }

    public String getPrevCommand() {
        this.current = this.current.prev;
        return this.current.command;
    }

    public String getNextCommand() {
        this.current = this.current.next;
        return this.current.command;
    }

    public void add(String command) {
        Node oldPrev;
        this.current = this.top;
        if (this.top.prev.command.equals(command)) {
            return;
        }
        Node temp = new Node(command);
        temp.prev = oldPrev = this.top.prev;
        oldPrev.next = temp;
        temp.next = this.top;
        this.top.prev = temp;
        ++this.length;
        if (this.length > this.capacity) {
            Node newNext;
            this.top.next = newNext = this.top.next.next;
            newNext.prev = this.top;
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getLength() {
        return this.length;
    }

    private class Node {
        public String command;
        public Node next;
        public Node prev;

        public Node(String command) {
            this.command = command;
            this.next = null;
            this.prev = null;
        }
    }
}

