/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.csound.orc;

import blue.ui.editor.csound.orc.CsoundOrcTokenId;
import csound.manual.CsoundManualUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class CsoundOrcHLexer
implements Lexer<CsoundOrcTokenId> {
    private static final Map<String, CsoundOrcTokenId> keywords = new HashMap<String, CsoundOrcTokenId>();
    private static final Set<String> opcodeNames = CsoundManualUtilities.getOpcodeNames();
    private static final int EOF = -1;
    private LexerRestartInfo<CsoundOrcTokenId> info;
    private LexerInput input;
    TokenFactory<CsoundOrcTokenId> tokenFactory;

    private static final void addKeyword(CsoundOrcTokenId id) {
        keywords.put(id.getFixedText(), id);
    }

    public CsoundOrcHLexer(LexerRestartInfo<CsoundOrcTokenId> info) {
        this.info = info;
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
    }

    public Token<CsoundOrcTokenId> nextToken() {
        int ch = this.input.read();
        switch (ch) {
            case 34: {
                while (true) {
                    switch (this.input.read()) {
                        case 92: {
                            this.input.read();
                            break;
                        }
                        case 34: {
                            return this.token(CsoundOrcTokenId.STRING);
                        }
                        case -1: 
                        case 10: {
                            return this.token(CsoundOrcTokenId.ERROR);
                        }
                    }
                }
            }
            case 123: {
                if (this.input.read() == 123) {
                    while (true) {
                        switch (this.input.read()) {
                            case 125: {
                                if (this.input.read() == 125) {
                                    return this.token(CsoundOrcTokenId.STRING);
                                }
                                this.input.backup(1);
                                break;
                            }
                            case -1: {
                                return this.token(CsoundOrcTokenId.ERROR);
                            }
                        }
                    }
                }
                this.input.backup(1);
                return this.token(CsoundOrcTokenId.ERROR);
            }
            case 37: 
            case 42: 
            case 43: 
            case 45: {
                return this.token(CsoundOrcTokenId.OPERATOR);
            }
            case 47: {
                switch (this.input.read()) {
                    case 47: {
                        while (true) {
                            switch (this.input.read()) {
                                case 13: {
                                    this.input.consumeNewline();
                                }
                                case -1: 
                                case 10: {
                                    return this.token(CsoundOrcTokenId.SL_COMMENT);
                                }
                            }
                        }
                    }
                    case 42: {
                        do {
                            ch = this.input.read();
                            while (ch == 42) {
                                ch = this.input.read();
                                if (ch == 47) {
                                    return this.token(CsoundOrcTokenId.ML_COMMENT);
                                }
                                if (ch != -1) continue;
                                return this.token(CsoundOrcTokenId.ML_COMMENT_INCOMPLETE);
                            }
                        } while (ch != -1);
                        return this.token(CsoundOrcTokenId.ML_COMMENT_INCOMPLETE);
                    }
                }
                this.input.backup(1);
                return this.token(CsoundOrcTokenId.OPERATOR);
            }
            case 59: {
                while (true) {
                    switch (this.input.read()) {
                        case 13: {
                            this.input.consumeNewline();
                        }
                        case -1: 
                        case 10: {
                            return this.token(CsoundOrcTokenId.SL_COMMENT);
                        }
                    }
                }
            }
            case 40: {
                return this.token(CsoundOrcTokenId.LPAREN);
            }
            case 41: {
                return this.token(CsoundOrcTokenId.RPAREN);
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.finishIntOrFloatLiteral(ch);
            }
            case -1: {
                return null;
            }
        }
        if (Character.isWhitespace((char)ch)) {
            ch = this.input.read();
            while (ch != -1 && Character.isWhitespace((char)ch)) {
                ch = this.input.read();
            }
            this.input.backup(1);
            return this.token(CsoundOrcTokenId.WS);
        }
        if (Character.isLetter((char)ch)) {
            while (true) {
                if (ch == -1 || !Character.isLetter((char)ch) && !Character.isDigit((char)ch) && ch != 95) {
                    this.input.backup(1);
                    CharSequence word = this.input.readText();
                    CsoundOrcTokenId id = keywords.get(word);
                    if (id == null) {
                        id = opcodeNames.contains(word) ? CsoundOrcTokenId.OPCODE : CsoundOrcTokenId.CHAR;
                    }
                    return this.token(id);
                }
                ch = this.input.read();
            }
        }
        return this.token(CsoundOrcTokenId.CHAR);
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    private Token<CsoundOrcTokenId> finishIntOrFloatLiteral(int ch) {
        boolean floatLiteral = false;
        boolean inExponent = false;
        while (true) {
            switch (ch) {
                case 46: {
                    if (floatLiteral) {
                        return this.token(CsoundOrcTokenId.MYFLOAT);
                    }
                    floatLiteral = true;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                case 69: 
                case 101: {
                    if (inExponent) {
                        return this.token(CsoundOrcTokenId.MYFLOAT);
                    }
                    floatLiteral = true;
                    inExponent = true;
                    break;
                }
                default: {
                    this.input.backup(1);
                    return this.token(floatLiteral ? CsoundOrcTokenId.MYFLOAT : CsoundOrcTokenId.INT);
                }
            }
            ch = this.input.read();
        }
    }

    private Token<CsoundOrcTokenId> token(CsoundOrcTokenId id) {
        return id.getFixedText() != null ? this.tokenFactory.getFlyweightToken((TokenId)id, id.getFixedText()) : this.tokenFactory.createToken((TokenId)id);
    }

    static {
        CsoundOrcHLexer.addKeyword(CsoundOrcTokenId.INSTR_START);
        CsoundOrcHLexer.addKeyword(CsoundOrcTokenId.INSTR_END);
        CsoundOrcHLexer.addKeyword(CsoundOrcTokenId.OPCODE_START);
        CsoundOrcHLexer.addKeyword(CsoundOrcTokenId.OPCODE_END);
    }
}

