/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.soundObject.CeciliaModule;
import blue.soundObject.ceciliaModule.CSlider;
import blue.soundObject.ceciliaModule.CeciliaObject;
import blue.soundObject.editor.ceciliaModule.DisplayLabel;
import blue.soundObject.editor.ceciliaModule.FloatSlider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanel
extends JComponent
implements ChangeListener,
ActionListener {
    private HashMap labelMap = new HashMap();
    private HashMap sliderMap = new HashMap();
    private HashMap displayLabelMap = new HashMap();
    private HashMap dataValues = new HashMap();
    private int row = 0;
    private boolean updating = false;

    public SliderPanel() {
        this.setLayout(new GridBagLayout());
        this.addSpacerObject();
    }

    private void addSpacerObject() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 99;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.weighty = 1.0;
        constraints.fill = 1;
        JLabel verticalFillLabel = new JLabel();
        this.add((Component)verticalFillLabel, constraints);
    }

    public void clearSliders() {
        this.removeAll();
        this.labelMap.clear();
        this.sliderMap.clear();
        this.displayLabelMap.clear();
        this.dataValues.clear();
        this.row = 0;
        this.addSpacerObject();
    }

    public void addSlider(String name) {
        JLabel label = new JLabel(name);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.gridy = this.row;
        labelConstraints.insets = new Insets(10, 10, 0, 0);
        labelConstraints.anchor = 12;
        labelConstraints.fill = 0;
        this.add((Component)label, labelConstraints);
        FloatSlider slider = new FloatSlider();
        slider.addChangeListener(this);
        slider.addActionListener(this);
        slider.setName(name);
        GridBagConstraints itemConstraints = new GridBagConstraints();
        itemConstraints.gridx = 1;
        itemConstraints.gridy = this.row;
        itemConstraints.insets = new Insets(10, 10, 0, 10);
        itemConstraints.weightx = 1.0;
        itemConstraints.anchor = 17;
        itemConstraints.fill = 2;
        this.add((Component)slider, itemConstraints);
        DisplayLabel displayLabel = new DisplayLabel();
        GridBagConstraints displayLabelConstraints = new GridBagConstraints();
        displayLabelConstraints.gridx = 2;
        displayLabelConstraints.gridy = this.row++;
        displayLabelConstraints.insets = new Insets(10, 0, 0, 10);
        displayLabelConstraints.weightx = 0.0;
        displayLabelConstraints.anchor = 18;
        displayLabelConstraints.fill = 0;
        this.add((Component)displayLabel, displayLabelConstraints);
        this.labelMap.put(name, label);
        this.sliderMap.put(name, slider);
        this.displayLabelMap.put(name, displayLabel);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.updating) {
            FloatSlider fSlider = (FloatSlider)e.getSource();
            String name = fSlider.getName();
            CSlider slider = (CSlider)this.dataValues.get(name);
            DisplayLabel label = (DisplayLabel)this.displayLabelMap.get(name);
            if (slider != null) {
                float newValue = fSlider.getValueFromRange();
                float truncatedValue = newValue - newValue % slider.getResolution();
                slider.setValue(truncatedValue);
                label.setText(Float.toString(truncatedValue));
            }
        }
    }

    public void editCeciliaModule(CeciliaModule ceciliaModule) {
        this.updating = true;
        HashMap map = ceciliaModule.getStateData();
        if (map.size() == 0) {
            return;
        }
        for (CeciliaObject element : map.values()) {
            if (!(element instanceof CSlider)) continue;
            CSlider slider = (CSlider)element;
            this.setupCslider(slider);
        }
        this.updating = false;
    }

    private void setupCslider(CSlider slider) {
        JLabel label = (JLabel)this.labelMap.get(slider.getObjectName());
        label.setText(slider.getLabel());
        DisplayLabel displayLabel = (DisplayLabel)this.displayLabelMap.get(slider.getObjectName());
        displayLabel.setUnit(slider.getUnit());
        FloatSlider fSlider = (FloatSlider)this.sliderMap.get(slider.getObjectName());
        float max = slider.getMax();
        float min = slider.getMin();
        fSlider.setRangeMax(max);
        fSlider.setRangeMin(min);
        fSlider.setResolution(slider.getResolution());
        float val = (slider.getValue() - min) / (max - min);
        fSlider.setValue(val);
        this.dataValues.put(slider.getObjectName(), slider);
        displayLabel.setText(Float.toString(slider.getValue()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FloatSlider fSlider = (FloatSlider)e.getSource();
        String name = fSlider.getName();
        CSlider slider = (CSlider)this.dataValues.get(name);
        DisplayLabel label = (DisplayLabel)this.displayLabelMap.get(name);
        String command = e.getActionCommand();
        if (slider != null) {
            float val = slider.getValue();
            if (command.equals("nudgeLeft")) {
                val -= slider.getResolution();
            } else if (command.equals("nudgeRight")) {
                val += slider.getResolution();
            }
            slider.setValue(val);
            label.setText(Float.toString(val));
            float max = slider.getMax();
            float min = slider.getMin();
            float sliderVal = (val - min) / (max - min);
            fSlider.setValue(sliderVal);
        }
    }
}

