/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.BlueSystem;
import blue.soundObject.ceciliaModule.CFileIn;
import blue.ui.utilities.FileChooserManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;

class CFilePanel
extends JComponent {
    private static String FILE_MANAGER_GROUP = "CFilePanel";
    CFileIn cfilein;
    JTextField fileNameText;
    JSlider slider;
    JLabel offsetLabel;
    boolean isAudio;

    public CFilePanel(String objectName, boolean isAudio) {
        this.isAudio = isAudio;
        this.setBorder(BorderFactory.createTitledBorder(objectName));
        this.setLayout(new GridBagLayout());
        this.fileNameText = new JTextField();
        this.fileNameText.setEnabled(false);
        JLabel label = new JLabel(BlueSystem.getString((String)"ceciliaModule.file"));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        labelConstraints.insets = new Insets(10, 10, 0, 0);
        labelConstraints.anchor = 12;
        labelConstraints.fill = 0;
        this.add((Component)label, labelConstraints);
        GridBagConstraints itemConstraints = new GridBagConstraints();
        itemConstraints.gridx = 1;
        itemConstraints.gridy = 0;
        itemConstraints.insets = new Insets(10, 10, 0, 10);
        itemConstraints.weightx = 1.0;
        itemConstraints.anchor = 17;
        itemConstraints.fill = 2;
        this.add((Component)this.fileNameText, itemConstraints);
        JButton fileButton = new JButton("...");
        fileButton.addActionListener(e -> this.selectFile());
        itemConstraints = new GridBagConstraints();
        itemConstraints.gridx = 2;
        itemConstraints.gridy = 0;
        itemConstraints.insets = new Insets(10, 0, 0, 10);
        itemConstraints.anchor = 13;
        itemConstraints.fill = 0;
        this.add((Component)fileButton, itemConstraints);
        if (!isAudio) {
            return;
        }
        this.offsetLabel = new JLabel(BlueSystem.getString((String)"ceciliaModule.offset"));
        labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 1;
        labelConstraints.insets = new Insets(10, 10, 0, 0);
        labelConstraints.anchor = 12;
        labelConstraints.fill = 0;
        this.add((Component)this.offsetLabel, labelConstraints);
        this.slider = new JSlider();
        GridBagConstraints sliderConstraints = new GridBagConstraints();
        sliderConstraints.gridx = 1;
        sliderConstraints.gridy = 1;
        sliderConstraints.insets = new Insets(10, 10, 0, 10);
        sliderConstraints.weighty = 1.0;
        sliderConstraints.anchor = 17;
        sliderConstraints.fill = 2;
        this.add((Component)this.slider, sliderConstraints);
        this.slider.setEnabled(false);
        this.slider.setMinimum(0);
        this.slider.setValue(0);
        this.slider.addChangeListener(e -> {
            float val = (float)this.slider.getValue() / 10.0f;
            this.offsetLabel.setText(Float.toString(val) + "s");
            if (this.cfilein != null) {
                this.cfilein.setOffset(this.slider.getValue());
            }
        });
    }

    public void setCFileIn(CFileIn cfilein) {
        this.cfilein = cfilein;
        this.fileNameText.setText(cfilein.getFileName());
        if (this.isAudio) {
            this.setSliderData(cfilein);
        }
    }

    protected void selectFile() {
        FileChooserManager.getDefault().setDialogTitle((Object)FILE_MANAGER_GROUP, BlueSystem.getString((String)"ceciliaModule.chooseFile"));
        List retVal = FileChooserManager.getDefault().showOpenDialog((Object)FILE_MANAGER_GROUP, null);
        if (retVal.isEmpty()) {
            return;
        }
        File temp = (File)retVal.get(0);
        if (this.cfilein != null) {
            String path = temp.getAbsolutePath();
            this.cfilein.setFileName(path);
            this.fileNameText.setText(path);
        }
        if (this.isAudio) {
            this.setSliderData(this.cfilein);
        }
    }

    private void setSliderData(CFileIn cfilein) {
        if (cfilein.isAudioFile()) {
            this.slider.setValue(cfilein.getOffset());
            this.slider.setMinimum(0);
            this.slider.setMaximum(cfilein.getMaxTicks());
            this.slider.setEnabled(true);
        }
    }
}

