/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viz.DensiTree;
import viz.graphics.JFontChooser;
import viz.panel.RoundedButton;
import viz.util.Util;

public class CladePanel
extends JPanel
implements ChangeListener {
    public static final String HELP_SHOW_CLADES = "Show information for individual clades. This is only activated when the drawing style is not default. The default style is not clade based, so there is no information to position clade information.";
    public static final String HELP_SELECTED_ONLY = "Show information only for selected clades. Clades can be selected by clicking them in the DensiTree, or selecting them from the clade-bar (at botom of the screen).";
    public static final String HELP_MEAN = "Show mean height of clades as line or and/as text.";
    public static final String HELP_95HPD = "Show 95% highest probability density interval of the height of clades as bar and/or as text.";
    public static final String HELP_SUPPORT = "Show support of clade as cricle and/or as text. The support is the fraction of trees in the tree set that contain the clade.";
    public static final String HELP_DIGITS = "Number of significant digits to show clade information as text.";
    public static final String HELP_FONT = "Font used to show clade information as text.";
    public static final String HELP_COLOR = "Color used to show clade information as text.";
    private static final long serialVersionUID = 1L;
    DensiTree m_dt;
    SpinnerNumberModel significantDigitsModel;
    JCheckBox chckbxSelectionOnly = new JCheckBox("Selected only");
    JCheckBox chckbxShowClades = new JCheckBox("Show clades");
    JCheckBox chckbxMean = new JCheckBox("");
    JCheckBox checkBox = new JCheckBox("");
    JCheckBox chckbxhpd = new JCheckBox("");
    JCheckBox checkBox_1 = new JCheckBox("");
    JCheckBox chckbxSupport = new JCheckBox("");
    JCheckBox checkBox_2 = new JCheckBox("");
    JButton btnFont;
    JSpinner spinner;
    JButton btnColor;
    private final JLabel lblNewLabel = new JLabel("Smallest");
    private final JTextField textFieldSmallestClade = new JTextField();

    public CladePanel(DensiTree dt) {
        this.m_dt = dt;
        this.m_dt.addChangeListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[5];
        gridBagLayout.rowHeights = new int[12];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.chckbxSelectionOnly.setSelected(this.m_dt.m_cladeDrawer.m_bSelectedOnly);
        this.chckbxSelectionOnly.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_cladeDrawer.m_bSelectedOnly;
            this.m_dt.m_cladeDrawer.m_bSelectedOnly = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_cladeDrawer.m_bSelectedOnly) {
                this.m_dt.makeDirty();
            }
        });
        this.chckbxShowClades.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_bViewClades;
            this.m_dt.m_bViewClades = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_bViewClades) {
                this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_chckbxShowClades = new GridBagConstraints();
        gbc_chckbxShowClades.anchor = 17;
        gbc_chckbxShowClades.gridwidth = 3;
        gbc_chckbxShowClades.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxShowClades.gridx = 0;
        gbc_chckbxShowClades.gridy = 0;
        this.add((Component)this.chckbxShowClades, gbc_chckbxShowClades);
        this.chckbxSelectionOnly.setHorizontalAlignment(2);
        GridBagConstraints gbc_chckbxSelectionOnly = new GridBagConstraints();
        gbc_chckbxSelectionOnly.gridwidth = 3;
        gbc_chckbxSelectionOnly.anchor = 17;
        gbc_chckbxSelectionOnly.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxSelectionOnly.gridx = 0;
        gbc_chckbxSelectionOnly.gridy = 1;
        this.add((Component)this.chckbxSelectionOnly, gbc_chckbxSelectionOnly);
        JLabel btnDraw = new JLabel("draw");
        GridBagConstraints gbc_btnDraw = new GridBagConstraints();
        gbc_btnDraw.anchor = 13;
        gbc_btnDraw.gridwidth = 2;
        gbc_btnDraw.insets = new Insets(0, 0, 5, 5);
        gbc_btnDraw.gridx = 0;
        gbc_btnDraw.gridy = 2;
        this.add((Component)btnDraw, gbc_btnDraw);
        JLabel btnText = new JLabel("text");
        GridBagConstraints gbc_btnText = new GridBagConstraints();
        gbc_btnText.insets = new Insets(0, 0, 5, 5);
        gbc_btnText.gridx = 2;
        gbc_btnText.gridy = 2;
        this.add((Component)btnText, gbc_btnText);
        JLabel lblMean = new JLabel("Mean");
        lblMean.setHorizontalAlignment(2);
        GridBagConstraints gbc_lblMean = new GridBagConstraints();
        gbc_lblMean.anchor = 13;
        gbc_lblMean.insets = new Insets(0, 0, 5, 5);
        gbc_lblMean.gridx = 0;
        gbc_lblMean.gridy = 3;
        this.add((Component)lblMean, gbc_lblMean);
        this.chckbxMean.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_cladeDrawer.m_bDrawMean;
            this.m_dt.m_cladeDrawer.m_bDrawMean = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_cladeDrawer.m_bDrawMean) {
                this.m_dt.makeDirty();
            }
        });
        this.chckbxMean.setSelected(this.m_dt.m_cladeDrawer.m_bDrawMean);
        GridBagConstraints gbc_chckbxMean = new GridBagConstraints();
        gbc_chckbxMean.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxMean.gridx = 1;
        gbc_chckbxMean.gridy = 3;
        this.add((Component)this.chckbxMean, gbc_chckbxMean);
        this.checkBox.setSelected(this.m_dt.m_cladeDrawer.m_bTextMean);
        this.checkBox.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_cladeDrawer.m_bTextMean;
            this.m_dt.m_cladeDrawer.m_bTextMean = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_cladeDrawer.m_bTextMean) {
                this.m_dt.makeDirty();
            }
        });
        this.checkBox.setHorizontalAlignment(4);
        GridBagConstraints gbc_checkBox = new GridBagConstraints();
        gbc_checkBox.insets = new Insets(0, 0, 5, 5);
        gbc_checkBox.gridx = 2;
        gbc_checkBox.gridy = 3;
        this.add((Component)this.checkBox, gbc_checkBox);
        JLabel lblhpd = new JLabel("95%HPD");
        GridBagConstraints gbc_lblhpd = new GridBagConstraints();
        gbc_lblhpd.anchor = 13;
        gbc_lblhpd.insets = new Insets(0, 0, 5, 5);
        gbc_lblhpd.gridx = 0;
        gbc_lblhpd.gridy = 4;
        this.add((Component)lblhpd, gbc_lblhpd);
        this.chckbxhpd.setSelected(this.m_dt.m_cladeDrawer.m_bDraw95HPD);
        this.chckbxhpd.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_cladeDrawer.m_bDraw95HPD;
            this.m_dt.m_cladeDrawer.m_bDraw95HPD = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_cladeDrawer.m_bDraw95HPD) {
                this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_chckbxhpd = new GridBagConstraints();
        gbc_chckbxhpd.anchor = 11;
        gbc_chckbxhpd.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxhpd.gridx = 1;
        gbc_chckbxhpd.gridy = 4;
        this.add((Component)this.chckbxhpd, gbc_chckbxhpd);
        this.checkBox_1.setSelected(this.m_dt.m_cladeDrawer.m_bText95HPD);
        this.checkBox_1.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_cladeDrawer.m_bText95HPD;
            this.m_dt.m_cladeDrawer.m_bText95HPD = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_cladeDrawer.m_bText95HPD) {
                this.m_dt.makeDirty();
            }
        });
        this.checkBox_1.setHorizontalAlignment(4);
        GridBagConstraints gbc_checkBox_1 = new GridBagConstraints();
        gbc_checkBox_1.insets = new Insets(0, 0, 5, 5);
        gbc_checkBox_1.gridx = 2;
        gbc_checkBox_1.gridy = 4;
        this.add((Component)this.checkBox_1, gbc_checkBox_1);
        JLabel lblSupport = new JLabel("Support");
        GridBagConstraints gbc_lblSupport = new GridBagConstraints();
        gbc_lblSupport.anchor = 13;
        gbc_lblSupport.insets = new Insets(0, 0, 5, 5);
        gbc_lblSupport.gridx = 0;
        gbc_lblSupport.gridy = 5;
        this.add((Component)lblSupport, gbc_lblSupport);
        this.chckbxSupport.setSelected(this.m_dt.m_cladeDrawer.m_bDrawSupport);
        this.chckbxSupport.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_cladeDrawer.m_bDrawSupport;
            this.m_dt.m_cladeDrawer.m_bDrawSupport = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_cladeDrawer.m_bDrawSupport) {
                this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_chckbxSupport = new GridBagConstraints();
        gbc_chckbxSupport.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxSupport.gridx = 1;
        gbc_chckbxSupport.gridy = 5;
        this.add((Component)this.chckbxSupport, gbc_chckbxSupport);
        this.checkBox_2.setSelected(this.m_dt.m_cladeDrawer.m_bTextSupport);
        this.checkBox_2.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_cladeDrawer.m_bTextSupport;
            this.m_dt.m_cladeDrawer.m_bTextSupport = ((JCheckBox)e.getSource()).isSelected();
            if (bPrev != this.m_dt.m_cladeDrawer.m_bTextSupport) {
                this.m_dt.makeDirty();
            }
        });
        this.checkBox_2.setHorizontalAlignment(4);
        GridBagConstraints gbc_checkBox_2 = new GridBagConstraints();
        gbc_checkBox_2.insets = new Insets(0, 0, 5, 5);
        gbc_checkBox_2.gridx = 2;
        gbc_checkBox_2.gridy = 5;
        this.add((Component)this.checkBox_2, gbc_checkBox_2);
        JSeparator separator = new JSeparator();
        GridBagConstraints gbc_separator = new GridBagConstraints();
        gbc_separator.gridwidth = 4;
        gbc_separator.fill = 2;
        gbc_separator.insets = new Insets(0, 0, 5, 0);
        gbc_separator.gridx = 0;
        gbc_separator.gridy = 6;
        this.add((Component)separator, gbc_separator);
        JLabel lblDigits = new JLabel("Sign. Digits");
        GridBagConstraints gbc_lblDigits = new GridBagConstraints();
        gbc_lblDigits.gridwidth = 2;
        gbc_lblDigits.anchor = 13;
        gbc_lblDigits.insets = new Insets(0, 0, 5, 5);
        gbc_lblDigits.gridx = 0;
        gbc_lblDigits.gridy = 7;
        this.add((Component)lblDigits, gbc_lblDigits);
        this.significantDigitsModel = new SpinnerNumberModel(this.m_dt.m_cladeDrawer.m_nSignificantDigits, 0, 100, 1);
        this.significantDigitsModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CladePanel.this.m_dt.m_cladeDrawer.m_nSignificantDigits = (Integer)CladePanel.this.significantDigitsModel.getValue();
                CladePanel.this.m_dt.makeDirty();
            }
        });
        this.btnFont = new RoundedButton("Font");
        this.btnFont.addActionListener(e -> {
            int result;
            JFontChooser fontChooser = new JFontChooser();
            if (this.m_dt.m_cladeDrawer.m_font != null) {
                fontChooser.setSelectedFont(this.m_dt.m_cladeDrawer.m_font);
            }
            if ((result = fontChooser.showDialog(null)) == 0) {
                this.m_dt.m_cladeDrawer.m_font = fontChooser.getSelectedFont();
                this.m_dt.makeDirty();
                this.m_dt.repaint();
            }
        });
        this.spinner = new JSpinner(this.significantDigitsModel);
        GridBagConstraints gbc_spinner = new GridBagConstraints();
        gbc_spinner.anchor = 17;
        gbc_spinner.insets = new Insets(0, 0, 5, 5);
        gbc_spinner.gridx = 2;
        gbc_spinner.gridy = 7;
        this.add((Component)this.spinner, gbc_spinner);
        GridBagConstraints gbc_btnFont = new GridBagConstraints();
        gbc_btnFont.insets = new Insets(0, 0, 5, 5);
        gbc_btnFont.gridx = 0;
        gbc_btnFont.gridy = 8;
        this.add((Component)this.btnFont, gbc_btnFont);
        this.btnColor = new RoundedButton("Color");
        this.btnColor.addActionListener(e -> {
            Color newColor = JColorChooser.showDialog(this.m_dt.m_Panel, this.getName(), this.m_dt.m_cladeDrawer.m_color);
            if (newColor != null) {
                this.m_dt.m_cladeDrawer.m_color = newColor;
                this.m_dt.makeDirty();
            }
            this.m_dt.repaint();
        });
        GridBagConstraints gbc_btnColor = new GridBagConstraints();
        gbc_btnColor.gridwidth = 2;
        gbc_btnColor.insets = new Insets(0, 0, 5, 5);
        gbc_btnColor.gridx = 1;
        gbc_btnColor.gridy = 8;
        this.add((Component)this.btnColor, gbc_btnColor);
        this.stateChanged(null);
        this.setToolTipText(Util.formatToolTipAsHtml(HELP_SELECTED_ONLY));
        this.chckbxSelectionOnly.setToolTipText(Util.formatToolTipAsHtml(HELP_SELECTED_ONLY));
        this.chckbxShowClades.setToolTipText(Util.formatToolTipAsHtml(HELP_SHOW_CLADES));
        this.chckbxMean.setToolTipText(Util.formatToolTipAsHtml(HELP_MEAN));
        this.chckbxhpd.setToolTipText(Util.formatToolTipAsHtml(HELP_95HPD));
        this.chckbxSupport.setToolTipText(Util.formatToolTipAsHtml(HELP_SUPPORT));
        this.checkBox.setToolTipText(Util.formatToolTipAsHtml(HELP_MEAN));
        this.checkBox_1.setToolTipText(Util.formatToolTipAsHtml(HELP_95HPD));
        this.checkBox_2.setToolTipText(Util.formatToolTipAsHtml(HELP_SUPPORT));
        this.btnFont.setToolTipText(Util.formatToolTipAsHtml(HELP_FONT));
        this.spinner.setToolTipText(Util.formatToolTipAsHtml(HELP_DIGITS));
        this.btnColor.setToolTipText(Util.formatToolTipAsHtml(HELP_COLOR));
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 9;
        this.lblNewLabel.setToolTipText("Smallest clade support to be considered a clade");
        this.add((Component)this.lblNewLabel, gbc_lblNewLabel);
        this.textFieldSmallestClade.setText(String.valueOf(this.m_dt.m_smallestCladeSupport));
        this.textFieldSmallestClade.setColumns(3);
        this.textFieldSmallestClade.addActionListener(e -> {
            try {
                this.m_dt.m_smallestCladeSupport = Double.parseDouble(this.textFieldSmallestClade.getText());
                this.m_dt.updateCladeModel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        GridBagConstraints gbc_textFieldSmallestClade = new GridBagConstraints();
        gbc_textFieldSmallestClade.gridwidth = 2;
        gbc_textFieldSmallestClade.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldSmallestClade.fill = 2;
        gbc_textFieldSmallestClade.gridx = 1;
        gbc_textFieldSmallestClade.gridy = 9;
        this.add((Component)this.textFieldSmallestClade, gbc_textFieldSmallestClade);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setEnabled(this.m_dt.m_Xmode != 0);
        this.chckbxSelectionOnly.setEnabled(this.m_dt.m_Xmode != 0);
        this.chckbxShowClades.setEnabled(this.m_dt.m_Xmode != 0);
        this.chckbxMean.setEnabled(this.m_dt.m_Xmode != 0);
        this.checkBox.setEnabled(this.m_dt.m_Xmode != 0);
        this.chckbxhpd.setEnabled(this.m_dt.m_Xmode != 0);
        this.checkBox_1.setEnabled(this.m_dt.m_Xmode != 0);
        this.chckbxSupport.setEnabled(this.m_dt.m_Xmode != 0);
        this.checkBox_2.setEnabled(this.m_dt.m_Xmode != 0);
        this.btnFont.setEnabled(this.m_dt.m_Xmode != 0);
        this.spinner.setEnabled(this.m_dt.m_Xmode != 0);
        this.btnColor.setEnabled(this.m_dt.m_Xmode != 0);
    }
}

