/*
 * Decompiled with CFR 0.152.
 */
package viz;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Node {
    public float m_fLength = -1.0f;
    public float m_fPosX = 0.0f;
    public float m_fPosY = 0.0f;
    public int m_iLabel;
    public int m_iClade;
    private String m_sMetaData;
    private Map<String, Object> metaDataMap;
    public static Map<String, Double> g_minValue = new HashMap<String, Double>();
    public static Map<String, Double> g_maxValue = new HashMap<String, Double>();
    private List<Double> metaDataList;
    public static List<Double> g_minListValue = new ArrayList<Double>();
    public static List<Double> g_maxListValue = new ArrayList<Double>();
    public Object m_data = null;
    public Node m_left;
    public Node m_right;
    Node m_Parent = null;

    public int getNr() {
        return this.m_iLabel;
    }

    public Node getParent() {
        return this.m_Parent;
    }

    public void setParent(Node parent) {
        this.m_Parent = parent;
    }

    public boolean isRoot() {
        return this.m_Parent == null;
    }

    public boolean isLeaf() {
        return this.m_left == null;
    }

    int getNodeCount() {
        if (this.isLeaf()) {
            return 1;
        }
        return 1 + this.m_left.getNodeCount() + this.m_right.getNodeCount();
    }

    public String toShortNewick() {
        StringBuffer buf = new StringBuffer();
        if (this.m_left != null) {
            buf.append("(");
            buf.append(this.m_left.toShortNewick());
            if (this.m_right != null) {
                buf.append(',');
                buf.append(this.m_right.toShortNewick());
            }
            buf.append(")");
        } else {
            buf.append(this.m_iLabel);
        }
        return buf.toString();
    }

    public String toNewick() {
        StringBuffer buf = new StringBuffer();
        if (this.m_left != null) {
            buf.append("(");
            buf.append(this.m_left.toNewick());
            if (this.m_right != null) {
                buf.append(',');
                buf.append(this.m_right.toNewick());
            }
            buf.append(")");
        } else {
            buf.append(this.m_iLabel);
        }
        buf.append(":" + this.m_fLength);
        return buf.toString();
    }

    public String toNewickWithPos(double fMinLat, double fMaxLat, double fMinLong) {
        StringBuffer buf = new StringBuffer();
        if (this.m_left != null) {
            buf.append("(");
            buf.append(this.m_left.toNewickWithPos(fMinLat, fMaxLat, fMinLong));
            buf.append(',');
            buf.append(this.m_right.toNewickWithPos(fMinLat, fMaxLat, fMinLong));
            buf.append(")");
        } else {
            buf.append(this.m_iLabel);
        }
        buf.append("[pos=");
        DecimalFormat df = new DecimalFormat("#.##");
        buf.append(String.valueOf(df.format(this.toLongitude(this.m_fPosX, fMinLat, fMaxLat))) + "x" + df.format(this.toLatitude(this.m_fPosY, fMinLong)));
        buf.append(']');
        buf.append(":" + this.m_fLength);
        return buf.toString();
    }

    double toLongitude(double fPosX, double fMinLat, double fMaxLat) {
        return fMaxLat - fPosX + (fMaxLat - fMinLat) / 100.0;
    }

    double toLatitude(double fPosY, double fMinLong) {
        return fPosY + fMinLong;
    }

    public String toString(Vector<String> sLabels, boolean bShowMetaData) {
        StringBuffer buf = new StringBuffer();
        if (this.m_left != null) {
            buf.append("(");
            buf.append(this.m_left.toString(sLabels, bShowMetaData));
            if (this.m_right != null) {
                buf.append(',');
                buf.append(this.m_right.toString(sLabels, bShowMetaData));
            }
            buf.append(")");
        } else {
            buf.append(sLabels.elementAt(this.m_iLabel));
        }
        if (bShowMetaData && this.getMetaData() != null) {
            buf.append('[');
            buf.append(this.getMetaData());
            buf.append(']');
        }
        buf.append(":" + this.m_fLength);
        return buf.toString();
    }

    public String toString() {
        return this.toNewick();
    }

    public int drawDryWithSingleChild(float[] nX, float[] nY, int iPos, boolean[] bNeedsDrawing, boolean[] bSelection, float fOffset, float fScale) {
        if (this.isLeaf()) {
            bNeedsDrawing[0] = bSelection[this.m_iLabel];
        } else {
            float dX;
            boolean[] bChildNeedsDrawing = new boolean[2];
            iPos = this.m_left.drawDryWithSingleChild(nX, nY, iPos, bNeedsDrawing, bSelection, fOffset, fScale);
            bChildNeedsDrawing[0] = bNeedsDrawing[0];
            if (this.m_right != null) {
                iPos = this.m_right.drawDryWithSingleChild(nX, nY, iPos, bNeedsDrawing, bSelection, fOffset, fScale);
                bChildNeedsDrawing[1] = bNeedsDrawing[0];
                dX = this.m_fPosX - (this.m_left.m_fPosX + this.m_right.m_fPosX) / 2.0f;
            } else {
                bChildNeedsDrawing[1] = false;
                dX = this.m_fPosX - this.m_left.m_fPosX;
            }
            bNeedsDrawing[0] = false;
            if (bChildNeedsDrawing[0]) {
                nX[iPos] = this.m_left.m_fPosX;
                nY[iPos] = (this.m_left.m_fPosY - fOffset) * fScale;
                nX[++iPos] = nX[iPos - 1] + dX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                bNeedsDrawing[0] = true;
            } else {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
            }
            ++iPos;
            if (bChildNeedsDrawing[1]) {
                nX[iPos] = this.m_right.m_fPosX + dX;
                nY[iPos] = nY[iPos - 1];
                nX[++iPos] = this.m_right.m_fPosX;
                nY[iPos] = (this.m_right.m_fPosY - fOffset) * fScale;
                bNeedsDrawing[0] = true;
            } else {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
            }
            ++iPos;
            if (this.isRoot()) {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - this.m_fLength - fOffset) * fScale;
                ++iPos;
            }
        }
        return iPos;
    }

    public int drawDry(float[] nX, float[] nY, int iPos, boolean[] bNeedsDrawing, boolean[] bSelection, float fOffset, float fScale) {
        if (this.isLeaf()) {
            bNeedsDrawing[0] = bSelection[this.m_iLabel];
        } else {
            boolean[] bChildNeedsDrawing = new boolean[2];
            iPos = this.m_left.drawDry(nX, nY, iPos, bNeedsDrawing, bSelection, fOffset, fScale);
            bChildNeedsDrawing[0] = bNeedsDrawing[0];
            iPos = this.m_right.drawDry(nX, nY, iPos, bNeedsDrawing, bSelection, fOffset, fScale);
            bChildNeedsDrawing[1] = bNeedsDrawing[0];
            bNeedsDrawing[0] = false;
            iPos = (this.m_iLabel - bSelection.length) * 4;
            float dX = this.m_fPosX - (this.m_left.m_fPosX + this.m_right.m_fPosX) / 2.0f;
            if (bChildNeedsDrawing[0]) {
                nX[iPos] = this.m_left.m_fPosX;
                nY[iPos] = (this.m_left.m_fPosY - fOffset) * fScale;
                nX[++iPos] = nX[iPos - 1] + dX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                bNeedsDrawing[0] = true;
            } else {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
            }
            ++iPos;
            if (bChildNeedsDrawing[1]) {
                nX[iPos] = this.m_right.m_fPosX + dX;
                nY[iPos] = nY[iPos - 1];
                nX[++iPos] = this.m_right.m_fPosX;
                nY[iPos] = (this.m_right.m_fPosY - fOffset) * fScale;
                bNeedsDrawing[0] = true;
            } else {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
            }
            ++iPos;
            if (this.isRoot()) {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - this.m_fLength - fOffset) * fScale;
                ++iPos;
            }
        }
        return iPos;
    }

    public int drawDryCentralised(float[] nX, float[] nY, int iPos, boolean[] bNeedsDrawing, boolean[] bSelection, float fOffset, float fScale, float[] taxonData, float[] fPosX, float[] fNonCentralisedPosX, float[] cladePosition) {
        if (this.isLeaf()) {
            bNeedsDrawing[0] = bSelection[this.m_iLabel];
            taxonData[0] = this.m_fPosX = cladePosition[this.m_iLabel];
            fPosX[this.m_iLabel] = this.m_fPosX;
            fNonCentralisedPosX[this.m_iLabel] = this.m_fPosX;
            taxonData[1] = 1.0f;
        } else {
            boolean[] bChildNeedsDrawing = new boolean[2];
            float[] taxonDataLeft = new float[2];
            iPos = this.m_left.drawDryCentralised(nX, nY, iPos, bNeedsDrawing, bSelection, fOffset, fScale, taxonDataLeft, fPosX, fNonCentralisedPosX, cladePosition);
            bChildNeedsDrawing[0] = bNeedsDrawing[0];
            float[] taxonDataRight = new float[2];
            iPos = this.m_right.drawDryCentralised(nX, nY, iPos, bNeedsDrawing, bSelection, fOffset, fScale, taxonDataRight, fPosX, fNonCentralisedPosX, cladePosition);
            bChildNeedsDrawing[1] = bNeedsDrawing[0];
            taxonData[0] = taxonDataLeft[0] + taxonDataRight[0];
            taxonData[1] = taxonDataLeft[1] + taxonDataRight[1];
            bNeedsDrawing[0] = false;
            fNonCentralisedPosX[this.m_iLabel] = (fNonCentralisedPosX[this.m_left.m_iLabel] + fNonCentralisedPosX[this.m_right.m_iLabel]) / 2.0f;
            float dX = fNonCentralisedPosX[this.m_iLabel] - this.m_fPosX;
            fPosX[this.m_iLabel] = cladePosition[this.m_iClade] - dX;
            iPos = (this.m_iLabel - bSelection.length) * 4;
            if (bChildNeedsDrawing[0]) {
                nX[iPos] = fPosX[this.m_left.m_iLabel];
                nY[iPos] = (this.m_left.m_fPosY - fOffset) * fScale;
                nX[++iPos] = fPosX[this.m_iLabel];
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                bNeedsDrawing[0] = true;
            } else {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
            }
            ++iPos;
            if (bChildNeedsDrawing[1]) {
                nX[iPos] = fPosX[this.m_iLabel];
                nY[iPos] = nY[iPos - 1];
                nX[++iPos] = fPosX[this.m_right.m_iLabel];
                nY[iPos] = (this.m_right.m_fPosY - fOffset) * fScale;
                bNeedsDrawing[0] = true;
            } else {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
            }
            ++iPos;
            if (this.isRoot()) {
                nX[iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - fOffset) * fScale;
                nX[++iPos] = this.m_fPosX;
                nY[iPos] = (this.m_fPosY - this.m_fLength - fOffset) * fScale;
                ++iPos;
            }
        }
        return iPos;
    }

    public int getStarTreeCladeCenters(float[] cladeCenterX, float[] cladeCenterY, float fOffset, float fScale, float[] cladePosition, float fMaxPosition) {
        if (this.isLeaf()) {
            this.m_fPosX = cladePosition[this.m_iLabel];
            if ((double)this.m_fPosX > (double)fMaxPosition - 0.25) {
                this.m_fPosX = fMaxPosition - 0.25f;
            }
            if ((double)this.m_fPosX < 0.25) {
                this.m_fPosX = 0.25f;
            }
            cladeCenterX[this.m_iLabel] = this.m_fPosX;
            cladeCenterY[this.m_iLabel] = (this.m_fPosY - fOffset) * fScale;
            return 1;
        }
        int nNrOfNodesLeft = this.m_left.getStarTreeCladeCenters(cladeCenterX, cladeCenterY, fOffset, fScale, cladePosition, fMaxPosition);
        int nNrOfNodesRight = this.m_right.getStarTreeCladeCenters(cladeCenterX, cladeCenterY, fOffset, fScale, cladePosition, fMaxPosition);
        int nNrOfNodes = nNrOfNodesLeft + nNrOfNodesRight;
        cladeCenterX[this.m_iLabel] = ((float)nNrOfNodesLeft * cladeCenterX[this.m_left.m_iLabel] + (float)nNrOfNodesRight * cladeCenterX[this.m_right.m_iLabel]) / (float)nNrOfNodes;
        cladeCenterY[this.m_iLabel] = ((float)nNrOfNodesLeft * cladeCenterY[this.m_left.m_iLabel] + (float)nNrOfNodesRight * cladeCenterY[this.m_right.m_iLabel]) / (float)nNrOfNodes;
        return nNrOfNodes;
    }

    public boolean drawStarTree(float[] nX, float[] nY, float[] cladePosX, float[] cladePosY, float[] cladeCenterX, float[] cladeCenterY, boolean[] bSelection, float fOffset, float fScale) {
        if (this.isLeaf()) {
            cladePosX[this.m_iLabel] = this.m_fPosX;
            cladePosY[this.m_iLabel] = (this.m_fPosY - fOffset) * fScale;
            return bSelection[this.m_iLabel];
        }
        if (this.isRoot()) {
            cladePosX[this.m_iLabel] = cladeCenterX[this.m_iLabel];
            cladePosY[this.m_iLabel] = (this.m_fPosY - fOffset) * fScale;
        } else {
            float fParentPosX = cladePosX[this.m_Parent.m_iLabel];
            float fParentPosY = cladePosY[this.m_Parent.m_iLabel];
            float fCladeCenterX = cladeCenterX[this.m_iLabel];
            float fCladeCenterY = cladeCenterY[this.m_iLabel];
            cladePosY[this.m_iLabel] = (this.m_fPosY - fOffset) * fScale;
            cladePosX[this.m_iLabel] = fParentPosX + (fCladeCenterX - fParentPosX) * (cladePosY[this.m_iLabel] - fParentPosY) / (fCladeCenterY - fParentPosY);
        }
        boolean[] bChildNeedsDrawing = new boolean[]{this.m_left.drawStarTree(nX, nY, cladePosX, cladePosY, cladeCenterX, cladeCenterY, bSelection, fOffset, fScale), this.m_right.drawStarTree(nX, nY, cladePosX, cladePosY, cladeCenterX, cladeCenterY, bSelection, fOffset, fScale)};
        int iPos = (this.m_iLabel - bSelection.length) * 4;
        if (bChildNeedsDrawing[0]) {
            nX[iPos] = cladePosX[this.m_left.m_iLabel];
            nY[iPos] = cladePosY[this.m_left.m_iLabel];
            nX[++iPos] = cladePosX[this.m_iLabel];
            nY[iPos] = cladePosY[this.m_iLabel];
        } else {
            nX[iPos] = cladePosX[this.m_iLabel];
            nY[iPos] = cladePosY[this.m_iLabel];
            nX[++iPos] = cladePosX[this.m_iLabel];
            nY[iPos] = cladePosY[this.m_iLabel];
        }
        ++iPos;
        if (bChildNeedsDrawing[1]) {
            nX[iPos] = cladePosX[this.m_iLabel];
            nY[iPos] = cladePosY[this.m_iLabel];
            nX[++iPos] = cladePosX[this.m_right.m_iLabel];
            nY[iPos] = cladePosY[this.m_right.m_iLabel];
        } else {
            nX[iPos] = cladePosX[this.m_iLabel];
            nY[iPos] = cladePosY[this.m_iLabel];
            nX[++iPos] = cladePosX[this.m_iLabel];
            nY[iPos] = cladePosY[this.m_iLabel];
        }
        ++iPos;
        if (this.isRoot()) {
            nX[iPos] = cladePosX[this.m_iLabel];
            nY[iPos] = cladePosY[this.m_iLabel];
            nX[++iPos] = cladePosX[this.m_iLabel];
            nY[iPos] = (this.m_fPosY - this.m_fLength - fOffset) * fScale;
            ++iPos;
        }
        return bChildNeedsDrawing[0] || bChildNeedsDrawing[1];
    }

    public int sort() {
        if (this.m_left != null) {
            int iChild2;
            int iChild1 = this.m_left.sort();
            if (this.m_right != null && iChild1 > (iChild2 = this.m_right.sort())) {
                Node tmp = this.m_left;
                this.m_left = this.m_right;
                this.m_right = tmp;
                return iChild2;
            }
            return iChild1;
        }
        return this.m_iLabel;
    }

    public int labelInternalNodes(int iLabel) {
        if (this.isLeaf()) {
            return iLabel;
        }
        iLabel = this.m_left.labelInternalNodes(iLabel);
        if (this.m_right != null) {
            iLabel = this.m_right.labelInternalNodes(iLabel);
        }
        this.m_iLabel = iLabel++;
        return iLabel;
    }

    Node copy() {
        Node node = new Node();
        node.m_fLength = this.m_fLength;
        node.m_fPosX = this.m_fPosX;
        node.m_fPosY = this.m_fPosY;
        node.m_iLabel = this.m_iLabel;
        node.m_iClade = this.m_iClade;
        node.setMetaData(this.m_sMetaData);
        node.m_Parent = null;
        if (this.m_left != null) {
            node.m_left = this.m_left.copy();
            node.m_left.m_Parent = node;
            if (this.m_right != null) {
                node.m_right = this.m_right.copy();
                node.m_right.m_Parent = node;
            } else {
                node.m_right = null;
            }
        }
        return node;
    }

    float sigmoid(float fLength, float fMaxAngle) {
        if ((double)fLength < 1.0 * (double)fMaxAngle) {
            return 0.0f;
        }
        return 1.0f;
    }

    public int doAngleCorrection(float[] nX, float[] nY, int iPos, boolean[] bNeedsDrawing, boolean[] bSelection, float fMaxAngle) {
        if (this.isLeaf()) {
            bNeedsDrawing[0] = bSelection[this.m_iLabel];
        } else {
            float fWeight;
            boolean[] bChildNeedsDrawing = new boolean[2];
            iPos = this.m_left.doAngleCorrection(nX, nY, iPos, bNeedsDrawing, bSelection, fMaxAngle);
            bChildNeedsDrawing[0] = bNeedsDrawing[0];
            iPos = this.m_right.doAngleCorrection(nX, nY, iPos, bNeedsDrawing, bSelection, fMaxAngle);
            bChildNeedsDrawing[1] = bNeedsDrawing[0];
            bNeedsDrawing[0] = false;
            iPos = (this.m_iLabel - bSelection.length) * 4;
            if (bChildNeedsDrawing[0]) {
                if (!this.m_left.isLeaf()) {
                    fWeight = this.sigmoid(this.m_left.m_fLength / Math.abs(nX[iPos] - nX[iPos + 1]), fMaxAngle);
                    nX[iPos] = nX[iPos] * fWeight + nX[iPos + 1] * (1.0f - fWeight);
                    nX[(this.m_left.m_iLabel - bSelection.length) * 4 + 1] = nX[iPos];
                    nX[(this.m_left.m_iLabel - bSelection.length) * 4 + 2] = nX[iPos];
                }
                ++iPos;
                bNeedsDrawing[0] = true;
            } else {
                ++iPos;
            }
            ++iPos;
            if (bChildNeedsDrawing[1]) {
                ++iPos;
                if (!this.m_right.isLeaf()) {
                    fWeight = this.sigmoid(this.m_right.m_fLength / Math.abs(nX[iPos - 1] - nX[iPos]), fMaxAngle);
                    nX[iPos] = nX[iPos] * fWeight + nX[iPos - 1] * (1.0f - fWeight);
                    nX[(this.m_right.m_iLabel - bSelection.length) * 4 + 1] = nX[iPos];
                    nX[(this.m_right.m_iLabel - bSelection.length) * 4 + 2] = nX[iPos];
                }
                bNeedsDrawing[0] = true;
            } else {
                ++iPos;
            }
            ++iPos;
            if (this.isRoot()) {
                ++iPos;
                ++iPos;
            }
        }
        return iPos;
    }

    public String getMetaData() {
        return this.m_sMetaData;
    }

    public void setMetaData(String sMetaData) {
        this.m_sMetaData = sMetaData;
    }

    public void parseMetaData() {
        if (this.metaDataMap == null) {
            this.metaDataMap = new HashMap<String, Object>();
            this.metaDataList = new ArrayList<Double>();
        }
        int i = 0;
        int start = 1;
        try {
            while ((i = this.m_sMetaData.indexOf(61, i)) >= 0) {
                String key = this.m_sMetaData.substring(start, i).trim();
                String value = null;
                int k = 0;
                k = this.m_sMetaData.indexOf(61, i + 1);
                if (k >= 0) {
                    int j = this.m_sMetaData.lastIndexOf(44, k);
                    value = this.m_sMetaData.substring(i + 1, j);
                    start = j + 1;
                } else {
                    value = this.m_sMetaData.substring(i + 1);
                }
                if (value.length() > 0 && value.charAt(0) != '{') {
                    try {
                        Double dvalue = Double.parseDouble(value);
                        if (!g_minValue.containsKey(key)) {
                            g_minValue.put(key, dvalue);
                        } else if (g_minValue.get(key) > dvalue) {
                            g_minValue.put(key, dvalue);
                        }
                        if (!g_maxValue.containsKey(key)) {
                            g_maxValue.put(key, dvalue);
                        } else if (g_maxValue.get(key) < dvalue) {
                            g_maxValue.put(key, dvalue);
                        }
                        this.metaDataMap.put(key, dvalue);
                    }
                    catch (Exception e) {
                        this.metaDataMap.put(key, value);
                    }
                } else {
                    this.metaDataMap.put(key, value);
                }
                ++i;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        i = 0;
        start = 1;
        int iNumber = 0;
        Pattern pattern = Pattern.compile("((-?[0-9]+(\\.[0-9]+)?)([eE]-?[0-9]+)?)");
        try {
            while (i < this.m_sMetaData.length()) {
                char c = this.m_sMetaData.charAt(i);
                if (c >= '0' && c <= '9' || c == '+' || c == '-') {
                    String str = this.m_sMetaData.substring(i);
                    Matcher m = pattern.matcher(str);
                    m.find();
                    String mantissa = m.group(1);
                    i += mantissa.length();
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(mantissa);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                    this.metaDataList.add(value);
                    if (g_maxListValue.size() < this.metaDataList.size()) {
                        g_maxListValue.add(Double.NEGATIVE_INFINITY);
                        g_minListValue.add(Double.POSITIVE_INFINITY);
                    }
                    g_maxListValue.set(iNumber, Math.max(g_maxListValue.get(iNumber), value));
                    g_minListValue.set(iNumber, Math.min(g_minListValue.get(iNumber), value));
                    ++iNumber;
                    continue;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, Object> getMetaDataSet() {
        return this.metaDataMap;
    }

    public List<Double> getMetaDataList() {
        return this.metaDataList;
    }
}

