/*
 * Decompiled with CFR 0.152.
 */
package test.viz;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import org.fest.swing.finder.JFileChooserFinder;
import org.fest.swing.fixture.JFileChooserFixture;
import org.fest.swing.image.ScreenshotTaker;
import org.junit.Test;
import test.viz.DensiTreeBase;
import viz.DensiTree;
import viz.panel.BurninPanel;
import viz.panel.CladePanel;
import viz.panel.ColorPanel;
import viz.panel.ExpandablePanel;
import viz.panel.GeoPanel;
import viz.panel.GridPanel;
import viz.panel.LabelPanel;
import viz.panel.LineWidthPanel;
import viz.panel.ShowPanel;
import viz.util.Util;

public class DocumentationCreator
extends DensiTreeBase {
    @Test
    public void simpleTest() throws Exception {
        this.dtFrame.menuItemWithPath(new String[]{"File", "Load"}).click();
        JFileChooserFixture fileChooser = JFileChooserFinder.findFileChooser().using(this.robot());
        fileChooser.setCurrentDirectory(new File("examples"));
        fileChooser.selectFile(new File("ape.trees")).approve();
        Thread.sleep(3000L);
        ScreenshotTaker screenshotTaker = new ScreenshotTaker();
        new File("doc/screenshots/ShowPanel.png").delete();
        new File("doc/screenshots/GridPanel.png").delete();
        new File("doc/screenshots/LabelPanel.png").delete();
        new File("doc/screenshots/GeoPanel.png").delete();
        new File("doc/screenshots/LineWidthPanel.png").delete();
        new File("doc/screenshots/ColorPanel.png").delete();
        new File("doc/screenshots/BurninPanel.png").delete();
        new File("doc/screenshots/CladePanel.png").delete();
        new File("doc/screenshots/densitree.png").delete();
        screenshotTaker.saveComponentAsPng(this.dtFrame.target, "doc/screenshots/densitree.png");
        PrintStream out = new PrintStream(new File("doc/panels.tex"));
        this.createScreenShotOf("ShowPanel", screenshotTaker, out);
        this.createScreenShotOf("GridPanel", screenshotTaker, out);
        this.createScreenShotOf("LabelPanel", screenshotTaker, out);
        this.createScreenShotOf("GeoPanel", screenshotTaker, out);
        this.createScreenShotOf("LineWidthPanel", screenshotTaker, out);
        this.createScreenShotOf("ColorPanel", screenshotTaker, out);
        this.createScreenShotOf("BurninPanel", screenshotTaker, out);
        this.createScreenShotOf("CladePanel", screenshotTaker, out);
    }

    private void createScreenShotOf(String string, ScreenshotTaker screenshotTaker, PrintStream out) throws Exception {
        this.dtFrame.button(String.valueOf(string) + "Button").click();
        screenshotTaker.saveComponentAsPng(this.dtFrame.panel((String)string).target, "doc/screenshots/" + string + ".png");
        this.dtFrame.button(String.valueOf(string) + "Button").click();
        this.createDocumentation(((ExpandablePanel)this.dtFrame.panel((String)string).panel().target).m_panel, out);
    }

    void createDocumentation(PrintStream out) throws Exception {
        DensiTree dt = new DensiTree();
        this.createDocumentation(new ShowPanel(dt), out);
        this.createDocumentation(new GridPanel(dt), out);
        this.createDocumentation(new LabelPanel(dt), out);
        this.createDocumentation(new GeoPanel(dt), out);
        this.createDocumentation(new LineWidthPanel(dt), out);
        this.createDocumentation(new ColorPanel(dt), out);
        this.createDocumentation(new BurninPanel(dt), out);
        this.createDocumentation(new CladePanel(dt), out);
    }

    void createDocumentation(Object o, PrintStream out) throws Exception {
        Field[] fields;
        String _class = o.getClass().getName();
        _class = _class.substring(_class.lastIndexOf(46) + 1);
        _class = _class.replace("Panel", " Panel");
        out.println("\\subsubsection{" + _class + "}");
        out.println("\\begin{center}");
        out.println("\\includegraphics[width=0.25\\textwidth]{screenshots/" + _class.replaceAll(" ", "") + "}");
        out.println("\\end{center}");
        Field[] fieldArray = fields = o.getClass().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String name = field.getName();
            if (name.startsWith("HELP_")) {
                name = name.substring(4).toLowerCase();
                int i = 0;
                while (i < name.length()) {
                    if (name.charAt(i) == '_') {
                        out.print(' ');
                        char a = name.charAt(++i);
                        if (a >= 'a' && a <= 'z') {
                            a = (char)(a + 65 - 97);
                        }
                        out.print(a);
                    } else {
                        out.print(name.charAt(i));
                    }
                    ++i;
                }
                out.println(": ");
                out.println(Util.formatToolTipAsTeX(field.get(o).toString()));
                out.println();
            }
            ++n2;
        }
    }

    public static void main(String[] args) throws Exception {
        DocumentationCreator dc = new DocumentationCreator();
        dc.createDocumentation(System.out);
        System.err.println("Run as junit test to create screen shots");
    }
}

