/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.panels.StatusListener;
import jam.panels.StatusProvider;
import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;

public class StatusPanel
extends JPanel
implements StatusListener {
    public static final int NORMAL = 0;
    public static final int WORKING = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    private JLabel statusLabel = null;
    private String statusText = " ";
    private JButton statusButton;
    private int status = -1;
    private StatusProvider statusProvider = null;
    private Timer timer = null;
    private long lastUpdate;
    private boolean pendingUpdate = false;
    private String pendingText = "";
    private int current = 0;
    ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            StatusPanel.this.statusButton.setIcon(workingStatusIcons[StatusPanel.this.current]);
            StatusPanel.this.current++;
            if (StatusPanel.this.current >= workingStatusIcons.length) {
                StatusPanel.this.current = 0;
            }
            StatusPanel.this.pendingCheck();
        }
    };
    private static Icon normalStatusIcon = null;
    private static Icon normalStatusPressedIcon = null;
    private static Icon normalStatusRolloverIcon = null;
    private static Icon[] workingStatusIcons = null;
    private static Icon warningStatusIcon = null;
    private static Icon warningStatusPressedIcon = null;
    private static Icon warningStatusRolloverIcon = null;
    private static Icon errorStatusIcon = null;
    private static Icon errorStatusPressedIcon = null;
    private static Icon errorStatusRolloverIcon = null;

    public StatusPanel() {
        this((String)null);
    }

    public StatusPanel(String string) {
        this.setLayout(new BorderLayout(4, 4));
        if (string != null) {
            this.statusText = string;
            this.statusLabel = new JLabel(this.statusText);
            this.add((Component)this.statusLabel, "Center");
            this.statusLabel.setFont(UIManager.getFont("SmallSystemFont"));
        }
        this.statusButton = new JButton(normalStatusIcon);
        this.statusButton.setPreferredSize(new Dimension(16, 16));
        this.statusButton.putClientProperty("JButton.buttonType", "toolbar");
        this.statusButton.setBorderPainted(false);
        this.statusButton.setOpaque(false);
        this.statusButton.setRolloverEnabled(true);
        this.statusButton.setContentAreaFilled(false);
        this.statusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusPanel.this.statusButtonPressed();
            }
        });
        this.add((Component)this.statusButton, "West");
    }

    public void setStatusProvider(StatusProvider statusProvider) {
        this.stopAnimation();
        if (this.statusProvider != null) {
            this.statusProvider.removeStatusListener(this);
        }
        this.statusProvider = statusProvider;
        if (this.statusProvider != null) {
            this.statusProvider.addStatusListener(this);
        }
    }

    public void statusChanged(int n, String string) {
        boolean bl;
        boolean bl2 = bl = System.currentTimeMillis() - this.lastUpdate > 200L;
        if (this.status != n) {
            bl = true;
        }
        if (string.length() > 0 && (this.statusText.length() == 0 || this.statusText.equals(" "))) {
            bl = true;
        }
        this.setStatus(n);
        if (bl) {
            this.setStatusText(string);
            this.lastUpdate = System.currentTimeMillis();
        } else {
            this.pendingUpdate = true;
            this.pendingText = string;
        }
    }

    private void setStatusText(final String string) {
        this.statusText = string == null || string.length() == 0 ? " " : string;
        if (this.statusLabel != null) {
            this.invokeNow(new Runnable(){

                public void run() {
                    StatusPanel.this.statusLabel.setText(string);
                }
            });
        }
    }

    private void invokeNow(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private void setStatus(final int n) {
        if (n == this.status) {
            return;
        }
        this.status = n;
        this.stopAnimation();
        Runnable runnable = new Runnable(){

            public void run() {
                switch (n) {
                    case 0: {
                        StatusPanel.this.statusButton.setIcon(normalStatusIcon);
                        StatusPanel.this.statusButton.setPressedIcon(normalStatusPressedIcon);
                        StatusPanel.this.statusButton.setRolloverIcon(normalStatusRolloverIcon);
                        break;
                    }
                    case 1: {
                        StatusPanel.this.startAnimation();
                        break;
                    }
                    case 2: {
                        StatusPanel.this.statusButton.setIcon(warningStatusIcon);
                        StatusPanel.this.statusButton.setPressedIcon(warningStatusPressedIcon);
                        StatusPanel.this.statusButton.setRolloverIcon(warningStatusRolloverIcon);
                        break;
                    }
                    case 3: {
                        StatusPanel.this.statusButton.setIcon(errorStatusIcon);
                        StatusPanel.this.statusButton.setPressedIcon(errorStatusPressedIcon);
                        StatusPanel.this.statusButton.setRolloverIcon(errorStatusRolloverIcon);
                    }
                }
            }
        };
        this.invokeNow(runnable);
    }

    private void statusButtonPressed() {
        if (this.statusProvider != null) {
            this.statusProvider.fireStatusButtonPressed();
        }
    }

    private void startAnimation() {
        if (workingStatusIcons == null) {
            return;
        }
        this.listener.actionPerformed(null);
        this.timer = new Timer(100, this.listener);
        this.timer.setCoalesce(true);
        this.timer.start();
    }

    private void pendingCheck() {
        if (this.pendingUpdate) {
            this.setStatusText(this.pendingText);
        }
        this.pendingUpdate = false;
    }

    private void stopAnimation() {
        this.pendingCheck();
        this.current = 0;
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
    }

    static {
        try {
            workingStatusIcons = new Icon[12];
            StatusPanel.workingStatusIcons[0] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity1.png");
            StatusPanel.workingStatusIcons[1] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity2.png");
            StatusPanel.workingStatusIcons[2] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity3.png");
            StatusPanel.workingStatusIcons[3] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity4.png");
            StatusPanel.workingStatusIcons[4] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity5.png");
            StatusPanel.workingStatusIcons[5] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity6.png");
            StatusPanel.workingStatusIcons[6] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity7.png");
            StatusPanel.workingStatusIcons[7] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity8.png");
            StatusPanel.workingStatusIcons[8] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity9.png");
            StatusPanel.workingStatusIcons[9] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity10.png");
            StatusPanel.workingStatusIcons[10] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity11.png");
            StatusPanel.workingStatusIcons[11] = IconUtils.getIcon(StatusPanel.class, "images/activity/activity12.png");
        }
        catch (Exception exception) {
            workingStatusIcons = null;
        }
    }
}

