/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.mac.Utils;
import jam.panels.SearchPanelListener;
import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchPanel
extends JPanel {
    private ArrayList listeners = new ArrayList();
    private boolean searchTextEmpty = true;
    private final String emptyLabel;
    private boolean continuousSearch;
    private final JButton findButton;
    private final JTextField searchText;
    private final JButton cancelButton;
    private JComboBox comboBox;

    public SearchPanel(String string, boolean bl) {
        this(string, null, bl);
    }

    public SearchPanel(String string, final JPopupMenu jPopupMenu, boolean bl) {
        this.continuousSearch = bl;
        if (Utils.isMacOSX() && Utils.getMacOSXMajorVersionNumber() >= 5) {
            this.emptyLabel = "";
            this.findButton = null;
            this.cancelButton = null;
            this.searchText = new JTextField();
            this.searchText.setColumns(12);
            this.searchText.putClientProperty("JTextField.variant", "search");
            this.searchText.putClientProperty("JTextField.Search.FindPopup", jPopupMenu);
            this.searchText.putClientProperty("JTextField.Search.FindAction", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchPanel.this.searchTextChanged();
                }
            });
            this.searchText.putClientProperty("JTextField.Search.CancelAction", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchPanel.this.clearSearchText();
                }
            });
            this.add((Component)this.searchText, "Center");
        } else {
            this.emptyLabel = string;
            Icon icon = IconUtils.getIcon(SearchPanel.class, "images/search/find.png");
            Icon icon2 = IconUtils.getIcon(SearchPanel.class, "images/search/findPopup.png");
            Icon icon3 = IconUtils.getIcon(SearchPanel.class, "images/search/stop.png");
            Icon icon4 = IconUtils.getIcon(SearchPanel.class, "images/search/stopRollover.png");
            Icon icon5 = IconUtils.getIcon(SearchPanel.class, "images/search/stopPressed.png");
            this.setLayout(new BorderLayout(0, 0));
            if (jPopupMenu != null) {
                jPopupMenu.getSelectionModel().setSelectedIndex(0);
                this.findButton = new JButton(icon2);
                this.findButton.add(jPopupMenu);
                this.findButton.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        Component component = mouseEvent.getComponent();
                        jPopupMenu.show(component, 0, component.getHeight());
                    }
                });
            } else {
                this.findButton = new JButton(icon);
                this.findButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchPanel.this.searchText.requestFocusInWindow();
                    }
                });
            }
            this.findButton.setPreferredSize(new Dimension(this.findButton.getIcon().getIconWidth(), this.findButton.getIcon().getIconHeight()));
            this.findButton.putClientProperty("JButton.buttonType", "toolbar");
            this.findButton.setBorderPainted(false);
            this.findButton.setOpaque(false);
            this.findButton.setContentAreaFilled(false);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            jPanel.setOpaque(false);
            jPanel.add(this.findButton);
            this.searchText = new JTextField(string);
            this.searchText.setForeground(Color.lightGray);
            this.searchText.setBorder(null);
            this.cancelButton = new JButton(icon3);
            this.cancelButton.setRolloverEnabled(true);
            this.cancelButton.setRolloverIcon(icon4);
            this.cancelButton.setPressedIcon(icon5);
            this.cancelButton.setPreferredSize(new Dimension(icon3.getIconWidth(), icon3.getIconHeight()));
            this.cancelButton.putClientProperty("JButton.buttonType", "toolbar");
            this.cancelButton.setBorderPainted(false);
            this.cancelButton.setOpaque(false);
            this.cancelButton.setContentAreaFilled(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            jPanel2.setOpaque(false);
            jPanel2.add(this.cancelButton);
            this.add((Component)jPanel, "West");
            this.add((Component)this.searchText, "Center");
            this.add((Component)jPanel2, "East");
            this.setBackground(this.searchText.getBackground());
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
            this.setPreferredSize(new Dimension(120, 24));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchPanel.this.clearSearchText();
                    SearchPanel.this.checkSearchTextEmpty();
                }
            });
        }
        this.searchText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (SearchPanel.this.searchTextEmpty) {
                    SearchPanel.this.searchText.setText("");
                    SearchPanel.this.searchText.setForeground(Color.black);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                SearchPanel.this.checkSearchTextEmpty();
            }
        });
        this.searchText.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
            }
        });
        this.searchText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SearchPanel.this.searchTextChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SearchPanel.this.searchTextChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SearchPanel.this.searchTextChanged();
            }
        });
        this.searchText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (!SearchPanel.this.searchTextEmpty) {
                    if (keyEvent.getKeyCode() == 10) {
                        if (!SearchPanel.this.continuousSearch) {
                            SearchPanel.this.fireSearchStarted();
                        }
                    } else if (keyEvent.getKeyCode() == 27) {
                        SearchPanel.this.clearSearchText();
                    }
                }
                if (keyEvent.getKeyCode() == 40 && SearchPanel.this.comboBox != null) {
                    n = SearchPanel.this.comboBox.getSelectedIndex();
                    if (n < SearchPanel.this.comboBox.getItemCount() - 1) {
                        ++n;
                    }
                    SearchPanel.this.comboBox.setSelectedIndex(n);
                    keyEvent.consume();
                }
                if (keyEvent.getKeyCode() == 38 && SearchPanel.this.comboBox != null) {
                    n = SearchPanel.this.comboBox.getSelectedIndex();
                    if (n > 0) {
                        --n;
                    }
                    SearchPanel.this.comboBox.setSelectedIndex(n);
                    keyEvent.consume();
                }
            }
        });
    }

    public JTextField getSearchText() {
        return this.searchText;
    }

    private void checkSearchTextEmpty() {
        String string = this.searchText.getText().trim();
        if (string.length() == 0) {
            this.searchTextEmpty = true;
        }
        if (this.searchTextEmpty) {
            this.searchText.setForeground(Color.lightGray);
            this.searchText.setText(this.emptyLabel);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.findButton != null) {
            this.findButton.setEnabled(bl);
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.searchText.setToolTipText(string);
        if (this.findButton != null) {
            this.findButton.setToolTipText(string);
        }
    }

    public void setFindIcon(Icon icon) {
        if (this.findButton != null) {
            this.findButton.setIcon(icon);
        }
    }

    public void addSearchPanelListener(SearchPanelListener searchPanelListener) {
        this.listeners.add(searchPanelListener);
    }

    public void removeDataSourceListener(SearchPanelListener searchPanelListener) {
        this.listeners.remove(searchPanelListener);
    }

    public boolean requestFocusInWindow() {
        return this.searchText.requestFocusInWindow();
    }

    public void removeAllDataSourceListeners() {
        this.listeners.clear();
    }

    private void clearSearchText() {
        this.searchText.setText("");
        this.searchTextChanged();
    }

    private void fireSearchStarted() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SearchPanelListener)iterator.next()).searchStarted(this.searchText.getText());
        }
    }

    private void fireSearchStopped() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((SearchPanelListener)iterator.next()).searchStopped();
        }
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        if (jComboBox != null) {
            jComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    SearchPanel.this.requestFocusInWindow();
                    SearchPanel.this.searchTextChanged();
                }
            });
        }
    }

    private void searchTextChanged() {
        if (this.searchText.isFocusOwner()) {
            this.searchTextEmpty = this.searchText.getText().length() == 0;
        }
        this.fireSearchTextChanged();
    }

    public void fireSearchTextChanged() {
        if (this.searchTextEmpty) {
            if (this.cancelButton != null) {
                this.cancelButton.setVisible(false);
            }
            if (this.continuousSearch) {
                this.fireSearchStopped();
            }
        } else {
            if (this.cancelButton != null) {
                this.cancelButton.setVisible(true);
            }
            if (this.continuousSearch) {
                this.fireSearchStarted();
            }
        }
    }
}

