/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.special;

import org.apache.commons.math.MathException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.util.ContinuedFraction;

public class Gamma {
    public static final double GAMMA = 0.5772156649015329;
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final double[] LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;

    private Gamma() {
    }

    public static double logGamma(double d) {
        double d2;
        if (Double.isNaN(d) || d <= 0.0) {
            d2 = Double.NaN;
        } else {
            double d3 = 4.7421875;
            double d4 = 0.0;
            for (int i = LANCZOS.length - 1; i > 0; --i) {
                d4 += LANCZOS[i] / (d + (double)i);
            }
            double d5 = d + d3 + 0.5;
            d2 = (d + 0.5) * Math.log(d5) - d5 + HALF_LOG_2_PI + Math.log((d4 += LANCZOS[0]) / d);
        }
        return d2;
    }

    public static double regularizedGammaP(double d, double d2) throws MathException {
        return Gamma.regularizedGammaP(d, d2, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedGammaP(double d, double d2, double d3, int n) throws MathException {
        double d4;
        if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 < 0.0) {
            d4 = Double.NaN;
        } else if (d2 == 0.0) {
            d4 = 0.0;
        } else if (d2 >= d + 1.0) {
            d4 = 1.0 - Gamma.regularizedGammaQ(d, d2, d3, n);
        } else {
            double d5;
            double d6;
            double d7 = 0.0;
            for (d5 = d6 = 1.0 / d; Math.abs(d6 / d5) > d3 && d7 < (double)n && d5 < Double.POSITIVE_INFINITY; d5 += (d6 *= d2 / (d + (d7 += 1.0)))) {
            }
            if (d7 >= (double)n) {
                throw new MaxIterationsExceededException(n);
            }
            d4 = Double.isInfinite(d5) ? 1.0 : Math.exp(-d2 + d * Math.log(d2) - Gamma.logGamma(d)) * d5;
        }
        return d4;
    }

    public static double regularizedGammaQ(double d, double d2) throws MathException {
        return Gamma.regularizedGammaQ(d, d2, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedGammaQ(final double d, double d2, double d3, int n) throws MathException {
        double d4;
        if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 < 0.0) {
            d4 = Double.NaN;
        } else if (d2 == 0.0) {
            d4 = 1.0;
        } else if (d2 < d + 1.0) {
            d4 = 1.0 - Gamma.regularizedGammaP(d, d2, d3, n);
        } else {
            ContinuedFraction continuedFraction = new ContinuedFraction(){

                @Override
                protected double getA(int n, double d2) {
                    return 2.0 * (double)n + 1.0 - d + d2;
                }

                @Override
                protected double getB(int n, double d2) {
                    return (double)n * (d - (double)n);
                }
            };
            d4 = 1.0 / continuedFraction.evaluate(d2, d3, n);
            d4 = Math.exp(-d2 + d * Math.log(d2) - Gamma.logGamma(d)) * d4;
        }
        return d4;
    }

    public static double digamma(double d) {
        if (d > 0.0 && d <= 1.0E-5) {
            return -0.5772156649015329 - 1.0 / d;
        }
        if (d >= 49.0) {
            double d2 = 1.0 / (d * d);
            return Math.log(d) - 0.5 / d - d2 * (0.08333333333333333 + d2 * (0.008333333333333333 - d2 / 252.0));
        }
        return Gamma.digamma(d + 1.0) - 1.0 / d;
    }

    public static double trigamma(double d) {
        if (d > 0.0 && d <= 1.0E-5) {
            return 1.0 / (d * d);
        }
        if (d >= 49.0) {
            double d2 = 1.0 / (d * d);
            return 1.0 / d + d2 / 2.0 + d2 / d * (0.16666666666666666 - d2 * (0.03333333333333333 + d2 / 42.0));
        }
        return Gamma.trigamma(d + 1.0) + 1.0 / (d * d);
    }
}

