/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.WeibullDistribution;

public class WeibullDistributionImpl
extends AbstractContinuousDistribution
implements WeibullDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private double shape;
    private double scale;
    private final double solverAbsoluteAccuracy;

    public WeibullDistributionImpl(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public WeibullDistributionImpl(double d, double d2, double d3) {
        this.setShapeInternal(d);
        this.setScaleInternal(d2);
        this.solverAbsoluteAccuracy = d3;
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = d <= 0.0 ? 0.0 : 1.0 - Math.exp(-Math.pow(d / this.scale, this.shape));
        return d2;
    }

    @Override
    public double getShape() {
        return this.shape;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        double d2 = d / this.scale;
        double d3 = Math.pow(d2, this.shape - 1.0);
        double d4 = d3 * d2;
        return this.shape / this.scale * d3 * Math.exp(-d4);
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", d, 0.0, 1.0);
        }
        double d2 = d == 0.0 ? 0.0 : (d == 1.0 ? Double.POSITIVE_INFINITY : this.scale * Math.pow(-Math.log(1.0 - d), 1.0 / this.shape));
        return d2;
    }

    @Override
    @Deprecated
    public void setShape(double d) {
        this.setShapeInternal(d);
    }

    private void setShapeInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("shape must be positive ({0})", d);
        }
        this.shape = d;
    }

    @Override
    @Deprecated
    public void setScale(double d) {
        this.setScaleInternal(d);
    }

    private void setScaleInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("scale must be positive ({0})", d);
        }
        this.scale = d;
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return 0.0;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        return Double.MAX_VALUE;
    }

    @Override
    protected double getInitialDomain(double d) {
        return Math.pow(this.scale * Math.log(2.0), 1.0 / this.shape);
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

