/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.apache.commons.math.distribution.PoissonDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.special.Gamma;

public class PoissonDistributionImpl
extends AbstractIntegerDistribution
implements PoissonDistribution,
Serializable {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private NormalDistribution normal;
    private double mean;
    private int maxIterations = 10000000;
    private double epsilon = 1.0E-12;

    public PoissonDistributionImpl(double d) {
        this(d, new NormalDistributionImpl());
    }

    public PoissonDistributionImpl(double d, double d2, int n) {
        this.setMean(d);
        this.epsilon = d2;
        this.maxIterations = n;
    }

    public PoissonDistributionImpl(double d, double d2) {
        this.setMean(d);
        this.epsilon = d2;
    }

    public PoissonDistributionImpl(double d, int n) {
        this.setMean(d);
        this.maxIterations = n;
    }

    @Deprecated
    public PoissonDistributionImpl(double d, NormalDistribution normalDistribution) {
        this.setNormalAndMeanInternal(normalDistribution, d);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    @Deprecated
    public void setMean(double d) {
        this.setNormalAndMeanInternal(this.normal, d);
    }

    private void setNormalAndMeanInternal(NormalDistribution normalDistribution, double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("the Poisson mean must be positive ({0})", d);
        }
        this.mean = d;
        this.normal = normalDistribution;
        this.normal.setMean(d);
        this.normal.setStandardDeviation(Math.sqrt(d));
    }

    @Override
    public double probability(int n) {
        double d = n < 0 || n == Integer.MAX_VALUE ? 0.0 : (n == 0 ? Math.exp(-this.mean) : Math.exp(-SaddlePointExpansion.getStirlingError(n) - SaddlePointExpansion.getDeviancePart(n, this.mean)) / Math.sqrt(Math.PI * 2 * (double)n));
        return d;
    }

    @Override
    public double cumulativeProbability(int n) throws MathException {
        if (n < 0) {
            return 0.0;
        }
        if (n == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)n + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    @Override
    public double normalApproximateProbability(int n) throws MathException {
        return this.normal.cumulativeProbability((double)n + 0.5);
    }

    @Override
    protected int getDomainLowerBound(double d) {
        return 0;
    }

    @Override
    protected int getDomainUpperBound(double d) {
        return Integer.MAX_VALUE;
    }

    @Deprecated
    public void setNormal(NormalDistribution normalDistribution) {
        this.setNormalAndMeanInternal(normalDistribution, this.mean);
    }
}

