/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergingAlgorithmImpl;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolver;

public abstract class UnivariateRealSolverImpl
extends ConvergingAlgorithmImpl
implements UnivariateRealSolver {
    protected double functionValueAccuracy;
    protected double defaultFunctionValueAccuracy;
    protected boolean resultComputed = false;
    protected double result;
    protected double functionValue;
    @Deprecated
    protected UnivariateRealFunction f;

    @Deprecated
    protected UnivariateRealSolverImpl(UnivariateRealFunction univariateRealFunction, int n, double d) {
        super(n, d);
        if (univariateRealFunction == null) {
            throw MathRuntimeException.createIllegalArgumentException("function to solve cannot be null", new Object[0]);
        }
        this.f = univariateRealFunction;
        this.functionValueAccuracy = this.defaultFunctionValueAccuracy = 1.0E-15;
    }

    protected UnivariateRealSolverImpl(int n, double d) {
        super(n, d);
        this.functionValueAccuracy = this.defaultFunctionValueAccuracy = 1.0E-15;
    }

    protected void checkResultComputed() throws IllegalStateException {
        if (!this.resultComputed) {
            throw MathRuntimeException.createIllegalStateException("no result available", new Object[0]);
        }
    }

    @Override
    public double getResult() {
        this.checkResultComputed();
        return this.result;
    }

    @Override
    public double getFunctionValue() {
        this.checkResultComputed();
        return this.functionValue;
    }

    @Override
    public void setFunctionValueAccuracy(double d) {
        this.functionValueAccuracy = d;
    }

    @Override
    public double getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    @Override
    public void resetFunctionValueAccuracy() {
        this.functionValueAccuracy = this.defaultFunctionValueAccuracy;
    }

    protected final void setResult(double d, int n) {
        this.result = d;
        this.iterationCount = n;
        this.resultComputed = true;
    }

    protected final void setResult(double d, double d2, int n) {
        this.result = d;
        this.functionValue = d2;
        this.iterationCount = n;
        this.resultComputed = true;
    }

    protected final void clearResult() {
        this.iterationCount = 0;
        this.resultComputed = false;
    }

    protected boolean isBracketing(double d, double d2, UnivariateRealFunction univariateRealFunction) throws FunctionEvaluationException {
        double d3 = univariateRealFunction.value(d);
        double d4 = univariateRealFunction.value(d2);
        return d3 > 0.0 && d4 < 0.0 || d3 < 0.0 && d4 > 0.0;
    }

    protected boolean isSequence(double d, double d2, double d3) {
        return d < d2 && d2 < d3;
    }

    protected void verifyInterval(double d, double d2) {
        if (d >= d2) {
            throw MathRuntimeException.createIllegalArgumentException("endpoints do not specify an interval: [{0}, {1}]", d, d2);
        }
    }

    protected void verifySequence(double d, double d2, double d3) {
        if (!this.isSequence(d, d2, d3)) {
            throw MathRuntimeException.createIllegalArgumentException("invalid interval, initial value parameters:  lower={0}, initial={1}, upper={2}", d, d2, d3);
        }
    }

    protected void verifyBracketing(double d, double d2, UnivariateRealFunction univariateRealFunction) throws FunctionEvaluationException {
        this.verifyInterval(d, d2);
        if (!this.isBracketing(d, d2, univariateRealFunction)) {
            throw MathRuntimeException.createIllegalArgumentException("function values at endpoints do not have different signs.  Endpoints: [{0}, {1}], Values: [{2}, {3}]", d, d2, univariateRealFunction.value(d), univariateRealFunction.value(d2));
        }
    }
}

