/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.AbstractFrame;
import jam.framework.MenuBarFactory;
import jam.framework.MenuFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;

public class DefaultMenuBarFactory
implements MenuBarFactory {
    private final List<MenuFactory> menuFactories = new ArrayList<MenuFactory>();
    private final List<MenuFactory> permanentMenuFactories = new ArrayList<MenuFactory>();
    private boolean populatedMenu = false;
    private JMenuBar menuBar = null;
    AbstractFrame frame = null;

    @Override
    public final void populateMenuBar(JMenuBar menuBar, AbstractFrame frame) {
        JMenu menu;
        String name;
        this.menuBar = menuBar;
        this.frame = frame;
        HashMap<String, JMenu> menus = new HashMap<String, JMenu>();
        TreeMap<Integer, String> order = new TreeMap<Integer, String>();
        int leftOrder = 0;
        int centerOrder = 1000;
        int rightOrder = 10000;
        ArrayList<MenuFactory> l = new ArrayList<MenuFactory>();
        l.addAll(this.menuFactories);
        l.addAll(this.permanentMenuFactories);
        for (MenuFactory menuFactory : l) {
            name = menuFactory.getMenuName();
            menu = (JMenu)menus.get(name);
            if (menu == null) {
                int alignment = menuFactory.getPreferredAlignment();
                menu = new JMenu(name);
                menus.put(name, menu);
                switch (alignment) {
                    case 0: {
                        order.put(new Integer(leftOrder), name);
                        ++leftOrder;
                        break;
                    }
                    case 1: {
                        order.put(new Integer(centerOrder), name);
                        ++centerOrder;
                        break;
                    }
                    case 2: {
                        order.put(new Integer(rightOrder), name);
                        ++rightOrder;
                    }
                }
            }
            menuFactory.populateMenu(menu, frame);
        }
        Iterator<Object> iterator = order.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            name = (String)order.get(i);
            menu = (JMenu)menus.get(name);
            menuBar.add(menu);
        }
        this.populatedMenu = true;
    }

    @Override
    public final void deregisterMenuFactories() {
        this.menuFactories.removeAll(this.menuFactories);
    }

    @Override
    public final void registerPermanentMenuFactory(MenuFactory menuFactory) {
        this.permanentMenuFactories.add(menuFactory);
        if (this.populatedMenu) {
            this.menuBar.removeAll();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultMenuBarFactory.this.populateMenuBar(DefaultMenuBarFactory.this.menuBar, DefaultMenuBarFactory.this.frame);
                    DefaultMenuBarFactory.this.frame.setJMenuBar(DefaultMenuBarFactory.this.menuBar);
                }
            });
        }
    }

    @Override
    public final void registerMenuFactory(MenuFactory menuFactory) {
        this.menuFactories.add(menuFactory);
        if (this.populatedMenu) {
            this.menuBar.removeAll();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultMenuBarFactory.this.populateMenuBar(DefaultMenuBarFactory.this.menuBar, DefaultMenuBarFactory.this.frame);
                    DefaultMenuBarFactory.this.frame.setJMenuBar(DefaultMenuBarFactory.this.menuBar);
                }
            });
        }
    }
}

