/*
 * Decompiled with CFR 0.152.
 */
package jam.controlpalettes;

import jam.controlpalettes.ControlPalette;
import jam.controlpalettes.ControlPaletteListener;
import jam.controlpalettes.Controller;
import jam.controlpalettes.ControllerListener;
import jam.controlpalettes.PinnedButton;
import jam.disclosure.DisclosureListener;
import jam.disclosure.DisclosurePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class BasicControlPalette
extends JPanel
implements ControlPalette {
    public static final int DEFAULT_OPENING_SPEED = 100;
    private ControllerListener controllerListener = new ControllerListener(){

        @Override
        public void controlsChanged() {
            BasicControlPalette.this.layoutControls();
        }
    };
    private final List<ControlPaletteListener> listeners = new ArrayList<ControlPaletteListener>();
    private int preferredWidth;
    private int preferredTitleHeight = 22;
    private DisplayMode displayMode;
    private final int openingSpeed;
    private int currentlyOpen = 0;
    private List<Controller> controllers = new ArrayList<Controller>();
    private List<DisclosurePanel> disclosurePanels = new ArrayList<DisclosurePanel>();
    private List<ControlsState> controlsStates = new ArrayList<ControlsState>();

    public BasicControlPalette(int preferredWidth) {
        this(preferredWidth, DisplayMode.ONLY_ONE_OPEN, 100);
    }

    public BasicControlPalette(int preferredWidth, DisplayMode displayMode) {
        this(preferredWidth, displayMode, 100);
    }

    public BasicControlPalette(int preferredWidth, DisplayMode displayMode, int openingSpeed) {
        this.preferredWidth = preferredWidth;
        this.displayMode = displayMode;
        this.openingSpeed = openingSpeed;
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, super.getPreferredSize().height);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.preferredWidth, super.getMaximumSize().height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.preferredWidth, super.getMaximumSize().height);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addController(Controller controller) {
        this.controllers.add(controller);
        controller.addControllerListener(this.controllerListener);
        this.setupControls();
    }

    public void addController(int position, Controller controller) {
        this.controllers.add(position, controller);
        controller.addControllerListener(this.controllerListener);
        this.setupControls();
    }

    public void removeController(Controller controller) {
        controller.removeControllerListener(this.controllerListener);
        this.controllers.remove(controller);
        this.setupControls();
    }

    public int getControllerCount() {
        return this.controllers.size();
    }

    @Override
    public void fireControlsChanged() {
        for (ControlPaletteListener listener : this.listeners) {
            listener.controlsChanged();
        }
    }

    @Override
    public void addControlPaletteListener(ControlPaletteListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeControlPaletteListener(ControlPaletteListener listener) {
        this.listeners.remove(listener);
    }

    private void setupControls() {
        this.removeAll();
        this.disclosurePanels.clear();
        this.controlsStates.clear();
        int i = 0;
        for (Controller controller : this.controllers) {
            this.setupController(i, controller);
            ++i;
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridx = 0;
        gc.gridy = i;
        gc.fill = 2;
        gc.anchor = 23;
        this.add((Component)new JSeparator(), gc);
    }

    public void layoutControls() {
        for (DisclosurePanel panel : this.disclosurePanels) {
            panel.invalidate();
        }
        this.validate();
        this.revalidate();
    }

    @Override
    public void initialize() {
        for (Controller controller : this.controllers) {
            controller.initialize();
        }
    }

    @Override
    public void getSettings(Map<String, Object> settings) {
        for (Controller controller : this.controllers) {
            controller.getSettings(settings);
        }
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        for (Controller controller : this.controllers) {
            controller.setSettings(settings);
        }
    }

    @Override
    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
        this.invalidate();
    }

    private void setupController(int index, Controller controller) {
        if (controller.getTitleComponent() != null) {
            JPanel titlePanel = new JPanel(new BorderLayout(6, 0));
            titlePanel.setOpaque(false);
            JComponent comp = controller.getTitleComponent();
            comp.setFocusable(false);
            titlePanel.add((Component)comp, "Center");
            JPanel controllerPanel = controller.getPanel();
            controllerPanel.setOpaque(false);
            controller.getTitleComponent().setFont(UIManager.getFont("SmallSystemFont"));
            controller.getTitleComponent().setOpaque(false);
            PinnedButton pinnedButton = new PinnedButton();
            pinnedButton.setSelected(controller.isInitiallyVisible());
            titlePanel.add((Component)pinnedButton, "East");
            DisclosurePanel panel = new DisclosurePanel(titlePanel, this.preferredTitleHeight, controllerPanel, controller.isInitiallyVisible(), this.openingSpeed);
            if (this.displayMode == DisplayMode.ONLY_ONE_OPEN) {
                panel.addDisclosureListener(new DisclosureListener(){

                    @Override
                    public void opening(Component component) {
                    }

                    @Override
                    public void opened(Component component) {
                        int newlyOpened = BasicControlPalette.this.disclosurePanels.indexOf(component);
                        ControlsState controlsState = (ControlsState)BasicControlPalette.this.controlsStates.get(newlyOpened);
                        if (BasicControlPalette.this.currentlyOpen >= 0) {
                            DisclosurePanel currentPanel = (DisclosurePanel)BasicControlPalette.this.disclosurePanels.get(BasicControlPalette.this.currentlyOpen);
                            ControlsState currentControls = (ControlsState)BasicControlPalette.this.controlsStates.get(BasicControlPalette.this.currentlyOpen);
                            if (!currentControls.isPinned()) {
                                currentPanel.setOpen(false);
                                currentControls.setVisible(false);
                            }
                        }
                        BasicControlPalette.this.currentlyOpen = newlyOpened;
                        controlsState.setVisible(true);
                        BasicControlPalette.this.invalidate();
                        BasicControlPalette.this.revalidate();
                        BasicControlPalette.this.invalidate();
                    }

                    @Override
                    public void closing(Component component) {
                    }

                    @Override
                    public void closed(Component component) {
                        int newlyClosed = BasicControlPalette.this.disclosurePanels.indexOf(component);
                        ControlsState controlsState = (ControlsState)BasicControlPalette.this.controlsStates.get(newlyClosed);
                        controlsState.setVisible(false);
                        if (newlyClosed == BasicControlPalette.this.currentlyOpen) {
                            BasicControlPalette.this.currentlyOpen = -1;
                        }
                        BasicControlPalette.this.invalidate();
                        BasicControlPalette.this.revalidate();
                        BasicControlPalette.this.invalidate();
                    }
                });
            }
            final ControlsState controlsState = new ControlsState(controller.isInitiallyVisible(), pinnedButton.isSelected());
            pinnedButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    controlsState.setPinned(itemEvent.getStateChange() == 1);
                }
            });
            this.disclosurePanels.add(panel);
            this.controlsStates.add(controlsState);
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.gridx = 0;
            gc.gridy = index;
            gc.fill = 2;
            gc.anchor = 23;
            this.add((Component)panel, gc);
        }
    }

    private class ControlsState {
        private boolean isVisible;
        private boolean isPinned;

        ControlsState(boolean visible, boolean pinned) {
            this.isVisible = visible;
            this.isPinned = pinned;
        }

        boolean isVisible() {
            return this.isVisible;
        }

        void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        boolean isPinned() {
            return this.isPinned;
        }

        void setPinned(boolean pinned) {
            this.isPinned = pinned;
        }
    }

    public static enum DisplayMode {
        DEFAULT_OPEN,
        INITIALLY_OPEN,
        INITIALLY_CLOSED,
        ONLY_ONE_OPEN;

    }
}

