/*
 * Decompiled with CFR 0.152.
 */
package jam.console;

import jam.console.ConsoleFrame;
import jam.console.ConsoleMenuBarFactory;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.MenuBarFactory;
import jam.mac.Utils;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;

public class ConsoleApplication
extends Application {
    private ConsoleFrame consoleFrame = null;
    private boolean dontAskSave;

    public ConsoleApplication(String nameString, String aboutString, Icon icon, boolean dontAskSave) throws IOException {
        this((MenuBarFactory)new ConsoleMenuBarFactory(), nameString, aboutString, icon, dontAskSave);
    }

    public ConsoleApplication(String nameString, String titleString, String aboutString, Icon icon, boolean dontAskSave) throws IOException {
        this((MenuBarFactory)new ConsoleMenuBarFactory(), nameString, titleString, aboutString, icon, dontAskSave);
    }

    public ConsoleApplication(MenuBarFactory menuBarFactory, String nameString, String aboutString, Icon icon, boolean dontAskSave) throws IOException {
        this(menuBarFactory, nameString, nameString, aboutString, icon, dontAskSave);
    }

    public ConsoleApplication(MenuBarFactory menuBarFactory, String nameString, String titleString, String aboutString, Icon icon, boolean dontAskSave) throws IOException {
        super(menuBarFactory, nameString, titleString, aboutString, icon);
        this.dontAskSave = dontAskSave;
        this.consoleFrame = new ConsoleFrame();
        this.consoleFrame.initialize();
        this.consoleFrame.setVisible(true);
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConsoleApplication.this.thisWindowClosing(e);
            }
        });
        this.getOpenAction().setEnabled(false);
    }

    @Override
    public void initialize() {
        if (Utils.isMacOSX()) {
            Utils.macOSXRegistration(this);
        }
    }

    @Override
    protected JFrame getDefaultFrame() {
        return this.consoleFrame;
    }

    @Override
    public DocumentFrame doNew() {
        throw new RuntimeException("A ConsoleApplication cannot do a New command");
    }

    @Override
    public DocumentFrame doOpenFile(File file) {
        throw new RuntimeException("A ConsoleApplication cannot do an Open command");
    }

    public void doCloseWindow() {
        this.doQuit();
    }

    @Override
    public void doQuit() {
        if (this.dontAskSave || this.consoleFrame.requestClose()) {
            this.consoleFrame.setVisible(false);
            this.consoleFrame.dispose();
            System.exit(0);
        }
    }

    @Override
    public void doPreferences() {
    }

    public void doStop() {
        this.doQuit();
    }

    private void thisWindowClosing(WindowEvent e) {
        this.doQuit();
    }
}

