/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import java.util.Comparator;
import java.util.List;

public class HeapSort {
    public static void sort(List<? extends Comparable> list, int[] nArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n2;
        }
        int n3 = list.size();
        for (n = n3 / 2; n > 0; --n) {
            HeapSort.adjust(list, nArray, n, n3);
        }
        for (n = n3 - 1; n > 0; --n) {
            n2 = nArray[0];
            nArray[0] = nArray[n];
            nArray[n] = n2;
            HeapSort.adjust(list, nArray, 1, n);
        }
    }

    public static void sort(Comparable<?>[] comparableArray) {
        int n;
        int n2 = comparableArray.length;
        for (n = n2 / 2; n > 0; --n) {
            HeapSort.adjust(comparableArray, n, n2);
        }
        for (n = n2 - 1; n > 0; --n) {
            Comparable<?> comparable = comparableArray[0];
            comparableArray[0] = comparableArray[n];
            comparableArray[n] = comparable;
            HeapSort.adjust(comparableArray, 1, n);
        }
    }

    public static void sort(Object[] objectArray, Comparator<?> comparator) {
        int n;
        int n2 = objectArray.length;
        for (n = n2 / 2; n > 0; --n) {
            HeapSort.adjust(objectArray, comparator, n, n2);
        }
        for (n = n2 - 1; n > 0; --n) {
            Object object = objectArray[0];
            objectArray[0] = objectArray[n];
            objectArray[n] = object;
            HeapSort.adjust(objectArray, comparator, 1, n);
        }
    }

    public static void sort(double[] dArray) {
        int n;
        int n2 = dArray.length;
        for (n = n2 / 2; n > 0; --n) {
            HeapSort.adjust(dArray, n, n2);
        }
        for (n = n2 - 1; n > 0; --n) {
            double d = dArray[0];
            dArray[0] = dArray[n];
            dArray[n] = d;
            HeapSort.adjust(dArray, 1, n);
        }
    }

    public static void sortAbs(double[] dArray) {
        int n;
        int n2 = dArray.length;
        for (n = n2 / 2; n > 0; --n) {
            HeapSort.adjustAbs(dArray, n, n2);
        }
        for (n = n2 - 1; n > 0; --n) {
            double d = dArray[0];
            dArray[0] = dArray[n];
            dArray[n] = d;
            HeapSort.adjustAbs(dArray, 1, n);
        }
    }

    public static void sort(double[] dArray, int[] nArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n2;
        }
        int n3 = nArray.length;
        for (n = n3 / 2; n > 0; --n) {
            HeapSort.adjust(dArray, nArray, n, n3);
        }
        for (n = n3 - 1; n > 0; --n) {
            n2 = nArray[0];
            nArray[0] = nArray[n];
            nArray[n] = n2;
            HeapSort.adjust(dArray, nArray, 1, n);
        }
    }

    private static void adjust(List<? extends Comparable> list, int[] nArray, int n, int n2) {
        int n3 = n;
        for (int i = n * 2; i <= n2; i *= 2) {
            if (i < n2 && list.get(nArray[i - 1]).compareTo(list.get(nArray[i])) < 0) {
                ++i;
            }
            if (list.get(nArray[n3 - 1]).compareTo(list.get(nArray[i - 1])) < 0) {
                int n4 = nArray[n3 - 1];
                nArray[n3 - 1] = nArray[i - 1];
                nArray[i - 1] = n4;
            }
            n3 = i;
        }
    }

    private static void adjust(Comparable[] comparableArray, int n, int n2) {
        int n3 = n;
        for (int i = n * 2; i <= n2; i *= 2) {
            if (i < n2 && comparableArray[i - 1].compareTo(comparableArray[i]) < 0) {
                ++i;
            }
            if (comparableArray[n3 - 1].compareTo(comparableArray[i - 1]) < 0) {
                Comparable comparable = comparableArray[n3 - 1];
                comparableArray[n3 - 1] = comparableArray[i - 1];
                comparableArray[i - 1] = comparable;
            }
            n3 = i;
        }
    }

    private static void adjust(Object[] objectArray, Comparator comparator, int n, int n2) {
        int n3 = n;
        for (int i = n * 2; i <= n2; i *= 2) {
            if (i < n2 && comparator.compare(objectArray[i - 1], objectArray[i]) < 0) {
                ++i;
            }
            if (comparator.compare(objectArray[n3 - 1], objectArray[i - 1]) < 0) {
                Object object = objectArray[n3 - 1];
                objectArray[n3 - 1] = objectArray[i - 1];
                objectArray[i - 1] = object;
            }
            n3 = i;
        }
    }

    private static void adjust(double[] dArray, int n, int n2) {
        int n3 = n;
        for (int i = n * 2; i <= n2; i *= 2) {
            if (i < n2 && dArray[i - 1] < dArray[i]) {
                ++i;
            }
            if (dArray[n3 - 1] < dArray[i - 1]) {
                double d = dArray[n3 - 1];
                dArray[n3 - 1] = dArray[i - 1];
                dArray[i - 1] = d;
            }
            n3 = i;
        }
    }

    private static void adjustAbs(double[] dArray, int n, int n2) {
        int n3 = n;
        for (int i = n * 2; i <= n2; i *= 2) {
            if (i < n2 && Math.abs(dArray[i - 1]) < Math.abs(dArray[i])) {
                ++i;
            }
            if (Math.abs(dArray[n3 - 1]) < Math.abs(dArray[i - 1])) {
                double d = dArray[n3 - 1];
                dArray[n3 - 1] = dArray[i - 1];
                dArray[i - 1] = d;
            }
            n3 = i;
        }
    }

    private static void adjust(double[] dArray, int[] nArray, int n, int n2) {
        int n3 = n;
        for (int i = n * 2; i <= n2; i *= 2) {
            if (i < n2 && dArray[nArray[i - 1]] < dArray[nArray[i]]) {
                ++i;
            }
            if (dArray[nArray[n3 - 1]] < dArray[nArray[i - 1]]) {
                int n4 = nArray[n3 - 1];
                nArray[n3 - 1] = nArray[i - 1];
                nArray[i - 1] = n4;
            }
            n3 = i;
        }
    }
}

