/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Distribution;
import beast.core.Function;
import beast.core.Input;
import beast.core.State;
import beast.core.parameter.IntegerParameter;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import java.util.List;
import java.util.Random;

@Description(value="Produces prior (log) probability of value x.If x is multidimensional, the components of x are assumed to be independent, so the sum of log probabilities of all elements of x is returned as the prior.")
public class Prior
extends Distribution {
    public final Input<Function> m_x = new Input("x", "point at which the density is calculated", Input.Validate.REQUIRED);
    public final Input<ParametricDistribution> distInput = new Input("distr", "distribution used to calculate prior, e.g. normal, beta, gamma.", Input.Validate.REQUIRED);
    protected ParametricDistribution dist;

    @Override
    public void initAndValidate() {
        this.dist = this.distInput.get();
        this.calculateLogP();
    }

    @Override
    public double calculateLogP() {
        Function function = this.m_x.get();
        if (function instanceof RealParameter || function instanceof IntegerParameter) {
            double d = 0.0;
            double d2 = 0.0;
            if (function instanceof RealParameter) {
                d = (Double)((RealParameter)function).getLower();
                d2 = (Double)((RealParameter)function).getUpper();
            } else {
                d = ((Integer)((IntegerParameter)function).getLower()).intValue();
                d2 = ((Integer)((IntegerParameter)function).getUpper()).intValue();
            }
            for (int i = 0; i < function.getDimension(); ++i) {
                double d3 = function.getArrayValue(i);
                if (!(d3 < d) && !(d3 > d2)) continue;
                this.logP = Double.NEGATIVE_INFINITY;
                return Double.NEGATIVE_INFINITY;
            }
        }
        this.logP = this.dist.calcLogP(function);
        if (this.logP == Double.POSITIVE_INFINITY) {
            this.logP = Double.NEGATIVE_INFINITY;
        }
        return this.logP;
    }

    public String getParameterName() {
        if (this.m_x.get() instanceof BEASTObject) {
            return ((BEASTObject)((Object)this.m_x.get())).getID();
        }
        return this.m_x.get() + "";
    }

    @Override
    public void sample(State state, Random random) {
    }

    @Override
    public List<String> getArguments() {
        return null;
    }

    @Override
    public List<String> getConditions() {
        return null;
    }
}

