/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.distribution.GammaDistributionImpl;

@Description(value="Gamma distribution. for x>0  g(x;alpha,beta) = 1/Gamma(alpha) beta^alpha} x^{alpha - 1} e^{-\frac{x}{beta}}If the input x is a multidimensional parameter, each of the dimensions is considered as a separate independent component.")
public class Gamma
extends ParametricDistribution {
    public final Input<RealParameter> alphaInput = new Input("alpha", "shape parameter, defaults to 2");
    public final Input<RealParameter> betaInput = new Input("beta", "second parameter depends on mode, defaults to 2.For mode=ShapeScale beta is interpreted as scale. For mode=ShapeRate beta is interpreted as rate. For mode=ShapeMean beta is interpreted as mean.For mode=OneParameter beta is ignored.");
    public final Input<mode> modeInput = new Input<mode>("mode", "determines parameterisation. For ShapeScale beta is interpreted as scale. For ShapeRate beta is interpreted as rate. For ShapeMean beta is interpreted as mean.For OneParameter beta is ignored.", mode.ShapeScale, mode.values());
    static GammaDistribution m_dist = new GammaDistributionImpl(1.0, 1.0);
    mode parameterisation = mode.ShapeScale;

    @Override
    public void initAndValidate() {
        this.parameterisation = this.modeInput.get();
        this.refresh();
    }

    void refresh() {
        double d = 2.0;
        double d2 = this.alphaInput.get() == null ? 2.0 : this.alphaInput.get().getValue();
        switch (this.parameterisation) {
            case ShapeScale: {
                if (this.betaInput.get() == null) break;
                d = this.betaInput.get().getValue();
                break;
            }
            case ShapeRate: {
                if (this.betaInput.get() == null) break;
                d = 1.0 / this.betaInput.get().getValue();
                break;
            }
            case ShapeMean: {
                if (this.betaInput.get() == null) break;
                d = this.betaInput.get().getValue() / d2;
                break;
            }
            case OneParameter: {
                d = 1.0 / d2;
            }
        }
        m_dist.setAlpha(d2);
        m_dist.setBeta(d);
    }

    @Override
    public ContinuousDistribution getDistribution() {
        this.refresh();
        return m_dist;
    }

    @Override
    public double getMean() {
        this.refresh();
        return (Double)this.offsetInput.get() + m_dist.getAlpha() * m_dist.getBeta();
    }

    public static enum mode {
        ShapeScale,
        ShapeRate,
        ShapeMean,
        OneParameter;

    }
}

