/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.distribution.BetaDistribution;
import org.apache.commons.math.distribution.BetaDistributionImpl;
import org.apache.commons.math.distribution.ContinuousDistribution;

@Description(value="Beta distribution, used as prior.  p(x;alpha,beta) = \frac{x^{alpha-1}(1-x)^{beta-1}} {B(alpha,beta)} where B() is the beta function. If the input x is a multidimensional parameter, each of the dimensions is considered as a separate independent component.")
public class Beta
extends ParametricDistribution {
    public final Input<RealParameter> alphaInput = new Input("alpha", "first shape parameter, defaults to 1");
    public final Input<RealParameter> betaInput = new Input("beta", "the other shape parameter, defaults to 1");
    static BetaDistribution m_dist = new BetaDistributionImpl(1.0, 1.0);

    @Override
    public void initAndValidate() {
        this.refresh();
    }

    void refresh() {
        double d = this.alphaInput.get() == null ? 1.0 : this.alphaInput.get().getValue();
        double d2 = this.betaInput.get() == null ? 1.0 : this.betaInput.get().getValue();
        m_dist.setAlpha(d);
        m_dist.setBeta(d2);
    }

    @Override
    public ContinuousDistribution getDistribution() {
        this.refresh();
        return m_dist;
    }

    @Override
    public double getMean() {
        return m_dist.getAlpha() / (m_dist.getAlpha() + m_dist.getBeta());
    }
}

