/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.tree.coalescent.PopulationFunction;
import java.util.Collections;
import java.util.List;

@Description(value="coalescent intervals for a constant population")
public class ConstantPopulation
extends PopulationFunction.Abstract {
    public final Input<RealParameter> popSizeParameter = new Input("popSize", "constant (effective) population size value.", Input.Validate.REQUIRED);
    private double N0 = 1.0;

    public double getN0() {
        this.N0 = this.popSizeParameter.get().getValue();
        return this.N0;
    }

    public void setN0(double d) {
        this.N0 = d;
    }

    @Override
    public List<String> getParameterIds() {
        return Collections.singletonList(this.popSizeParameter.get().getID());
    }

    @Override
    public double getPopSize(double d) {
        return this.getN0();
    }

    @Override
    public double getIntensity(double d) {
        return d / this.getN0();
    }

    @Override
    public double getInverseIntensity(double d) {
        return this.getN0() * d;
    }
}

