/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.StateNode;
import beast.core.parameter.Parameter;
import beast.core.parameter.RealParameter;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import java.io.PrintStream;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

@Description(value="Logs tree annotated with metadata and/or rates")
public class TreeWithMetaDataLogger
extends BEASTObject
implements Loggable {
    public final Input<Tree> treeInput = new Input("tree", "tree to be logged", Input.Validate.REQUIRED);
    public final Input<List<Function>> parameterInput = new Input("metadata", "meta data to be logged with the tree nodes", new ArrayList());
    public final Input<BranchRateModel.Base> clockModelInput = new Input("branchratemodel", "rate to be logged with branches of the tree");
    public final Input<Boolean> substitutionsInput = new Input<Boolean>("substitutions", "report branch lengths as substitutions (branch length times clock rate for the branch)", false);
    public final Input<Integer> decimalPlacesInput = new Input<Integer>("dp", "the number of decimal places to use writing branch lengths, rates and real-valued metadata, use -1 for full precision (default = full precision)", -1);
    boolean someMetaDataNeedsLogging;
    boolean substitutions = false;
    private DecimalFormat df;

    @Override
    public void initAndValidate() {
        int n = this.decimalPlacesInput.get();
        if (n < 0) {
            this.df = null;
        } else {
            this.df = new DecimalFormat("#." + new String(new char[n]).replace('\u0000', '#'));
            this.df.setRoundingMode(RoundingMode.HALF_UP);
        }
        if (this.parameterInput.get().size() == 0 && this.clockModelInput.get() == null) {
            this.someMetaDataNeedsLogging = false;
            return;
        }
        this.someMetaDataNeedsLogging = true;
        if (this.clockModelInput.get() != null) {
            this.substitutions = this.substitutionsInput.get();
        }
    }

    @Override
    public void init(PrintStream printStream) {
        this.treeInput.get().init(printStream);
    }

    @Override
    public void log(int n, PrintStream printStream) {
        Tree tree = (Tree)this.treeInput.get().getCurrent();
        List<Function> list = this.parameterInput.get();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof StateNode)) continue;
            list.set(i, ((StateNode)list.get(i)).getCurrent());
        }
        BranchRateModel.Base base = this.clockModelInput.get();
        printStream.print("tree STATE_" + n + " = ");
        tree.getRoot().sort();
        printStream.print(this.toNewick(tree.getRoot(), list, base));
        printStream.print(";");
    }

    private void appendDouble(StringBuffer stringBuffer, double d) {
        if (this.df == null) {
            stringBuffer.append(d);
        } else {
            stringBuffer.append(this.df.format(d));
        }
    }

    String toNewick(Node node, List<Function> list, BranchRateModel.Base base) {
        StringBuffer stringBuffer = new StringBuffer();
        if (node.getLeft() != null) {
            stringBuffer.append("(");
            stringBuffer.append(this.toNewick(node.getLeft(), list, base));
            if (node.getRight() != null) {
                stringBuffer.append(',');
                stringBuffer.append(this.toNewick(node.getRight(), list, base));
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(node.labelNr + 1);
        }
        if (this.someMetaDataNeedsLogging) {
            stringBuffer.append("[&");
            if (list.size() > 0) {
                for (Function function : list) {
                    stringBuffer.append(((BEASTObject)((Object)function)).getID());
                    stringBuffer.append('=');
                    if (function instanceof Parameter) {
                        Parameter parameter = (Parameter)function;
                        int n = parameter.getMinorDimension1();
                        if (n > 1) {
                            stringBuffer.append('{');
                            for (int i = 0; i < n; ++i) {
                                if (function instanceof RealParameter) {
                                    RealParameter realParameter = (RealParameter)function;
                                    this.appendDouble(stringBuffer, (Double)realParameter.getMatrixValue(node.labelNr, i));
                                } else {
                                    stringBuffer.append(parameter.getMatrixValue(node.labelNr, i));
                                }
                                if (i >= n - 1) continue;
                                stringBuffer.append(',');
                            }
                            stringBuffer.append('}');
                        } else if (function instanceof RealParameter) {
                            RealParameter realParameter = (RealParameter)function;
                            this.appendDouble(stringBuffer, realParameter.getArrayValue(node.labelNr));
                        } else {
                            stringBuffer.append(function.getArrayValue(node.labelNr));
                        }
                    } else {
                        stringBuffer.append(function.getArrayValue(node.labelNr));
                    }
                    if (list.indexOf(function) >= list.size() - 1) continue;
                    stringBuffer.append(",");
                }
                if (base != null) {
                    stringBuffer.append(",");
                }
            }
            if (base != null) {
                stringBuffer.append("rate=");
                this.appendDouble(stringBuffer, base.getRateForBranch(node));
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(":");
        if (this.substitutions) {
            this.appendDouble(stringBuffer, node.getLength() * base.getRateForBranch(node));
        } else {
            this.appendDouble(stringBuffer, node.getLength());
        }
        return stringBuffer.toString();
    }

    @Override
    public void close(PrintStream printStream) {
        this.treeInput.get().close(printStream);
    }
}

