/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.StateNode;
import beast.core.StateNodeInitialiser;
import beast.core.util.Log;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import beast.evolution.tree.TraitSet;
import beast.evolution.tree.TreeInterface;
import beast.util.TreeParser;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Description(value="Tree (the T in BEAST) representing gene beast.tree, species beast.tree, language history, or other time-beast.tree relationships among sequence data.")
public class Tree
extends StateNode
implements TreeInterface {
    public final Input<Tree> m_initial = new Input("initial", "tree to start with");
    public final Input<List<TraitSet>> m_traitList = new Input("trait", "trait information for initializing traits (like node dates) in the tree", new ArrayList());
    public final Input<TaxonSet> m_taxonset = new Input("taxonset", "set of taxa that correspond to the leafs in the tree");
    public final Input<String> nodeTypeInput = new Input<String>("nodetype", "type of the nodes in the beast.tree", Node.class.getName());
    public static final int IS_CLEAN = 0;
    public static final int IS_DIRTY = 1;
    public static final int IS_FILTHY = 2;
    protected int nodeCount = -1;
    protected int internalNodeCount = -1;
    protected int leafNodeCount = -1;
    protected Node root;
    protected Node storedRoot;
    protected Node[] m_nodes = null;
    protected Node[] m_storedNodes = null;
    protected String[] m_sTaxaNames = null;
    protected TraitSet timeTraitSet = null;
    protected boolean traitsProcessed = false;
    static final double EPSILON = 1.0E-7;
    protected Node[] postCache = null;
    public static int taxaTranslationOffset = 1;

    @Override
    public void initAndValidate() {
        if (this.m_initial.get() != null && !(this instanceof StateNodeInitialiser)) {
            throw new RuntimeException("initial-input should be specified for tree that is not a StateNodeInitialiser");
        }
        if (this.nodeCount < 0) {
            if (this.m_taxonset.get() != null) {
                this.makeCaterpillar(0.0, 1.0, false);
            } else {
                this.root = this.newNode();
                this.root.labelNr = 0;
                this.root.height = 0.0;
                this.root.m_tree = this;
                this.nodeCount = 1;
                this.internalNodeCount = 0;
                this.leafNodeCount = 1;
            }
        }
        if (this.nodeCount >= 0) {
            this.initArrays();
        }
        this.processTraits(this.m_traitList.get());
        if (this.timeTraitSet != null) {
            this.adjustTreeNodeHeights(this.root);
        }
        String[] stringArray = this.getTaxaNames();
        for (int i = 0; i < this.getNodeCount() && i < stringArray.length; ++i) {
            if (stringArray[i] == null || this.m_nodes[i].getID() != null) continue;
            this.m_nodes[i].setID(stringArray[i]);
        }
    }

    public void makeCaterpillar(double d, double d2, boolean bl) {
        List<String> list = this.m_taxonset.get().asStringList();
        Node node = this.newNode();
        node.labelNr = 0;
        node.height = 0.0;
        node.setID(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            Node node2 = this.newNode();
            node2.labelNr = i;
            node2.height = 0.0;
            node2.setID(list.get(i));
            Node node3 = this.newNode();
            node3.labelNr = list.size() + i - 1;
            node3.height = d + (double)i * d2;
            node.parent = node3;
            node3.setLeft(node);
            node2.parent = node3;
            node3.setRight(node2);
            node = node3;
        }
        this.root = node;
        this.leafNodeCount = list.size();
        this.nodeCount = this.leafNodeCount * 2 - 1;
        this.internalNodeCount = this.leafNodeCount - 1;
        if (bl) {
            this.initArrays();
        }
    }

    protected void processTraits(List<TraitSet> list) {
        for (TraitSet traitSet : list) {
            for (Node node : this.getExternalNodes()) {
                String string = node.getID();
                if (string == null) continue;
                node.setMetaData(traitSet.getTraitName(), traitSet.getValue(string));
            }
            if (!traitSet.isDateTrait()) continue;
            this.timeTraitSet = traitSet;
        }
        this.traitsProcessed = true;
    }

    protected Node newNode() {
        try {
            return (Node)Class.forName(this.nodeTypeInput.get()).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot create node of type " + this.nodeTypeInput.get() + ": " + exception.getMessage());
        }
    }

    protected void initArrays() {
        this.m_nodes = new Node[this.nodeCount];
        this.listNodes(this.root, this.m_nodes);
        this.m_storedNodes = new Node[this.nodeCount];
        Node node = this.root.copy();
        this.listNodes(node, this.m_storedNodes);
        this.postCache = null;
    }

    public Tree() {
    }

    public Tree(Node node) {
        this.setRoot(node);
        this.initArrays();
    }

    public Tree(String string) {
        this(new TreeParser(string).getRoot());
    }

    protected void adjustTreeNodeHeights(Node node) {
        if (!node.isLeaf()) {
            for (Node node2 : node.getChildren()) {
                this.adjustTreeNodeHeights(node2);
            }
            for (Node node2 : node.getChildren()) {
                double d = node2.getHeight() + 1.0E-7;
                if (!(node.height < d)) continue;
                node.height = d;
            }
        }
    }

    @Override
    public int getNodeCount() {
        if (this.nodeCount < 0) {
            this.nodeCount = this.root.getNodeCount();
        }
        return this.nodeCount;
    }

    @Override
    public int getInternalNodeCount() {
        if (this.internalNodeCount < 0) {
            this.internalNodeCount = this.root.getInternalNodeCount();
        }
        return this.internalNodeCount;
    }

    @Override
    public int getLeafNodeCount() {
        if (this.leafNodeCount < 0) {
            this.leafNodeCount = this.root.getLeafNodeCount();
        }
        return this.leafNodeCount;
    }

    @Override
    public List<Node> getExternalNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            Node node = this.getNode(i);
            if (!node.isLeaf()) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    @Override
    public List<Node> getInternalNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            Node node = this.getNode(i);
            if (node.isLeaf()) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node node) {
        this.root = node;
        this.nodeCount = this.root.getNodeCount();
        if (this.m_nodes != null && node.labelNr != this.m_nodes.length - 1) {
            int n = this.m_nodes.length - 1;
            Node node2 = this.m_nodes[n];
            this.m_nodes[n] = node;
            this.m_nodes[node.labelNr] = node2;
            node2.labelNr = node.labelNr;
            this.m_nodes[n].labelNr = n;
        }
    }

    public void setRootOnly(Node node) {
        this.root = node;
    }

    @Override
    public Node getNode(int n) {
        return this.m_nodes[n];
    }

    public String[] getTaxaNames() {
        if (this.m_sTaxaNames == null || this.m_sTaxaNames.length == 1 && this.m_sTaxaNames[0] == null || this.m_sTaxaNames.length == 0) {
            if (this.root != null) {
                this.m_sTaxaNames = new String[this.getNodeCount()];
                this.collectTaxaNames(this.getRoot());
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : this.m_sTaxaNames) {
                    if (string == null) continue;
                    arrayList.add(string);
                }
                this.m_sTaxaNames = arrayList.toArray(new String[0]);
            } else {
                TaxonSet taxonSet = this.m_taxonset.get();
                if (taxonSet != null) {
                    List<String> list = taxonSet.asStringList();
                    this.m_sTaxaNames = list.toArray(new String[list.size()]);
                } else {
                    Log.err("No taxa specified");
                }
            }
        }
        if (this.m_sTaxaNames.length == 1 && this.m_sTaxaNames[0] == null) {
            Log.warning("WARNING: tree interrogated for taxa, but the tree was not initialised properly. To fix this, specify the taxonset input");
        }
        return this.m_sTaxaNames;
    }

    void collectTaxaNames(Node node) {
        if (node.getID() != null) {
            this.m_sTaxaNames[node.getNr()] = node.getID();
        }
        if (node.isLeaf()) {
            if (node.getID() == null) {
                node.setID("node" + node.getNr());
            }
        } else {
            for (Node node2 : node.getChildren()) {
                this.collectTaxaNames(node2);
            }
        }
    }

    @Override
    public void getMetaData(Node node, Double[] doubleArray, String string) {
        doubleArray[Math.abs((int)node.getNr())] = (Double)node.getMetaData(string);
        if (!node.isLeaf()) {
            this.getMetaData(node.getLeft(), doubleArray, string);
            if (node.getRight() != null) {
                this.getMetaData(node.getRight(), doubleArray, string);
            }
        }
    }

    public void getMetaData(Node node, Integer[] integerArray, String string) {
        integerArray[Math.abs((int)node.getNr())] = (Integer)node.getMetaData(string);
        if (!node.isLeaf()) {
            this.getMetaData(node.getLeft(), integerArray, string);
            if (node.getRight() != null) {
                this.getMetaData(node.getRight(), integerArray, string);
            }
        }
    }

    @Override
    public void setMetaData(Node node, Double[] doubleArray, String string) {
        node.setMetaData(string, doubleArray[Math.abs(node.getNr())]);
        if (!node.isLeaf()) {
            this.setMetaData(node.getLeft(), doubleArray, string);
            if (node.getRight() != null) {
                this.setMetaData(node.getRight(), doubleArray, string);
            }
        }
    }

    void listNodes(Node node, Node[] nodeArray) {
        nodeArray[node.getNr()] = node;
        node.m_tree = this;
        for (Node node2 : node.getChildren()) {
            this.listNodes(node2, nodeArray);
        }
    }

    @Override
    public Node[] listNodesPostOrder(Node node, Node[] nodeArray) {
        if (node != null) {
            return TreeInterface.super.listNodesPostOrder(node, nodeArray);
        }
        if (this.postCache == null) {
            this.postCache = TreeInterface.super.listNodesPostOrder(node, nodeArray);
        }
        return this.postCache;
    }

    @Override
    public Node[] getNodesAsArray() {
        return this.m_nodes;
    }

    @Override
    public Tree copy() {
        Tree tree = new Tree();
        tree.setID(this.getID());
        tree.index = this.index;
        tree.root = this.root.copy();
        tree.nodeCount = this.nodeCount;
        tree.internalNodeCount = this.internalNodeCount;
        tree.leafNodeCount = this.leafNodeCount;
        return tree;
    }

    @Override
    public void assignTo(StateNode stateNode) {
        Tree tree = (Tree)stateNode;
        Node[] nodeArray = new Node[this.nodeCount];
        this.listNodes(tree.root, nodeArray);
        tree.setID(this.getID());
        this.root.assignTo(nodeArray);
        tree.root = nodeArray[this.root.getNr()];
        tree.nodeCount = this.nodeCount;
        tree.internalNodeCount = this.internalNodeCount;
        tree.leafNodeCount = this.leafNodeCount;
    }

    @Override
    public void assignFrom(StateNode stateNode) {
        Tree tree = (Tree)stateNode;
        Node[] nodeArray = new Node[tree.getNodeCount()];
        for (int i = 0; i < tree.getNodeCount(); ++i) {
            nodeArray[i] = this.newNode();
        }
        this.setID(tree.getID());
        this.root = nodeArray[tree.root.getNr()];
        this.root.assignFrom(nodeArray, tree.root);
        this.root.parent = null;
        this.nodeCount = tree.nodeCount;
        this.internalNodeCount = tree.internalNodeCount;
        this.leafNodeCount = tree.leafNodeCount;
        this.initArrays();
    }

    @Override
    public void assignFromFragile(StateNode stateNode) {
        this.postCache = null;
        Tree tree = (Tree)stateNode;
        if (this.m_nodes == null) {
            this.initArrays();
        }
        this.root = this.m_nodes[tree.root.getNr()];
        Node[] nodeArray = tree.m_nodes;
        int n = this.root.getNr();
        this.assignFrom(0, n, nodeArray);
        this.root.height = nodeArray[n].height;
        this.root.parent = null;
        if (nodeArray[n].getLeft() != null) {
            this.root.setLeft(this.m_nodes[nodeArray[n].getLeft().getNr()]);
        } else {
            this.root.setLeft(null);
        }
        if (nodeArray[n].getRight() != null) {
            this.root.setRight(this.m_nodes[nodeArray[n].getRight().getNr()]);
        } else {
            this.root.setRight(null);
        }
        this.assignFrom(n + 1, this.nodeCount, nodeArray);
    }

    private void assignFrom(int n, int n2, Node[] nodeArray) {
        for (int i = n; i < n2; ++i) {
            Node node = this.m_nodes[i];
            Node node2 = nodeArray[i];
            node.height = node2.height;
            node.parent = this.m_nodes[node2.parent.getNr()];
            if (node2.getLeft() == null) continue;
            node.setLeft(this.m_nodes[node2.getLeft().getNr()]);
            if (node2.getRight() != null) {
                node.setRight(this.m_nodes[node2.getRight().getNr()]);
                continue;
            }
            node.setRight(null);
        }
    }

    @Override
    public String toString() {
        return this.root.toString();
    }

    @Override
    public void setEverythingDirty(boolean bl) {
        this.setSomethingIsDirty(bl);
        if (!bl) {
            for (Node node : this.m_nodes) {
                node.isDirty = 0;
            }
        } else {
            for (Node node : this.m_nodes) {
                node.isDirty = 2;
            }
        }
    }

    @Override
    public int scale(double d) {
        this.root.scale(d);
        return this.getInternalNodeCount() - this.getDirectAncestorNodeCount();
    }

    public static void printTranslate(Node node, PrintStream printStream, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Tree.printTranslate(node, arrayList, n);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            printStream.println(string);
        }
    }

    static void printTranslate(Node node, List<String> list, int n) {
        if (node.isLeaf()) {
            String string = node.getNr() + taxaTranslationOffset + "";
            String string2 = "\t\t" + "    ".substring(string.length()) + string + " " + node.getID();
            if (node.getNr() < n) {
                string2 = string2 + ",";
            }
            list.add(string2);
        } else {
            Tree.printTranslate(node.getLeft(), list, n);
            if (node.getRight() != null) {
                Tree.printTranslate(node.getRight(), list, n);
            }
        }
    }

    public static void printTaxa(Node node, PrintStream printStream, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Tree.printTranslate(node, arrayList, n);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            string = string.split("\\s+")[2];
            printStream.println("\t\t\t" + string.replace(',', ' '));
        }
    }

    @Override
    public void init(PrintStream printStream) {
        Node node = this.getRoot();
        printStream.println("#NEXUS\n");
        printStream.println("Begin taxa;");
        printStream.println("\tDimensions ntax=" + this.getLeafNodeCount() + ";");
        printStream.println("\t\tTaxlabels");
        Tree.printTaxa(node, printStream, this.getNodeCount() / 2);
        printStream.println("\t\t\t;");
        printStream.println("End;");
        printStream.println("Begin trees;");
        printStream.println("\tTranslate");
        Tree.printTranslate(node, printStream, this.getNodeCount() / 2);
        printStream.print(";");
    }

    @Override
    public void log(int n, PrintStream printStream) {
        Tree tree = (Tree)this.getCurrent();
        printStream.print("tree STATE_" + n + " = ");
        int[] nArray = new int[1];
        String string = tree.getRoot().toSortedNewick(nArray);
        printStream.print(string);
        printStream.print(";");
    }

    @Override
    public void close(PrintStream printStream) {
        printStream.print("End;");
    }

    @Override
    public void fromXML(org.w3c.dom.Node node) {
        String string = node.getTextContent();
        TreeParser treeParser = new TreeParser();
        try {
            treeParser.thresholdInput.setValue(1.0E-10, treeParser);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            treeParser.offsetInput.setValue(0, treeParser);
            this.setRoot(treeParser.parseNewick(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initArrays();
    }

    @Override
    public int getDimension() {
        return this.getNodeCount();
    }

    @Override
    public double getArrayValue() {
        return this.root.height;
    }

    @Override
    public double getArrayValue(int n) {
        return this.m_nodes[n].height;
    }

    @Override
    protected void store() {
        if (this.m_storedNodes.length != this.nodeCount) {
            Node[] nodeArray = new Node[this.nodeCount];
            System.arraycopy(this.m_storedNodes, 0, nodeArray, 0, this.m_storedNodes.length - 1);
            if (this.nodeCount > this.m_storedNodes.length) {
                nodeArray[this.m_storedNodes.length - 1] = this.m_storedNodes[this.m_storedNodes.length - 1];
                nodeArray[this.nodeCount - 1] = this.newNode();
                nodeArray[this.nodeCount - 1].setNr(this.nodeCount - 1);
            }
            this.m_storedNodes = nodeArray;
        }
        this.storeNodes(0, this.nodeCount);
        this.storedRoot = this.m_storedNodes[this.root.getNr()];
    }

    private void storeNodes(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            Node node;
            Node node2 = this.m_storedNodes[i];
            Node node3 = this.m_nodes[i];
            node2.height = node3.height;
            node2.parent = node3.parent != null ? this.m_storedNodes[node3.parent.getNr()] : null;
            List<Node> list = node2.children;
            List<Node> list2 = node3.children;
            if (list.size() == list2.size()) {
                for (int j = 0; j < list.size(); ++j) {
                    Node node4 = list2.get(j);
                    node = this.m_storedNodes[node4.getNr()];
                    node.parent = node2;
                    list.set(j, node);
                }
                continue;
            }
            list.clear();
            for (Node node4 : list2) {
                node = this.m_storedNodes[node4.getNr()];
                node.parent = node2;
                list.add(node);
            }
        }
    }

    @Override
    public void startEditing(Operator operator) {
        super.startEditing(operator);
        this.postCache = null;
    }

    @Override
    public void restore() {
        this.nodeCount = this.m_storedNodes.length;
        Node[] nodeArray = this.m_storedNodes;
        this.m_storedNodes = this.m_nodes;
        this.m_nodes = nodeArray;
        this.root = this.m_nodes[this.storedRoot.getNr()];
        this.leafNodeCount = 0;
        for (Node node : this.m_nodes) {
            this.leafNodeCount += node.isLeaf() ? 1 : 0;
        }
        this.hasStartedEditing = false;
        for (Node node : this.m_nodes) {
            node.isDirty = 0;
        }
        this.postCache = null;
    }

    public TraitSet getDateTrait() {
        if (!this.traitsProcessed) {
            this.processTraits(this.m_traitList.get());
        }
        return this.timeTraitSet;
    }

    public boolean hasDateTrait() {
        return this.getDateTrait() != null;
    }

    public void setDateTrait(TraitSet traitSet) {
        if (this.hasDateTrait()) {
            this.m_traitList.get().remove(this.timeTraitSet);
        }
        if (traitSet != null) {
            this.m_traitList.get().add(traitSet);
        }
        this.timeTraitSet = traitSet;
    }

    public double getDate(double d) {
        if (this.hasDateTrait()) {
            return this.timeTraitSet.getDate(d);
        }
        return d;
    }

    public String getTaxonId(Node node) {
        return this.getTaxaNames()[node.getNr()];
    }

    public void removeNode(int n) {
        Node[] nodeArray = new Node[this.nodeCount - 1];
        System.arraycopy(this.m_nodes, 0, nodeArray, 0, n);
        for (int i = n; i < this.nodeCount - 1; ++i) {
            nodeArray[i] = this.m_nodes[i + 1];
            nodeArray[i].setNr(i);
        }
        this.m_nodes = nodeArray;
        --this.nodeCount;
        if (n < this.leafNodeCount) {
            --this.leafNodeCount;
        } else {
            --this.internalNodeCount;
        }
    }

    public void addNode(Node node) {
        Node[] nodeArray = new Node[this.nodeCount + 1];
        System.arraycopy(this.m_nodes, 0, nodeArray, 0, this.nodeCount);
        nodeArray[this.nodeCount] = node;
        node.setNr(this.nodeCount);
        this.m_nodes = nodeArray;
        ++this.nodeCount;
        if (node.getChildCount() > 0) {
            ++this.internalNodeCount;
        } else {
            ++this.leafNodeCount;
        }
    }

    public int getDirectAncestorNodeCount() {
        int n = 0;
        for (int i = 0; i < this.leafNodeCount; ++i) {
            if (!this.getNode(i).isDirectAncestor()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public TaxonSet getTaxonset() {
        return this.m_taxonset.get();
    }

    public boolean childrenChanged(int n) {
        Node node = this.m_nodes[n];
        Node node2 = this.m_storedNodes[n];
        if (node.getLeft().getNr() == node2.getLeft().getNr() && node.getRight().getNr() == node2.getRight().getNr()) {
            return false;
        }
        return node.getLeft().getNr() != node2.getRight().getNr() || node.getRight().getNr() != node2.getLeft().getNr();
    }
}

