/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.util.Log;
import beast.evolution.alignment.TaxonSet;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Description(value="A trait set represent a collection of properties of taxons, for the use of initializing a tree. The traits are represented as text content in taxon=value form, for example, for a date trait, wecould have a content of chimp=1950,human=1991,neander=-10000. All white space is ignored, so they canbe put on multiple tabbed lines in the XML. The type of node in the tree determines what happes with this information. The default Node only recognizes 'date', 'date-forward' and 'date-backward' as a trait, but by creating custom Node classes other traits can be supported as well.")
public class TraitSet
extends BEASTObject {
    public final Input<String> traitNameInput = new Input("traitname", "name of the trait, used as meta data name for the tree. Special traitnames that are recognized are 'date','date-forward' and 'date-backward'.", Input.Validate.REQUIRED);
    public final Input<Units> unitsInput = new Input<Units>("units", "name of the units in which values are posed, used for conversion to a real value. This can be " + Arrays.toString((Object[])Units.values()) + " (default 'year')", Units.year, Units.values());
    public final Input<String> traitsInput = new Input("value", "traits encoded as taxon=value pairs separated by commas", Input.Validate.REQUIRED);
    public final Input<TaxonSet> taxaInput = new Input("taxa", "contains list of taxa to map traits to", Input.Validate.REQUIRED);
    public final Input<String> dateTimeFormatInput = new Input("dateFormat", "the date/time format to be parsed, (e.g., 'dd/M/yyyy')");
    public static final String DATE_TRAIT = "date";
    public static final String DATE_FORWARD_TRAIT = "date-forward";
    public static final String DATE_BACKWARD_TRAIT = "date-backward";
    protected String[] taxonValues;
    double[] values;
    double minValue;
    double maxValue;
    Map<String, Integer> map;
    boolean numeric = true;

    @Override
    public void initAndValidate() {
        int n;
        if (this.traitsInput.get().matches("^\\s*$")) {
            return;
        }
        this.map = new HashMap<String, Integer>();
        List<String> list = this.taxaInput.get().asStringList();
        String[] stringArray = this.traitsInput.get().split(",");
        this.taxonValues = new String[list.size()];
        this.values = new double[list.size()];
        for (String string : stringArray) {
            String[] stringArray2 = (string = string.replaceAll("\\s+", " ")).split("=");
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException("could not parse trait: " + string);
            }
            String string2 = this.normalize(stringArray2[0]);
            int n2 = list.indexOf(string2);
            if (n2 < 0) {
                throw new IllegalArgumentException("Trait (" + string2 + ") is not a known taxon. Spelling error perhaps?");
            }
            this.taxonValues[n2] = this.normalize(stringArray2[1]);
            this.values[n2] = this.parseDouble(this.taxonValues[n2]);
            this.map.put(string2, n2);
            if (!Double.isNaN(this.values[n2])) continue;
            this.numeric = false;
        }
        this.minValue = this.values[0];
        this.maxValue = this.values[0];
        double[] d = this.values;
        int n3 = d.length;
        for (n = 0; n < n3; ++n) {
            double d2 = d[n];
            this.minValue = Math.min(this.minValue, d2);
            this.maxValue = Math.max(this.maxValue, d2);
        }
        double d3 = 0.0;
        if (this.traitNameInput.get().equals(DATE_TRAIT) || this.traitNameInput.get().equals(DATE_FORWARD_TRAIT)) {
            d3 = this.maxValue;
        }
        for (n = 0; n < list.size(); ++n) {
            if (this.taxonValues[n] != null) continue;
            Log.warning.println("WARNING: no trait specified for " + list.get(n) + ": Assumed to be " + d3);
            this.map.put(list.get(n), n);
            this.values[n] = d3;
        }
        if (this.traitNameInput.get().equals(DATE_TRAIT) || this.traitNameInput.get().equals(DATE_FORWARD_TRAIT)) {
            for (n = 0; n < list.size(); ++n) {
                this.values[n] = this.maxValue - this.values[n];
            }
        }
        if (this.traitNameInput.get().equals(DATE_BACKWARD_TRAIT)) {
            for (n = 0; n < list.size(); ++n) {
                this.values[n] = this.values[n] - this.minValue;
            }
        }
        for (n = 0; n < list.size(); ++n) {
            Log.info.println(list.get(n) + " = " + this.taxonValues[n] + " (" + this.values[n] + ")");
        }
    }

    public String getTraitName() {
        return this.traitNameInput.get();
    }

    @Deprecated
    public String getStringValue(int n) {
        return this.taxonValues[n];
    }

    @Deprecated
    public double getValue(int n) {
        if (this.values == null) {
            return 0.0;
        }
        return this.values[n];
    }

    public String getStringValue(String string) {
        if (this.taxonValues == null || this.map == null || this.map.get(string) == null) {
            return null;
        }
        return this.taxonValues[this.map.get(string)];
    }

    public double getValue(String string) {
        if (this.values == null || this.map == null || this.map.get(string) == null) {
            return 0.0;
        }
        return this.values[this.map.get(string)];
    }

    private double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.traitNameInput.get().equals(DATE_TRAIT) || this.traitNameInput.get().equals(DATE_FORWARD_TRAIT) || this.traitNameInput.get().equals(DATE_BACKWARD_TRAIT)) {
                try {
                    double d;
                    if (this.dateTimeFormatInput.get() == null) {
                        if (string.matches(".*[a-zA-Z].*")) {
                            string = string.replace('/', '-');
                        }
                        long l = Date.parse(string);
                        d = 1970.0 + (double)l / 3.1536E10;
                        Log.warning.println("No date/time format provided, using default parsing: '" + string + "' parsed as '" + d + "'");
                    } else {
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateTimeFormatInput.get());
                        LocalDate localDate = LocalDate.parse(string, dateTimeFormatter);
                        Log.warning.println("Using format '" + this.dateTimeFormatInput.get() + "' to parse '" + string + "' as: " + ((double)localDate.getYear() + ((double)localDate.getDayOfYear() - 1.0) / (localDate.isLeapYear() ? 366.0 : 365.0)));
                        d = (double)localDate.getYear() + ((double)localDate.getDayOfYear() - 1.0) / (localDate.isLeapYear() ? 366.0 : 365.0);
                    }
                    switch (this.unitsInput.get()) {
                        case month: {
                            return d * 12.0;
                        }
                        case day: {
                            return d * 365.0;
                        }
                    }
                    return d;
                }
                catch (DateTimeParseException dateTimeParseException) {
                    Log.err.println("Failed to parse date '" + string + "' using format '" + this.dateTimeFormatInput.get() + "'");
                    System.exit(1);
                }
            }
            return Double.NaN;
        }
    }

    String normalize(String string) {
        if (string.charAt(0) == ' ') {
            string = string.substring(1);
        }
        if (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public double getDate(double d) {
        if (this.traitNameInput.get().equals(DATE_TRAIT) || this.traitNameInput.get().equals(DATE_FORWARD_TRAIT)) {
            return this.maxValue - d;
        }
        if (this.traitNameInput.get().equals(DATE_BACKWARD_TRAIT)) {
            return this.minValue + d;
        }
        return d;
    }

    public boolean isDateTrait() {
        return this.traitNameInput.get().equals(DATE_TRAIT) || this.traitNameInput.get().equals(DATE_FORWARD_TRAIT) || this.traitNameInput.get().equals(DATE_BACKWARD_TRAIT);
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public static enum Units {
        year,
        month,
        day;

    }
}

