/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.core.BEASTInterface;
import beast.core.Description;
import beast.core.Input;
import beast.core.StateNode;
import beast.core.StateNodeInitialiser;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import beast.evolution.tree.TraitSet;
import beast.evolution.tree.Tree;
import beast.evolution.tree.coalescent.PopulationFunction;
import beast.math.distributions.MRCAPrior;
import beast.math.distributions.ParametricDistribution;
import beast.util.HeapSort;
import beast.util.Randomizer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.math.MathException;

@Description(value="This class provides the basic engine for coalescent simulation of a given demographic model over a given time period. ")
public class RandomTree
extends Tree
implements StateNodeInitialiser {
    public final Input<Alignment> taxaInput = new Input("taxa", "set of taxa to initialise tree specified by alignment");
    public final Input<PopulationFunction> populationFunctionInput = new Input("populationModel", "population function for generating coalescent???", Input.Validate.REQUIRED);
    public final Input<List<MRCAPrior>> calibrationsInput = new Input("constraint", "specifies (monophyletic or height distribution) constraints on internal nodes", new ArrayList());
    public final Input<Double> rootHeightInput = new Input("rootHeight", "If specified the tree will be scaled to match the root height, if constraints allow this");
    int nrOfTaxa;
    int lastMonophyletic;
    List<Set<String>> taxonSets;
    List<ParametricDistribution> distributions;
    List<Bound> m_bounds;
    List<String> taxonSetIDs;
    List<Integer>[] children;
    Set<String> taxa;
    int nextNodeNr;
    private final ArrayList<Node> nodeList = new ArrayList();
    private int activeNodeCount = 0;

    @Override
    public void initAndValidate() {
        this.taxa = new LinkedHashSet<String>();
        if (this.taxaInput.get() != null) {
            this.taxa.addAll(this.taxaInput.get().getTaxaNames());
        } else {
            this.taxa.addAll(((TaxonSet)this.m_taxonset.get()).asStringList());
        }
        this.nrOfTaxa = this.taxa.size();
        this.initStateNodes();
        super.initAndValidate();
    }

    private void swap(List list, int n, int n2) {
        Object e = list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, e);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initStateNodes() {
        void var3_16;
        void var3_14;
        void var3_12;
        AbstractCollection abstractCollection;
        Object object;
        this.taxonSets = new ArrayList<Set<String>>();
        this.m_bounds = new ArrayList<Bound>();
        this.distributions = new ArrayList<ParametricDistribution>();
        this.taxonSetIDs = new ArrayList<String>();
        this.lastMonophyletic = 0;
        if (this.taxaInput.get() != null) {
            this.taxa.addAll(this.taxaInput.get().getTaxaNames());
        } else {
            this.taxa.addAll(((TaxonSet)this.m_taxonset.get()).asStringList());
        }
        ArrayList<MRCAPrior> arrayList = new ArrayList<MRCAPrior>();
        arrayList.addAll((Collection)this.calibrationsInput.get());
        for (BEASTInterface bEASTInterface : this.getOutputs()) {
            if (!(bEASTInterface instanceof MRCAPrior) || arrayList.contains(bEASTInterface)) continue;
            arrayList.add((MRCAPrior)bEASTInterface);
        }
        if (this.m_initial.get() != null) {
            for (BEASTInterface n : ((Tree)this.m_initial.get()).getOutputs()) {
                if (!(n instanceof MRCAPrior) || arrayList.contains(n)) continue;
                arrayList.add((MRCAPrior)n);
            }
        }
        for (MRCAPrior mRCAPrior : arrayList) {
            object = mRCAPrior.taxonsetInput.get();
            if (object == null || mRCAPrior.onlyUseTipsInput.get().booleanValue()) continue;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (((TaxonSet)object).asStringList() == null) {
                ((TaxonSet)object).initAndValidate();
            }
            for (String string : ((TaxonSet)object).asStringList()) {
                if (!this.taxa.contains(string)) {
                    throw new IllegalArgumentException("Taxon <" + string + "> could not be found in list of taxa. Choose one of " + this.taxa);
                }
                linkedHashSet.add(string);
            }
            ParametricDistribution parametricDistribution = mRCAPrior.distInput.get();
            Bound bound = new Bound();
            if (parametricDistribution != null) {
                abstractCollection = new ArrayList<BEASTInterface>();
                parametricDistribution.getPredecessors((List<BEASTInterface>)((Object)abstractCollection));
                for (int i = abstractCollection.size() - 1; i >= 0; --i) {
                    ((BEASTInterface)abstractCollection.get(i)).initAndValidate();
                }
                try {
                    bound.lower = parametricDistribution.inverseCumulativeProbability(0.0) + parametricDistribution.offsetInput.get();
                    bound.upper = parametricDistribution.inverseCumulativeProbability(1.0) + parametricDistribution.offsetInput.get();
                }
                catch (MathException mathException) {
                    Log.warning.println("At RandomTree::initStateNodes, bound on MRCAPrior could not be set " + mathException.getMessage());
                }
            }
            if (mRCAPrior.isMonophyleticInput.get().booleanValue()) {
                this.taxonSets.add(this.lastMonophyletic, linkedHashSet);
                this.distributions.add(this.lastMonophyletic, parametricDistribution);
                this.m_bounds.add(this.lastMonophyletic, bound);
                this.taxonSetIDs.add(mRCAPrior.getID());
                ++this.lastMonophyletic;
                continue;
            }
            if (Double.isInfinite(bound.lower) && Double.isInfinite(bound.upper)) continue;
            this.taxonSets.add(linkedHashSet);
            this.distributions.add(parametricDistribution);
            this.m_bounds.add(bound);
            this.taxonSetIDs.add(mRCAPrior.getID());
        }
        this.lastMonophyletic = this.taxonSets.size();
        for (int i = 0; i < this.lastMonophyletic; ++i) {
            for (int j = i + 1; j < this.lastMonophyletic; ++j) {
                object = new LinkedHashSet(this.taxonSets.get(i));
                object.retainAll((Collection)this.taxonSets.get(j));
                if (object.size() <= 0) continue;
                boolean bl = this.taxonSets.get(i).containsAll((Collection)this.taxonSets.get(j));
                boolean bl2 = this.taxonSets.get(j).containsAll((Collection)this.taxonSets.get(i));
                if (!bl && !bl2) {
                    throw new IllegalArgumentException("333: Don't know how to generate a Random Tree for taxon sets that intersect, but are not inclusive. Taxonset " + this.taxonSetIDs.get(i) + " and " + this.taxonSetIDs.get(j));
                }
                if (!bl) continue;
                this.swap(this.taxonSets, i, j);
                this.swap(this.distributions, i, j);
                this.swap(this.m_bounds, i, j);
                this.swap(this.taxonSetIDs, i, j);
            }
        }
        int[] nArray = new int[this.lastMonophyletic];
        this.children = new List[this.lastMonophyletic + 1];
        boolean bl = false;
        while (var3_12 < this.lastMonophyletic + 1) {
            this.children[var3_12] = new ArrayList<Integer>();
            ++var3_12;
        }
        boolean bl3 = false;
        while (var3_14 < this.lastMonophyletic) {
            void var4_19;
            for (var4_19 = var3_14 + true; var4_19 < this.lastMonophyletic && !this.taxonSets.get((int)var4_19).containsAll((Collection)this.taxonSets.get((int)var3_14)); ++var4_19) {
            }
            nArray[var3_14] = var4_19;
            this.children[var4_19].add((int)var3_14);
            ++var3_14;
        }
        int n = this.lastMonophyletic - 1;
        while (var3_16 >= 0) {
            if (nArray[var3_16] < this.lastMonophyletic && this.m_bounds.get((int)var3_16).upper > this.m_bounds.get((int)nArray[var3_16]).upper) {
                this.m_bounds.get((int)var3_16).upper = this.m_bounds.get((int)nArray[var3_16]).upper - 1.0E-100;
            }
            --var3_16;
        }
        PopulationFunction populationFunction = this.populationFunctionInput.get();
        this.simulateTree(this.taxa, populationFunction);
        if (this.rootHeightInput.get() != null) {
            this.scaleToFit(this.rootHeightInput.get() / this.root.getHeight(), this.root);
        }
        this.nodeCount = 2 * this.taxa.size() - 1;
        this.internalNodeCount = this.taxa.size() - 1;
        this.leafNodeCount = this.taxa.size();
        HashMap<String, Integer> hashMap = null;
        if (this.m_initial.get() != null) {
            if (this.leafNodeCount == ((Tree)this.m_initial.get()).getLeafNodeCount()) {
                hashMap = new HashMap();
                for (Node node : ((Tree)this.m_initial.get()).getExternalNodes()) {
                    hashMap.put(node.getID(), node.getNr());
                }
            }
        } else {
            hashMap = new HashMap<String, Integer>();
            String[] stringArray = this.getTaxaNames();
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], i);
            }
        }
        this.setNodesNrs(this.root, 0, new int[1], hashMap);
        this.initArrays();
        if (this.m_initial.get() != null) {
            ((Tree)this.m_initial.get()).assignFromWithoutID(this);
        }
        for (int i = 0; i < this.lastMonophyletic; ++i) {
            MRCAPrior mRCAPrior = (MRCAPrior)arrayList.get(i);
            if (!mRCAPrior.isMonophyleticInput.get().booleanValue()) continue;
            TaxonSet taxonSet = mRCAPrior.taxonsetInput.get();
            if (taxonSet == null) {
                throw new IllegalArgumentException("Something is wrong with constraint " + mRCAPrior.getID() + " -- a taxonset must be specified if a monophyletic constraint is enforced.");
            }
            abstractCollection = new LinkedHashSet();
            if (taxonSet.asStringList() == null) {
                taxonSet.initAndValidate();
            }
            abstractCollection.addAll(taxonSet.asStringList());
            this.traverse(this.root, (Set<String>)((Object)abstractCollection), taxonSet.getTaxonCount(), new int[1]);
        }
    }

    private int setNodesNrs(Node node, int n, int[] nArray, Map<String, Integer> map) {
        if (node.isLeaf()) {
            if (map != null) {
                node.setNr(map.get(node.getID()));
            } else {
                node.setNr(nArray[0]);
                nArray[0] = nArray[0] + 1;
            }
        } else {
            for (Node node2 : node.getChildren()) {
                n = this.setNodesNrs(node2, n, nArray, map);
            }
            node.setNr(this.nrOfTaxa + n);
            ++n;
        }
        return n;
    }

    private void scaleToFit(double d, Node node) {
        if (!node.isLeaf()) {
            double d2 = node.getHeight();
            node.height *= d;
            Integer n = this.getDistrConstraint(node);
            if (n != null && (node.height < this.m_bounds.get((int)n.intValue()).lower || node.height > this.m_bounds.get((int)n.intValue()).upper)) {
                node.height = d2;
                return;
            }
            this.scaleToFit(d, node.getLeft());
            this.scaleToFit(d, node.getRight());
            if (node.height < Math.max(node.getLeft().getHeight(), node.getRight().getHeight())) {
                node.height = 1.0000001 * Math.max(node.getLeft().getHeight(), node.getRight().getHeight());
            }
        }
    }

    @Override
    public void getInitialisedStateNodes(List<StateNode> list) {
        list.add((StateNode)this.m_initial.get());
    }

    public void simulateTree(Set<String> set, PopulationFunction populationFunction) {
        if (set.size() == 0) {
            return;
        }
        String string = "Failed to generate a random tree (probably a bug).";
        for (int i = 0; i < 1000; ++i) {
            try {
                this.nextNodeNr = this.nrOfTaxa;
                LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
                int n = 0;
                for (String object : set) {
                    Node node = this.newNode();
                    node.setNr(n);
                    node.setID(object);
                    node.setHeight(0.0);
                    linkedHashSet.add(node);
                    ++n;
                }
                if (this.m_initial.get() != null) {
                    this.processCandidateTraits(linkedHashSet, ((Tree)this.m_initial.get()).m_traitList.get());
                } else {
                    this.processCandidateTraits(linkedHashSet, (List)this.m_traitList.get());
                }
                TreeMap treeMap = new TreeMap();
                for (Node node : linkedHashSet) {
                    treeMap.put(node.getID(), node);
                }
                this.root = this.simulateCoalescent(this.lastMonophyletic, treeMap, linkedHashSet, populationFunction);
                return;
            }
            catch (ConstraintViolatedException constraintViolatedException) {
                string = "\nWARNING: Generating a random tree did not succeed. The most common reasons are:\n";
                string = string + "1. there are conflicting monophyletic constraints, for example if both (A,B) \nand (B,C) must be monophyletic no tree will be able to meet these constraints at the same \ntime. To fix this, carefully check all clade sets, especially the ones that are expected to \nbe nested clades.\n";
                string = string + "2. clade heights are constrained by an upper and lower bound, but the population size \nis too large, so it is very unlikely a generated treed does not violate these constraints. To \nfix this you can try to reduce the population size of the population model.\n";
                string = string + "Expect BEAST to crash if this is not fixed.\n";
                Log.err.println(string);
                continue;
            }
        }
        throw new RuntimeException(string);
    }

    private void processCandidateTraits(Set<Node> set, List<TraitSet> list) {
        for (TraitSet traitSet : list) {
            for (Node node : set) {
                node.setMetaData(traitSet.getTraitName(), traitSet.getValue(node.getID()));
            }
        }
    }

    private Node simulateCoalescent(int n, Map<String, Node> map, Set<Node> set, PopulationFunction populationFunction) throws ConstraintViolatedException {
        Object object;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator<Object> iterator = this.children[n].iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next();
            object = new LinkedHashSet();
            Set<String> set2 = this.taxonSets.get(n2);
            for (String string : set2) {
                object.add(map.get(string));
            }
            Node node = this.simulateCoalescent(n2, map, (Set<Node>)object, populationFunction);
            arrayList.add(node);
            treeSet.addAll(set2);
        }
        for (Node node : set) {
            if (treeSet.contains(node.getID())) continue;
            arrayList.add(node);
        }
        double d = n < this.m_bounds.size() ? this.m_bounds.get((int)n).upper : Double.POSITIVE_INFINITY;
        object = this.simulateCoalescentWithMax(arrayList, populationFunction, d);
        return object;
    }

    public Node simulateCoalescentWithMax(List<Node> list, PopulationFunction populationFunction, double d) throws ConstraintViolatedException {
        if (list.size() == 0) {
            throw new IllegalArgumentException("empty nodes set");
        }
        for (int i = 0; i < 1000; ++i) {
            List<Node> list2 = this.simulateCoalescent(list, populationFunction, 0.0, d);
            if (list2.size() != 1) continue;
            return list2.get(0);
        }
        if (Double.isFinite(d)) {
            double d2 = -1.0;
            for (Node node : this.nodeList) {
                d2 = Math.max(d2, node.getHeight());
            }
            assert (d2 < d);
            double d3 = (d - d2) / (double)(this.nodeList.size() + 1);
            while (this.nodeList.size() > 1) {
                int n = this.nodeList.size() - 1;
                Node node = this.nodeList.remove(n);
                Node node2 = this.nodeList.get(n - 1);
                Node node3 = this.newNode();
                node3.setNr(this.nextNodeNr++);
                node3.setHeight(d2 + d3);
                node3.setLeft(node);
                node.setParent(node3);
                node3.setRight(node2);
                node2.setParent(node3);
                this.nodeList.set(n - 1, node3);
            }
            assert (this.nodeList.size() == 1);
            return this.nodeList.get(0);
        }
        throw new RuntimeException("failed to merge trees after 1000 tries!");
    }

    public List<Node> simulateCoalescent(List<Node> list, PopulationFunction populationFunction, double d, double d2) throws ConstraintViolatedException {
        if (list.size() == 1) {
            return list;
        }
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = list.get(i).getHeight();
        }
        int[] nArray = new int[list.size()];
        HeapSort.sort(dArray, nArray);
        this.nodeList.clear();
        this.activeNodeCount = 0;
        for (int i = 0; i < list.size(); ++i) {
            this.nodeList.add(list.get(nArray[i]));
        }
        this.setCurrentHeight(d);
        while (this.getActiveNodeCount() < 2) {
            d = this.getMinimumInactiveHeight();
            this.setCurrentHeight(d);
        }
        double d3 = d + PopulationFunction.Utils.getSimulatedInterval(populationFunction, this.getActiveNodeCount(), d);
        while (d3 < d2 && this.nodeList.size() > 1) {
            if (d3 >= this.getMinimumInactiveHeight()) {
                d = this.getMinimumInactiveHeight();
                this.setCurrentHeight(d);
            } else {
                d = this.coalesceTwoActiveNodes(d, d3);
            }
            if (this.nodeList.size() <= 1) continue;
            while (this.getActiveNodeCount() < 2) {
                d = this.getMinimumInactiveHeight();
                this.setCurrentHeight(d);
            }
            d3 = d + PopulationFunction.Utils.getSimulatedInterval(populationFunction, this.getActiveNodeCount(), d);
        }
        return this.nodeList;
    }

    private double getMinimumInactiveHeight() {
        if (this.activeNodeCount < this.nodeList.size()) {
            return this.nodeList.get(this.activeNodeCount).getHeight();
        }
        return Double.POSITIVE_INFINITY;
    }

    private void setCurrentHeight(double d) {
        while (this.getMinimumInactiveHeight() <= d) {
            ++this.activeNodeCount;
        }
    }

    private int getActiveNodeCount() {
        return this.activeNodeCount;
    }

    private double coalesceTwoActiveNodes(double d, double d2) throws ConstraintViolatedException {
        int n;
        int n2 = n = Randomizer.nextInt(this.activeNodeCount);
        while (n2 == n) {
            n2 = Randomizer.nextInt(this.activeNodeCount);
        }
        Node node = this.nodeList.get(n);
        Node node2 = this.nodeList.get(n2);
        Node node3 = this.newNode();
        node3.setNr(this.nextNodeNr++);
        node3.setHeight(d2);
        node3.setLeft(node);
        node.setParent(node3);
        node3.setRight(node2);
        node2.setParent(node3);
        this.nodeList.remove(node);
        this.nodeList.remove(node2);
        this.activeNodeCount -= 2;
        this.nodeList.add(this.activeNodeCount, node3);
        ++this.activeNodeCount;
        Integer n3 = this.getDistrConstraint(node3);
        if (n3 != null) {
            double d3 = Math.max(this.m_bounds.get((int)n3.intValue()).lower, d);
            double d4 = this.m_bounds.get((int)n3.intValue()).upper;
            if (d4 < d3) {
                throw new ConstraintViolatedException();
            }
            if (d2 < d3 || d2 > d4) {
                d2 = d4 == Double.POSITIVE_INFINITY ? d3 + 0.1 : d3 + Randomizer.nextDouble() * (d4 - d3);
                node3.setHeight(d2);
            }
        }
        if (this.getMinimumInactiveHeight() < d2) {
            throw new RuntimeException("This should never happen! Somehow the current active node is older than the next inactive node!\nOne possible solution you can try is to increase the population size of the population model.");
        }
        return d2;
    }

    private Integer getDistrConstraint(Node node) {
        for (int i = 0; i < this.distributions.size(); ++i) {
            Set<String> set;
            if (this.distributions.get(i) == null || this.traverse(node, set = this.taxonSets.get(i), set.size(), new int[1]) != this.nrOfTaxa + 127) continue;
            return i;
        }
        return null;
    }

    int traverse(Node node, Set<String> set, int n, int[] nArray) {
        if (node.isLeaf()) {
            nArray[0] = nArray[0] + 1;
            if (set.contains(node.getID())) {
                return 1;
            }
            return 0;
        }
        int n2 = this.traverse(node.getLeft(), set, n, nArray);
        int n3 = nArray[0];
        nArray[0] = 0;
        if (node.getRight() != null) {
            n2 += this.traverse(node.getRight(), set, n, nArray);
            int n4 = nArray[0];
            nArray[0] = n3 + n4;
        }
        if (n2 == this.nrOfTaxa + 127) {
            ++n2;
        }
        if (n2 == n) {
            return this.nrOfTaxa + 127;
        }
        return n2;
    }

    @Override
    public String[] getTaxaNames() {
        if (this.m_sTaxaNames == null) {
            List<String> list = this.taxaInput.get() != null ? this.taxaInput.get().getTaxaNames() : ((TaxonSet)this.m_taxonset.get()).asStringList();
            this.m_sTaxaNames = list.toArray(new String[list.size()]);
        }
        return this.m_sTaxaNames;
    }

    protected class ConstraintViolatedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected ConstraintViolatedException() {
        }
    }

    class Bound {
        Double upper = Double.POSITIVE_INFINITY;
        Double lower = Double.NEGATIVE_INFINITY;

        Bound() {
        }

        public String toString() {
            return "[" + this.lower + "," + this.upper + "]";
        }
    }
}

