/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.evolution.tree.Tree;
import beast.util.HeapSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Description(value="Nodes in building beast.tree data structure.")
public class Node
extends BEASTObject {
    protected int labelNr;
    protected double height = Double.MAX_VALUE;
    protected Map<String, Object> metaData = new TreeMap<String, Object>();
    protected Map<String, Object> lengthMetaData = new TreeMap<String, Object>();
    List<Node> children = new ArrayList<Node>();
    Node parent = null;
    int isDirty = 0;
    public String metaDataString;
    public String lengthMetaDataString;
    protected Tree m_tree;

    public Node() {
    }

    public Node(String string) {
        this.setID(string);
        this.initAndValidate();
    }

    public Tree getTree() {
        return this.m_tree;
    }

    @Override
    public void initAndValidate() {
    }

    public int getNr() {
        return this.labelNr;
    }

    public void setNr(int n) {
        this.labelNr = n;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDate() {
        return this.m_tree.getDate(this.height);
    }

    public void setHeight(double d) {
        this.startEditing();
        this.height = d;
        this.isDirty |= 1;
        if (!this.isLeaf()) {
            this.getLeft().isDirty |= 1;
            if (this.getRight() != null) {
                this.getRight().isDirty |= 1;
            }
        }
    }

    public final double getLength() {
        if (this.isRoot()) {
            return 0.0;
        }
        return this.getParent().height - this.height;
    }

    public int isDirty() {
        return this.isDirty;
    }

    public void makeDirty(int n) {
        this.isDirty |= n;
    }

    public void makeAllDirty(int n) {
        this.isDirty = n;
        if (!this.isLeaf()) {
            this.getLeft().makeAllDirty(n);
            if (this.getRight() != null) {
                this.getRight().makeAllDirty(n);
            }
        }
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.setParent(node, true);
    }

    void setParent(Node node, boolean bl) {
        if (bl) {
            this.startEditing();
        }
        if (this.parent != node) {
            this.parent = node;
            if (bl) {
                this.isDirty = 2;
            }
        }
    }

    void setParentImmediate(Node node) {
        this.parent = node;
    }

    public List<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<Node> getAllChildNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (!this.isLeaf()) {
            this.getAllChildNodes(arrayList);
        }
        return arrayList;
    }

    public void getAllChildNodes(List<Node> list) {
        list.add(this);
        for (Node node : this.children) {
            node.getAllChildNodes(list);
        }
    }

    public List<Node> getAllLeafNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (!this.isLeaf()) {
            this.getAllLeafNodes(arrayList);
        }
        return arrayList;
    }

    public void getAllLeafNodes(List<Node> list) {
        if (this.isLeaf()) {
            list.add(this);
        }
        for (Node node : this.children) {
            node.getAllLeafNodes(list);
        }
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public void removeChild(Node node) {
        this.startEditing();
        this.children.remove(node);
    }

    public void removeAllChildren(boolean bl) {
        if (bl) {
            this.startEditing();
        }
        this.children.clear();
    }

    public void addChild(Node node) {
        node.setParent(this);
        this.children.add(node);
    }

    public int getNodeCount() {
        int n = 1;
        for (Node node : this.children) {
            n += node.getNodeCount();
        }
        return n;
    }

    public int getLeafNodeCount() {
        if (this.isLeaf()) {
            return 1;
        }
        int n = 0;
        for (Node node : this.children) {
            n += node.getLeafNodeCount();
        }
        return n;
    }

    public int getInternalNodeCount() {
        if (this.isLeaf()) {
            return 0;
        }
        int n = 1;
        for (Node node : this.children) {
            n += node.getInternalNodeCount();
        }
        return n;
    }

    public String toShortNewick(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isLeaf()) {
            stringBuilder.append("(");
            boolean bl2 = true;
            for (Node node : this.getChildren()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(node.toShortNewick(bl));
            }
            stringBuilder.append(")");
        }
        if (this.isLeaf() || this.getID() != null || bl) {
            stringBuilder.append(this.getNr());
        }
        stringBuilder.append(this.getNewickMetaData());
        stringBuilder.append(":").append(this.getNewickLengthMetaData()).append(this.getLength());
        return stringBuilder.toString();
    }

    String toSortedNewick(int[] nArray) {
        return this.toSortedNewick(nArray, false);
    }

    public String toSortedNewick(int[] nArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isLeaf()) {
            if (this.getChildCount() <= 2) {
                stringBuilder.append("(");
                String string = this.getChild(0).toSortedNewick(nArray, bl);
                int n3 = nArray[0];
                if (this.getChildCount() > 1) {
                    String string2 = this.getChild(1).toSortedNewick(nArray, bl);
                    int n4 = nArray[0];
                    if (n3 > n4) {
                        stringBuilder.append(string2);
                        stringBuilder.append(",");
                        stringBuilder.append(string);
                    } else {
                        stringBuilder.append(string);
                        stringBuilder.append(",");
                        stringBuilder.append(string2);
                        nArray[0] = n3;
                    }
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(")");
                if (this.getID() != null) {
                    stringBuilder.append(this.labelNr + 1);
                }
            } else {
                int n5;
                String[] stringArray = new String[this.getChildCount()];
                int[] nArray2 = new int[this.getChildCount()];
                Integer[] integerArray = new Integer[this.getChildCount()];
                for (n5 = 0; n5 < this.getChildCount(); ++n5) {
                    stringArray[n5] = this.getChild(n5).toSortedNewick(nArray, bl);
                    nArray2[n5] = nArray[0];
                    integerArray[n5] = n5;
                }
                Arrays.sort(integerArray, (n, n2) -> {
                    if (nArray2[n] < nArray2[n2]) {
                        return -1;
                    }
                    if (nArray2[n] > nArray2[n2]) {
                        return 1;
                    }
                    return 0;
                });
                nArray[0] = nArray2[nArray2.length - 1];
                stringBuilder.append("(");
                for (n5 = 0; n5 < integerArray.length; ++n5) {
                    if (n5 > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(stringArray[integerArray[n5]]);
                }
                stringBuilder.append(")");
                if (this.getID() != null) {
                    stringBuilder.append(this.labelNr + 1);
                }
            }
        } else {
            nArray[0] = this.labelNr;
            stringBuilder.append(this.labelNr + 1);
        }
        if (bl) {
            stringBuilder.append(this.getNewickMetaData());
        }
        stringBuilder.append(":");
        if (bl) {
            stringBuilder.append(this.getNewickLengthMetaData());
        }
        stringBuilder.append(this.getLength());
        return stringBuilder.toString();
    }

    @Deprecated
    public String toNewick(List<String> list) {
        throw new UnsupportedOperationException("Please use toNewick(). Labels will come from node.getId() or node.getNr().");
    }

    public String toNewick(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isLeaf()) {
            stringBuilder.append("(");
            boolean bl2 = true;
            for (Node node : this.getChildren()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(node.toNewick(bl));
            }
            stringBuilder.append(")");
            if (this.getID() != null) {
                stringBuilder.append(this.getID());
            }
        } else if (this.getID() != null) {
            stringBuilder.append(this.getID());
        } else {
            stringBuilder.append(this.labelNr);
        }
        if (!bl) {
            stringBuilder.append(this.getNewickMetaData());
            stringBuilder.append(":").append(this.getNewickLengthMetaData()).append(this.getLength());
        }
        return stringBuilder.toString();
    }

    public String toNewick() {
        return this.toNewick(false);
    }

    public String getNewickMetaData() {
        if (this.metaDataString != null) {
            return "[&" + this.metaDataString + ']';
        }
        return "";
    }

    public String getNewickLengthMetaData() {
        if (this.lengthMetaDataString != null) {
            return "[&" + this.lengthMetaDataString + "]";
        }
        return "";
    }

    public String toString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isLeaf()) {
            stringBuilder.append(list.get(this.labelNr));
        } else {
            stringBuilder.append("(");
            boolean bl = true;
            for (Node node : this.getChildren()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(node.toString(list));
            }
            stringBuilder.append(")");
        }
        if (this.isLeaf()) {
            stringBuilder.append(list.get(this.labelNr));
        }
        if (this.metaDataString != null) {
            stringBuilder.append('[');
            stringBuilder.append(this.metaDataString);
            stringBuilder.append(']');
        }
        stringBuilder.append(":");
        if (this.lengthMetaDataString != null) {
            stringBuilder.append('[');
            stringBuilder.append(this.lengthMetaDataString);
            stringBuilder.append(']');
        }
        stringBuilder.append(this.getLength());
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.toShortNewick(true);
    }

    public int sort() {
        if (this.isLeaf()) {
            return this.labelNr;
        }
        int n = this.getChildCount();
        if (n == 1) {
            return this.getChild(0).sort();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = new int[n];
        ArrayList<Node> arrayList2 = new ArrayList<Node>(this.getChildren());
        for (Node node : arrayList2) {
            arrayList.add(node.sort());
        }
        HeapSort.sort(arrayList, nArray);
        for (int i = 0; i < n; ++i) {
            this.setChild(i, (Node)arrayList2.get(nArray[i]));
        }
        return (Integer)arrayList.get(nArray[0]);
    }

    public int labelInternalNodes(int n) {
        if (this.isLeaf()) {
            return n;
        }
        n = this.getLeft().labelInternalNodes(n);
        if (this.getRight() != null) {
            n = this.getRight().labelInternalNodes(n);
        }
        this.labelNr = n++;
        return n;
    }

    public Node copy() {
        Node node = new Node();
        node.height = this.height;
        node.labelNr = this.labelNr;
        node.metaDataString = this.metaDataString;
        node.lengthMetaDataString = this.lengthMetaDataString;
        node.metaData = new TreeMap<String, Object>(this.metaData);
        node.lengthMetaData = new TreeMap<String, Object>(this.lengthMetaData);
        node.parent = null;
        node.setID(this.getID());
        for (Node node2 : this.getChildren()) {
            node.addChild(node2.copy());
        }
        return node;
    }

    public void assignTo(Node[] nodeArray) {
        Node node = nodeArray[this.getNr()];
        node.height = this.height;
        node.labelNr = this.labelNr;
        node.metaDataString = this.metaDataString;
        node.lengthMetaDataString = this.lengthMetaDataString;
        node.metaData = new TreeMap<String, Object>(this.metaData);
        node.lengthMetaData = new TreeMap<String, Object>(this.lengthMetaData);
        node.parent = null;
        node.setID(this.getID());
        if (this.getLeft() != null) {
            node.setLeft(nodeArray[this.getLeft().getNr()]);
            this.getLeft().assignTo(nodeArray);
            node.getLeft().parent = node;
            if (this.getRight() != null) {
                node.setRight(nodeArray[this.getRight().getNr()]);
                this.getRight().assignTo(nodeArray);
                node.getRight().parent = node;
            }
        }
    }

    public void assignFrom(Node[] nodeArray, Node node) {
        this.height = node.height;
        this.labelNr = node.labelNr;
        this.metaDataString = node.metaDataString;
        this.lengthMetaDataString = node.lengthMetaDataString;
        this.metaData = new TreeMap<String, Object>(node.metaData);
        this.lengthMetaData = new TreeMap<String, Object>(node.lengthMetaData);
        this.parent = null;
        this.setID(node.getID());
        if (node.getLeft() != null) {
            this.setLeft(nodeArray[node.getLeft().getNr()]);
            this.getLeft().assignFrom(nodeArray, node.getLeft());
            this.getLeft().parent = this;
            if (node.getRight() != null) {
                this.setRight(nodeArray[node.getRight().getNr()]);
                this.getRight().assignFrom(nodeArray, node.getRight());
                this.getRight().parent = this;
            }
        }
    }

    public void setMetaData(String string, Object object) {
        this.startEditing();
        if (string.equals("date") || string.equals("date-forward") || string.equals("date-backward")) {
            this.height = (Double)object;
            this.isDirty |= 1;
        } else {
            this.metaData.put(string, object);
        }
    }

    public void setLengthMetaData(String string, Object object) {
        this.startEditing();
        this.lengthMetaData.put(string, object);
    }

    public Object getMetaData(String string) {
        if (string.equals("date") || string.equals("date-forward") || string.equals("date-backward")) {
            return this.height;
        }
        Object object = this.metaData.get(string);
        if (object != null) {
            return object;
        }
        return 0;
    }

    public Object getLengthMetaData(String string) {
        return this.lengthMetaData.get(string);
    }

    public Set<String> getMetaDataNames() {
        return this.metaData.keySet();
    }

    public Set<String> getLengthMetaDataNames() {
        return this.lengthMetaData.keySet();
    }

    public void scale(double d) {
        this.startEditing();
        this.isDirty |= 1;
        if (!this.isLeaf() && !this.isFake()) {
            this.height *= d;
        }
        if (!this.isLeaf()) {
            this.getLeft().scale(d);
            if (this.getRight() != null) {
                this.getRight().scale(d);
            }
            if (this.height < this.getLeft().height || this.height < this.getRight().height) {
                throw new IllegalArgumentException("Scale gives negative branch length");
            }
        }
    }

    protected void startEditing() {
        if (this.m_tree != null && this.m_tree.getState() != null) {
            this.m_tree.startEditing(null);
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Node getChild(int n) {
        return this.children.get(n);
    }

    public void setChild(int n, Node node) {
        while (this.children.size() <= n) {
            this.children.add(null);
        }
        this.children.set(n, node);
    }

    public void setLeft(Node node) {
        if (this.children.size() == 0) {
            this.children.add(node);
        } else {
            this.children.set(0, node);
        }
    }

    public Node getLeft() {
        if (this.children.size() == 0) {
            return null;
        }
        return this.children.get(0);
    }

    public void setRight(Node node) {
        switch (this.children.size()) {
            case 0: {
                this.children.add(null);
            }
            case 1: {
                this.children.add(node);
                break;
            }
            default: {
                this.children.set(1, node);
            }
        }
    }

    public Node getRight() {
        if (this.children.size() <= 1) {
            return null;
        }
        return this.children.get(1);
    }

    public static Node connect(Node node, Node node2, double d) {
        Node node3 = new Node();
        node3.setHeight(d);
        node3.setLeft(node);
        node3.setRight(node2);
        node.parent = node3;
        node2.parent = node3;
        return node3;
    }

    public boolean isDirectAncestor() {
        return this.isLeaf() && !this.isRoot() && this.getParent().getHeight() == this.getHeight();
    }

    public boolean isFake() {
        if (this.isLeaf()) {
            return false;
        }
        return this.getLeft().isDirectAncestor() || this.getRight() != null && this.getRight().isDirectAncestor();
    }

    public Node getDirectAncestorChild() {
        if (!this.isFake()) {
            return null;
        }
        if (this.getLeft().isDirectAncestor()) {
            return this.getLeft();
        }
        return this.getRight();
    }

    public Node getNonDirectAncestorChild() {
        if (!this.isFake()) {
            return null;
        }
        if (this.getLeft().isDirectAncestor()) {
            return this.getRight();
        }
        if (this.getRight().isDirectAncestor()) {
            return this.getLeft();
        }
        return null;
    }

    public Node getFakeChild() {
        if (this.getLeft().isFake()) {
            return this.getLeft();
        }
        if (this.getRight().isFake()) {
            return this.getRight();
        }
        return null;
    }
}

