/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.Nucleotide;
import beast.evolution.substitutionmodel.Frequencies;
import beast.evolution.substitutionmodel.GeneralSubstitutionModel;
import java.lang.reflect.InvocationTargetException;

@Description(value="Transition model of nucleotide evolution (variable transition rates, two transversion rates). Rates that are not specified are assumed to be 1.")
public class TIM
extends GeneralSubstitutionModel {
    public final Input<RealParameter> rateAGInput = new Input("rateAG", "substitution rate for A to G (default 1)");
    public final Input<RealParameter> rateCTInput = new Input("rateCT", "substitution rate for C to T (default 1)");
    public final Input<RealParameter> rateTransversions1Input = new Input("rateTransversions1", "substitution rate for A<->C and G<->T");
    public final Input<RealParameter> rateTransversions2Input = new Input("rateTransversions2", "substitution rate for C<->G and A<->T");
    RealParameter rateAG;
    RealParameter rateCT;
    RealParameter rateTransversions1;
    RealParameter rateTransversions2;

    public TIM() {
        this.ratesInput.setRule(Input.Validate.OPTIONAL);
        try {
            this.ratesInput.setValue(null, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void initAndValidate() {
        if (this.ratesInput.get() != null) {
            throw new IllegalArgumentException("the rates attribute should not be used. Use the individual rates rateAG, rateCT, etc, instead.");
        }
        this.frequencies = (Frequencies)this.frequenciesInput.get();
        this.updateMatrix = true;
        this.nrOfStates = this.frequencies.getFreqs().length;
        if (this.nrOfStates != 4) {
            throw new IllegalArgumentException("Frequencies has wrong size. Expected 4, but got " + this.nrOfStates);
        }
        try {
            this.eigenSystem = this.createEigenSystem();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.rateMatrix = new double[this.nrOfStates][this.nrOfStates];
        this.relativeRates = new double[this.nrOfStates * (this.nrOfStates - 1)];
        this.storedRelativeRates = new double[this.nrOfStates * (this.nrOfStates - 1)];
        this.rateAG = this.getParameter(this.rateAGInput);
        this.rateCT = this.getParameter(this.rateCTInput);
        this.rateTransversions1 = this.getParameter(this.rateTransversions1Input);
        this.rateTransversions2 = this.getParameter(this.rateTransversions2Input);
    }

    private RealParameter getParameter(Input<RealParameter> input) {
        if (input.get() != null) {
            return input.get();
        }
        return new RealParameter("1.0");
    }

    @Override
    protected void setupRelativeRates() {
        this.relativeRates[0] = this.rateTransversions1.getValue();
        this.relativeRates[1] = this.rateAG.getValue();
        this.relativeRates[2] = this.rateTransversions2.getValue();
        this.relativeRates[3] = this.rateTransversions1.getValue();
        this.relativeRates[4] = this.rateTransversions2.getValue();
        this.relativeRates[5] = this.rateCT.getValue();
        this.relativeRates[6] = this.rateAG.getValue();
        this.relativeRates[7] = this.rateTransversions2.getValue();
        this.relativeRates[8] = this.rateTransversions1.getValue();
        this.relativeRates[9] = this.rateTransversions2.getValue();
        this.relativeRates[10] = this.rateCT.getValue();
        this.relativeRates[11] = this.rateTransversions1.getValue();
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType instanceof Nucleotide;
    }
}

