/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.datatype.DataType;
import beast.evolution.substitutionmodel.EigenDecomposition;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.evolution.tree.Node;

@Description(value="Mutation Death substitution model, can be used as Stochastic Dollo model.")
public class MutationDeathModel
extends SubstitutionModel.Base {
    public final Input<RealParameter> delParameter = new Input("deathprob", "rate of death, used to calculate death probability", Input.Validate.REQUIRED);
    public final Input<SubstitutionModel.Base> CTMCModelInput = new Input("substmodel", "CTMC Model for the life states, so should have a state-space one less than this model. If not specified, ...");
    protected double[] trMatrix;
    int nrOfStates;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        double[] dArray = this.getFrequencies();
        this.nrOfStates = dArray.length;
        this.trMatrix = new double[(this.nrOfStates - 1) * (this.nrOfStates - 1)];
        if (this.CTMCModelInput.get() != null && this.CTMCModelInput.get().frequenciesInput.get().freqs.length != this.nrOfStates - 1) {
            throw new IllegalArgumentException("substmodel does not have the correct state space: should be " + (this.nrOfStates - 1));
        }
    }

    @Override
    public EigenDecomposition getEigenDecomposition(Node node) {
        return null;
    }

    @Override
    public void getTransitionProbabilities(Node node, double d, double d2, double d3, double[] dArray) {
        int n;
        int n2;
        double d4 = (d - d2) * d3;
        double d5 = Math.exp(-d4 * this.delParameter.get().getValue());
        double d6 = 2.0;
        double[] dArray2 = this.getFrequencies();
        for (n2 = 0; n2 < dArray2.length - 1; ++n2) {
            d6 *= dArray2[n2];
        }
        SubstitutionModel.Base base = this.CTMCModelInput.get();
        if (base != null) {
            base.getTransitionProbabilities(node, d, d2, d6 * d3, this.trMatrix);
        } else {
            this.trMatrix[0] = 1.0;
        }
        for (n2 = 0; n2 < this.nrOfStates - 1; ++n2) {
            for (n = 0; n < this.nrOfStates - 1; ++n) {
                dArray[n2 * this.nrOfStates + n] = this.trMatrix[n2 * (this.nrOfStates - 1) + n] * d5;
            }
            dArray[n2 * this.nrOfStates + n] = 1.0 - d5;
        }
        for (n = 0; n < this.nrOfStates - 1; ++n) {
            dArray[this.nrOfStates * (this.nrOfStates - 1) + n] = 0.0;
        }
        dArray[this.nrOfStates * this.nrOfStates - 1] = 1.0;
    }

    @Override
    protected boolean requiresRecalculation() {
        return true;
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        if (this.CTMCModelInput.get() == null) {
            return dataType.getStateCount() == 2;
        }
        int n = this.CTMCModelInput.get().nrOfStates;
        return dataType.getStateCount() == n + 1;
    }
}

