/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.TwoStateCovarion;
import beast.evolution.substitutionmodel.GeneralSubstitutionModel;
import java.lang.reflect.InvocationTargetException;

@Description(value="Covarion model for Binary data")
public class BinaryCovarion
extends GeneralSubstitutionModel {
    public final Input<RealParameter> alphaInput = new Input("alpha", "the rate of evolution in slow mode", Input.Validate.REQUIRED);
    public final Input<RealParameter> switchRateInput = new Input("switchRate", "the rate of flipping between slow and fast modes", Input.Validate.REQUIRED);
    public final Input<RealParameter> frequenciesInput = new Input("vfrequencies", "the frequencies of the visible states", Input.Validate.REQUIRED);
    public final Input<RealParameter> hfrequenciesInput = new Input("hfrequencies", "the frequencies of the hidden rates");
    public final Input<MODE> modeInput = new Input<MODE>("mode", "one of BEAST, REVERSIBLE, TUFFLESTEEL BEAST = implementation as in BEAST 1 REVERSIBLE = like BEAST 1 implementation, but using frequencies to make it reversible TUFFLEYSTEEL = Tuffley & Steel (1996) impementation (no rates for ", MODE.BEAST, MODE.values());
    private RealParameter alpha;
    private RealParameter switchRate;
    private RealParameter frequencies;
    private RealParameter hiddenFrequencies;
    protected double[][] unnormalizedQ;
    protected double[][] storedUnnormalizedQ;
    int stateCount;
    MODE mode = this.modeInput.get();

    public BinaryCovarion() {
        this.ratesInput.setRule(Input.Validate.OPTIONAL);
        this.frequenciesInput.setRule(Input.Validate.OPTIONAL);
    }

    @Override
    public void initAndValidate() {
        this.alpha = this.alphaInput.get();
        this.switchRate = this.switchRateInput.get();
        this.frequencies = this.frequenciesInput.get();
        this.hiddenFrequencies = this.hfrequenciesInput.get();
        this.mode = this.modeInput.get();
        if (this.mode.equals((Object)MODE.BEAST) || this.mode.equals((Object)MODE.REVERSIBLE)) {
            if (this.switchRate.getDimension() != 1) {
                throw new IllegalArgumentException("switchRate should have dimension 1");
            }
        } else if (this.switchRate.getDimension() != 2) {
            throw new IllegalArgumentException("switchRate should have dimension 2");
        }
        if (this.alpha.getDimension() != 1) {
            throw new IllegalArgumentException("alpha should have dimension 1");
        }
        if (this.frequencies.getDimension() != 2) {
            throw new IllegalArgumentException("frequencies should have dimension 2");
        }
        if (this.mode.equals((Object)MODE.BEAST) || this.mode.equals((Object)MODE.REVERSIBLE)) {
            if (this.hfrequenciesInput.get() == null) {
                throw new IllegalArgumentException("hiddenFrequenciesshould should be specified");
            }
            if (this.hiddenFrequencies.getDimension() != 2) {
                throw new IllegalArgumentException("hiddenFrequenciesshould have dimension 2");
            }
        } else if (this.hfrequenciesInput.get() != null) {
            Log.warning.println("WARNING: hfrequencies is specified, but the BinaryCovarion model ignores it.");
        }
        if (!this.mode.equals((Object)MODE.BEAST)) {
            Log.warning.println("If you encounter infinities, or chains getting stuck, consider using a more robust eigen system, by setting the eigenSystem input, e.g. eigenSystem=\"beast.evolution.substitutionmodel.RobustEigenSystem\" available from the beast-classic package.");
        }
        this.nrOfStates = 4;
        this.unnormalizedQ = new double[4][4];
        this.storedUnnormalizedQ = new double[4][4];
        this.updateMatrix = true;
        try {
            this.eigenSystem = this.createEigenSystem();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.rateMatrix = new double[this.nrOfStates][this.nrOfStates];
        this.relativeRates = new double[12];
        this.storedRelativeRates = new double[12];
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType.getClass().equals(TwoStateCovarion.class);
    }

    @Override
    protected void setupRelativeRates() {
    }

    @Override
    protected void setupRateMatrix() {
        int n;
        this.setupUnnormalizedQMatrix();
        for (n = 0; n < 4; ++n) {
            for (int i = 0; i < 4; ++i) {
                this.rateMatrix[n][i] = this.unnormalizedQ[n][i];
            }
        }
        for (n = 0; n < this.nrOfStates; ++n) {
            double d = 0.0;
            for (int i = 0; i < this.nrOfStates; ++i) {
                if (n == i) continue;
                d += this.rateMatrix[n][i];
            }
            this.rateMatrix[n][n] = -d;
        }
        this.normalize(this.rateMatrix, this.getFrequencies());
    }

    @Override
    public double[] getFrequencies() {
        double[] dArray = new double[4];
        if (this.mode.equals((Object)MODE.BEAST) || this.mode.equals((Object)MODE.REVERSIBLE)) {
            dArray[0] = (Double)this.frequencies.getValue(0) * (Double)this.hiddenFrequencies.getValue(0);
            dArray[1] = (Double)this.frequencies.getValue(1) * (Double)this.hiddenFrequencies.getValue(0);
            dArray[2] = (Double)this.frequencies.getValue(0) * (Double)this.hiddenFrequencies.getValue(1);
            dArray[3] = (Double)this.frequencies.getValue(1) * (Double)this.hiddenFrequencies.getValue(1);
        } else {
            double d = (Double)this.switchRate.getValue(1) / ((Double)this.switchRate.getValue(0) + (Double)this.switchRate.getValue(1));
            double d2 = (Double)this.switchRate.getValue(0) / ((Double)this.switchRate.getValue(0) + (Double)this.switchRate.getValue(1));
            dArray[0] = (Double)this.frequencies.getValue(0) * d;
            dArray[1] = (Double)this.frequencies.getValue(1) * d;
            dArray[2] = (Double)this.frequencies.getValue(0) * d2;
            dArray[3] = (Double)this.frequencies.getValue(1) * d2;
        }
        return dArray;
    }

    protected void setupUnnormalizedQMatrix() {
        switch (this.mode) {
            case BEAST: {
                double d = (Double)this.alpha.getValue(0);
                double d2 = (Double)this.switchRate.getValue(0);
                double d3 = (Double)this.hiddenFrequencies.getValue(0);
                double d4 = (Double)this.hiddenFrequencies.getValue(1);
                double d5 = (Double)this.frequencies.getValue(0);
                double d6 = (Double)this.frequencies.getValue(1);
                assert (Math.abs(1.0 - d3 - d4) < 1.0E-8);
                assert (Math.abs(1.0 - d5 - d6) < 1.0E-8);
                this.unnormalizedQ[0][1] = d * d6;
                this.unnormalizedQ[0][2] = d2;
                this.unnormalizedQ[0][3] = 0.0;
                this.unnormalizedQ[1][0] = d * d5;
                this.unnormalizedQ[1][2] = 0.0;
                this.unnormalizedQ[1][3] = d2;
                this.unnormalizedQ[2][0] = d2;
                this.unnormalizedQ[2][1] = 0.0;
                this.unnormalizedQ[2][3] = d6;
                this.unnormalizedQ[3][0] = 0.0;
                this.unnormalizedQ[3][1] = d2;
                this.unnormalizedQ[3][2] = d5;
                break;
            }
            case REVERSIBLE: {
                double d = (Double)this.alpha.getValue(0);
                double d7 = (Double)this.switchRate.getValue(0);
                double d8 = (Double)this.hiddenFrequencies.getValue(0);
                double d9 = (Double)this.hiddenFrequencies.getValue(1);
                double d10 = (Double)this.frequencies.getValue(0);
                double d11 = (Double)this.frequencies.getValue(1);
                assert (Math.abs(1.0 - d8 - d9) < 1.0E-8);
                assert (Math.abs(1.0 - d10 - d11) < 1.0E-8);
                this.unnormalizedQ[0][1] = d * d11 * d8;
                this.unnormalizedQ[0][2] = d7 * d9;
                this.unnormalizedQ[0][3] = 0.0;
                this.unnormalizedQ[1][0] = d * d10 * d8;
                this.unnormalizedQ[1][2] = 0.0;
                this.unnormalizedQ[1][3] = d7 * d9;
                this.unnormalizedQ[2][0] = d7 * d8;
                this.unnormalizedQ[2][1] = 0.0;
                this.unnormalizedQ[2][3] = d11 * d9;
                this.unnormalizedQ[3][0] = 0.0;
                this.unnormalizedQ[3][1] = d7 * d8;
                this.unnormalizedQ[3][2] = d10 * d9;
                break;
            }
            case TUFFLEYSTEEL: {
                double d = (Double)this.alpha.getValue(0);
                double d12 = (Double)this.switchRate.getValue(0);
                double d13 = (Double)this.switchRate.getValue(1);
                double d14 = (Double)this.frequencies.getValue(0);
                double d15 = (Double)this.frequencies.getValue(1);
                assert (Math.abs(1.0 - d14 - d15) < 1.0E-8);
                this.unnormalizedQ[0][1] = d * d15;
                this.unnormalizedQ[0][2] = d12;
                this.unnormalizedQ[0][3] = 0.0;
                this.unnormalizedQ[1][0] = d * d14;
                this.unnormalizedQ[1][2] = 0.0;
                this.unnormalizedQ[1][3] = d12;
                this.unnormalizedQ[2][0] = d13;
                this.unnormalizedQ[2][1] = 0.0;
                this.unnormalizedQ[2][3] = d15;
                this.unnormalizedQ[3][0] = 0.0;
                this.unnormalizedQ[3][1] = d13;
                this.unnormalizedQ[3][2] = d14;
            }
        }
    }

    private void normalize(double[][] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        int n2 = dArray2.length;
        for (n = 0; n < n2; ++n) {
            d += -dArray[n][n] * dArray2[n];
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                dArray[n][i] = dArray[n][i] / d;
            }
        }
        double d2 = 0.0;
        d2 += dArray[0][2] * dArray2[2];
        d2 += dArray[2][0] * dArray2[0];
        d2 += dArray[1][3] * dArray2[3];
        d2 += dArray[3][1] * dArray2[1];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = dArray[i][j] / (1.0 - d2);
            }
        }
    }

    public static enum MODE {
        BEAST,
        REVERSIBLE,
        TUFFLEYSTEEL;

    }
}

