/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.BEASTInterface;
import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.core.util.CompoundDistribution;
import beast.core.util.Log;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.speciation.CalibrationLineagesIterator;
import beast.evolution.speciation.CalibrationPoint;
import beast.evolution.speciation.SpeciesTreeDistribution;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeInterface;
import beast.math.distributions.MRCAPrior;
import beast.math.statistic.RPNcalculator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.MathException;

@Description(value="Birth-Death prior with calibrated monophyletic clades. With this prior, the marginal distribution of the calibrated nodes (the root age of the clade) is identical to the specified calibration, and the density ratio between trees with equal calibration values is equal to the ratio under the Birth-Death prior.")
public class CalibratedBirthDeathModel
extends SpeciesTreeDistribution {
    public final Input<RealParameter> birthRateInput = new Input("birthRate", "birth rate - the rate at which new lineages are created as a result of an existing lineage splitting into two.", Input.Validate.REQUIRED);
    public final Input<RealParameter> deathToBirthRatioInput = new Input("relativeDeathRate", "relative death rate parameter, mu/lambda in birth death model", Input.Validate.OPTIONAL);
    public final Input<RealParameter> sampleProbabilityInput = new Input("sampleProbability", "sample probability, rho in birth/death model", Input.Validate.OPTIONAL);
    public final Input<List<CalibrationPoint>> calibrationsInput = new Input("calibrations", "Set of calibrated nodes", new ArrayList());
    public final Input<Type> correctionTypeInput = new Input<Type>("type", "Type of correction: none for no correction (same as BEAST1), full for Yule-like over calibrated times, and restricted for Yule-like over calibrated times and ranked topology (default 'full'). However, 'full' is generally slow except for a few special cases, such as a single clade or two nested clades.", Type.OVER_ALL_TOPOS, Type.values());
    public final Input<RPNcalculator> userMarInput = new Input<RPNcalculator>("logMarginal", "Use provided formula to compute the (log of) the marginal for special cases.", (RPNcalculator)null);
    private Type type;
    CalibrationPoint[] orderedCalibrations;
    private int[][] xclades;
    private int[][] taxaPartialOrder;
    RPNcalculator userPDF = null;
    boolean calcCalibrations = true;
    boolean isYule = false;
    private CalibrationLineagesIterator linsIter = null;
    double lastLam = Double.NEGATIVE_INFINITY;
    double[] lastHeights;
    double lastValue = Double.NEGATIVE_INFINITY;
    private final double lg2 = Math.log(2.0);
    private double[] lc2;
    private double[] lNR;
    private double[] lfactorials;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initAndValidate() {
        int n;
        void var6_20;
        void var6_18;
        void var6_16;
        int n3;
        super.initAndValidate();
        this.type = this.correctionTypeInput.get();
        TreeInterface treeInterface = (TreeInterface)this.treeInput.get();
        ArrayList<CalibrationPoint> arrayList = new ArrayList<CalibrationPoint>((Collection)this.calibrationsInput.get());
        int n4 = arrayList.size();
        ArrayList<TaxonSet> arrayList2 = new ArrayList<TaxonSet>(n4);
        if (arrayList.size() > 0) {
            this.xclades = new int[n4][];
            for (CalibrationPoint bEASTInterface : arrayList) {
                arrayList2.add(bEASTInterface.taxa());
            }
        } else {
            for (BEASTInterface n5 : this.getOutputs()) {
                if (!(n5 instanceof CompoundDistribution)) continue;
                CompoundDistribution compoundDistribution = (CompoundDistribution)n5;
                for (Distribution distribution : compoundDistribution.pDistributions.get()) {
                    if (!(distribution instanceof MRCAPrior)) continue;
                    MRCAPrior mRCAPrior = (MRCAPrior)distribution;
                    if (mRCAPrior.distInput.get() != null) {
                        if (!mRCAPrior.isMonophyleticInput.get().booleanValue()) {
                            throw new IllegalArgumentException("MRCAPriors must be monophyletic for Calibrated Yule prior");
                        }
                        CalibrationPoint calibrationPoint = new CalibrationPoint();
                        calibrationPoint.distInput.setValue(mRCAPrior.distInput.get(), calibrationPoint);
                        calibrationPoint.taxonsetInput.setValue(mRCAPrior.taxonsetInput.get(), calibrationPoint);
                        calibrationPoint.initAndValidate();
                        arrayList.add(calibrationPoint);
                        arrayList2.add(calibrationPoint.taxa());
                        calibrationPoint.taxa().initAndValidate();
                        ++n4;
                        this.calcCalibrations = false;
                        continue;
                    }
                    if (!mRCAPrior.isMonophyleticInput.get().booleanValue()) continue;
                    Log.warning.println("WARNING: MRCAPriors must have a distribution when monophyletic for Calibrated Yule prior");
                }
            }
            this.xclades = new int[n4][];
        }
        if (n4 == 0) {
            return;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            TaxonSet taxonSet = (TaxonSet)arrayList2.get(n3);
            for (int i = n3 + 1; i < n4; ++i) {
                TaxonSet taxonSet2 = (TaxonSet)arrayList2.get(i);
                if (!taxonSet2.containsAny(taxonSet) || taxonSet2.containsAll(taxonSet) || taxonSet.containsAll(taxonSet2)) continue;
                throw new IllegalArgumentException("Overlapping taxaSets??");
            }
        }
        this.orderedCalibrations = new CalibrationPoint[n4];
        for (n3 = arrayList2.size() - 1; n3 >= 0; --n3) {
            void var6_14;
            assert (n3 == arrayList2.size() - 1);
            boolean bl = false;
            while (var6_14 < arrayList2.size() && !CalibratedBirthDeathModel.isMaximal(arrayList2, (int)var6_14)) {
                ++var6_14;
            }
            List<String> list = ((TaxonSet)arrayList2.get((int)var6_14)).asStringList();
            int n2 = list.size();
            this.xclades[n3] = new int[n2];
            for (int i = 0; i < n2; ++i) {
                int n5;
                this.xclades[n3][i] = n5 = CalibratedBirthDeathModel.getTaxonIndex(treeInterface, list.get(i));
                if (n5 >= 0) continue;
                throw new IllegalArgumentException("Taxon not found in tree: " + list.get(i));
            }
            this.orderedCalibrations[n3] = (CalibrationPoint)arrayList.remove((int)var6_14);
            arrayList2.remove((int)var6_14);
        }
        List[] listArray = new List[this.orderedCalibrations.length];
        boolean bl = false;
        while (var6_16 < this.orderedCalibrations.length) {
            listArray[var6_16] = new ArrayList();
            ++var6_16;
        }
        boolean bl2 = false;
        while (var6_18 < this.orderedCalibrations.length) {
            TaxonSet taxonSet = this.orderedCalibrations[var6_18].taxa();
            for (void var8_31 = var6_18 + true; var8_31 < this.orderedCalibrations.length; ++var8_31) {
                if (!this.orderedCalibrations[var8_31].taxa().containsAll(taxonSet)) continue;
                listArray[var8_31].add((int)var6_18);
                break;
            }
            ++var6_18;
        }
        this.taxaPartialOrder = new int[this.orderedCalibrations.length][];
        boolean bl3 = false;
        while (var6_20 < this.orderedCalibrations.length) {
            List list = listArray[var6_20];
            this.taxaPartialOrder[var6_20] = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.taxaPartialOrder[var6_20][i] = (Integer)list.get(i);
            }
            ++var6_20;
        }
        boolean[] blArray = new boolean[n4];
        for (n = 0; n < n4; ++n) {
            blArray[n] = true;
        }
        for (n = 0; n < n4; ++n) {
            for (int n6 : this.taxaPartialOrder[n]) {
                blArray[n6] = false;
            }
        }
        this.isYule = this.deathToBirthRatioInput.get() == null && this.sampleProbabilityInput.get() == null;
        this.userPDF = this.userMarInput.get();
        if (this.userPDF == null) {
            n = 0;
            if (this.type == Type.OVER_ALL_TOPOS) {
                if (n4 != 1 || !this.isYule) {
                    boolean bl4 = false;
                    for (CalibrationPoint calibrationPoint : this.orderedCalibrations) {
                        if (!calibrationPoint.forParentInput.get().booleanValue()) continue;
                        bl4 = true;
                    }
                    if (bl4) {
                        throw new IllegalArgumentException("Sorry, not implemented: calibration on parent for more than one clade.");
                    }
                    if (!this.isYule || n4 != 2 || !this.orderedCalibrations[1].taxa().containsAll(this.orderedCalibrations[0].taxa())) {
                        n = 1;
                        this.lastHeights = new double[n4];
                    }
                }
            } else if (this.type == Type.OVER_RANKED_COUNTS) {
                n = 1;
            }
            if (n != 0) {
                this.setUpTables(treeInterface.getLeafNodeCount() + 1);
                this.linsIter = new CalibrationLineagesIterator(this.xclades, this.taxaPartialOrder, blArray, treeInterface.getLeafNodeCount());
            }
        }
        List<Node> list = treeInterface.getExternalNodes();
        double d = list.get(0).getHeight();
        for (Node node : list) {
            if (!(Math.abs(node.getHeight() - d) > 1.0E-8)) continue;
            Log.warning.println("WARNING: Calibrated Birth-Death Model does not handle dated tips correctly. Consider using a coalescent prior instead.");
            break;
        }
    }

    Tree compatibleInitialTree() throws MathException {
        int n;
        int n2;
        int n3 = this.orderedCalibrations.length;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            CalibrationPoint calibrationPoint = this.orderedCalibrations[n2];
            dArray[n2] = calibrationPoint.dist().inverseCumulativeProbability(0.0);
            if (dArray[n2] < 0.0) {
                dArray[n2] = 0.0;
            }
            for (int n4 : this.taxaPartialOrder[n2]) {
                dArray[n2] = Math.max(dArray[n2], dArray[n4]);
            }
            dArray2[n2] = calibrationPoint.dist().inverseCumulativeProbability(1.0);
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            double d = dArray2[n2];
            if (Double.isInfinite(d)) {
                d = dArray[n2] + 1.0;
            }
            dArray2[n2] = (d + dArray[n2]) / 2.0;
            for (int n5 : this.taxaPartialOrder[n2]) {
                dArray2[n5] = Math.min(dArray2[n5], dArray2[n2]);
            }
        }
        TreeInterface treeInterface = (TreeInterface)this.treeInput.get();
        int n6 = treeInterface.getLeafNodeCount();
        boolean[] blArray = new boolean[n6];
        int n7 = -1;
        int n8 = n6 - 1;
        Node[] nodeArray = new Node[n3];
        for (int n5 = 0; n5 < n3; ++n5) {
            int n9;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int n10 : this.xclades[n5]) {
                arrayList.add(n10);
            }
            for (int n10 : this.taxaPartialOrder[n5]) {
                int[] nArray = this.xclades[n10];
                int n11 = nArray.length;
                for (n9 = 0; n9 < n11; ++n9) {
                    int n12 = nArray[n9];
                    arrayList.remove(new Integer(n12));
                }
            }
            Object object = new ArrayList();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n13 = (Integer)iterator.next();
                Node node = new Node(treeInterface.getNode(n13).getID());
                node.setNr(++n7);
                node.setHeight(0.0);
                object.add(node);
                blArray[n13] = true;
            }
            for (Object object2 : (Iterator)this.taxaPartialOrder[n5]) {
                object.add(nodeArray[object2]);
            }
            double d = ((Node)object.get(object.size() - 1)).getHeight();
            double d2 = (dArray2[n5] - d) / (double)(object.size() - 1);
            Node node = (Node)object.get(0);
            for (n9 = 1; n9 < object.size(); ++n9) {
                node = Node.connect(node, (Node)object.get(n9), d + (double)n9 * d2);
                node.setNr(++n8);
            }
            nodeArray[n5] = node;
        }
        Node node = nodeArray[n3 - 1];
        double d = dArray2[n3 - 1];
        for (n = 0; n < n3 - 1; ++n) {
            Node node2 = nodeArray[n];
            d = Math.max(d, dArray2[n]) + 1.0;
            node = Node.connect(node, node2, d);
            node.setNr(++n8);
        }
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n]) continue;
            String string = treeInterface.getNode(n).getID();
            Node node3 = new Node(string);
            node3.setHeight(0.0);
            node3.setNr(++n7);
            node = Node.connect(node, node3, d + 1.0);
            node.setNr(++n8);
            d += 1.0;
        }
        Tree tree = new Tree();
        tree.setRoot(node);
        tree.initAndValidate();
        return tree;
    }

    @Override
    public double calculateTreeLogLikelihood(TreeInterface treeInterface) {
        double d;
        double d2 = this.birthRateInput.get().getArrayValue();
        if (this.isYule) {
            d = CalibratedBirthDeathModel.calculateYuleLikelihood(treeInterface, d2);
            d += this.getCorrection(treeInterface, d2, 0.0, 1.0);
        } else {
            double d3;
            RealParameter realParameter = this.deathToBirthRatioInput.get();
            double d4 = d3 = realParameter != null ? realParameter.getArrayValue() : 0.0;
            assert (d3 < 1.0);
            RealParameter realParameter2 = this.sampleProbabilityInput.get();
            double d5 = realParameter2 != null ? realParameter2.getArrayValue() : 1.0;
            d = this.calculateBDLikelihood(treeInterface, d2, d3, d5);
            d += this.getCorrection(treeInterface, d2, d3, d5);
        }
        return d;
    }

    private double calculateBDLikelihood(TreeInterface treeInterface, double d, double d2, double d3) {
        if (d2 == 0.0 && d3 == 1.0) {
            return CalibratedBirthDeathModel.calculateYuleLikelihood(treeInterface, d);
        }
        int n = treeInterface.getLeafNodeCount();
        double d4 = this.lfactorials[n] + (double)(n - 1) * Math.log(d * d3);
        Node[] nodeArray = treeInterface.getNodesAsArray();
        d4 += (double)n * Math.log(1.0 - d2);
        for (int i = n; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            assert (!node.isLeaf());
            double d5 = node.getHeight();
            double d6 = -d * d5;
            double d7 = Math.log(d3 + (1.0 - d3 - d2) * Math.exp(d6));
            double d8 = -2.0 * d7 + d6;
            if (node.isRoot()) {
                d8 += d6 - d7;
            }
            d4 += d8;
        }
        return d4;
    }

    private static double calculateYuleLikelihood(TreeInterface treeInterface, double d) {
        int n = treeInterface.getLeafNodeCount();
        double d2 = (double)(n - 1) * Math.log(d);
        Node[] nodeArray = treeInterface.getNodesAsArray();
        for (int i = n; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            assert (!node.isLeaf());
            double d3 = node.getHeight();
            double d4 = -d * d3;
            d2 += d4 + (node.isRoot() ? d4 : 0.0);
        }
        return d2;
    }

    public double getCorrection(TreeInterface treeInterface, double d, double d2, double d3) {
        Object object;
        Object object2;
        int n;
        double d4 = 0.0;
        int n2 = this.orderedCalibrations.length;
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            object2 = this.orderedCalibrations[n];
            int[] nArray = this.xclades[n];
            if (nArray.length > 1) {
                object = CalibratedBirthDeathModel.getCommonAncestor(treeInterface, nArray);
                if (CalibratedBirthDeathModel.getLeafCount((Node)object) != nArray.length) {
                    return Double.NEGATIVE_INFINITY;
                }
            } else {
                object = treeInterface.getNode(nArray[0]);
                assert (((CalibrationPoint)object2).forParent());
            }
            if (((CalibrationPoint)object2).forParent()) {
                object = ((Node)object).getParent();
            }
            double d5 = ((Node)object).getHeight();
            if (this.calcCalibrations) {
                d4 += ((CalibrationPoint)object2).logPdf(d5);
            }
            dArray[n] = d5;
        }
        if (Double.isInfinite(d4)) {
            return d4;
        }
        if (this.type == Type.NONE) {
            return d4;
        }
        if (this.userPDF == null) {
            n = treeInterface.getLeafNodeCount();
            switch (this.type) {
                case OVER_ALL_TOPOS: {
                    if (n2 == 1 && this.isYule) {
                        d4 -= CalibratedBirthDeathModel.logMarginalDensity(d, n, dArray[0], this.xclades[0].length, this.orderedCalibrations[0].forParent());
                        break;
                    }
                    if (n2 == 2 && this.taxaPartialOrder[1].length == 1 && this.isYule) {
                        d4 -= CalibratedBirthDeathModel.logMarginalDensity(d, n, dArray[0], this.xclades[0].length, dArray[1], this.xclades[1].length);
                        break;
                    }
                    if (this.lastLam == d) {
                        int n3;
                        for (n3 = 0; n3 < dArray.length && dArray[n3] == this.lastHeights[n3]; ++n3) {
                        }
                        if (n3 == dArray.length) {
                            return this.lastValue;
                        }
                    }
                    double[] dArray2 = new double[dArray.length];
                    object = new int[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        int n4;
                        int n5 = 0;
                        for (n4 = 0; n4 < i; ++n4) {
                            n5 += dArray[n4] <= dArray[i] ? 1 : 0;
                        }
                        for (n4 = i + 1; n4 < dArray.length; ++n4) {
                            n5 += dArray[n4] < dArray[i] ? 1 : 0;
                        }
                        object[i] = n5 + 1;
                        dArray2[n5] = dArray[i];
                    }
                    this.lastLam = d;
                    System.arraycopy(dArray, 0, this.lastHeights, 0, this.lastHeights.length);
                    this.lastValue = d4 -= this.logMarginalDensity(d, dArray2, (int[])object, this.linsIter);
                    break;
                }
                case OVER_RANKED_COUNTS: {
                    double d6;
                    object2 = new int[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        int n6;
                        int n7 = 0;
                        for (n6 = 0; n6 < i; ++n6) {
                            n7 += dArray[n6] <= dArray[i] ? 1 : 0;
                        }
                        for (n6 = i + 1; n6 < dArray.length; ++n6) {
                            n7 += dArray[n6] < dArray[i] ? 1 : 0;
                        }
                        object2[i] = n7 + 1;
                    }
                    double d7 = this.countTrees((int[])object2, this.linsIter);
                    d4 -= d7;
                    Arrays.sort(dArray);
                    int[] nArray = new int[n2 + 1];
                    for (Node node : treeInterface.getInternalNodes()) {
                        int n8;
                        d6 = node.getHeight();
                        for (n8 = 0; n8 < dArray.length && !(dArray[n8] >= d6); ++n8) {
                        }
                        if (n8 == dArray.length) {
                            int n9 = n8;
                            nArray[n9] = nArray[n9] + 1;
                            continue;
                        }
                        if (!(d6 < dArray[n8])) continue;
                        int n10 = n8;
                        nArray[n10] = nArray[n10] + 1;
                    }
                    if (this.isYule) {
                        double d8 = 0.0;
                        d8 += (double)nArray[0] * Math.log1p(-Math.exp(-d * dArray[0])) - d * dArray[0] - this.lfactorials[nArray[0]];
                        for (int i = 1; i < nArray.length - 1; ++i) {
                            int n11 = nArray[i];
                            d8 += (double)n11 * (Math.log1p(-Math.exp(-d * (dArray[i] - dArray[i - 1]))) - d * dArray[i - 1]);
                            d8 += -d * dArray[i] - this.lfactorials[n11];
                        }
                        d8 += -d * (double)(nArray[n2] + 1) * dArray[n2 - 1] - this.lfactorials[nArray[n2] + 1];
                        d4 -= (d8 += Math.log(d) * (double)n2);
                        break;
                    }
                    assert (d2 < 1.0);
                    double d9 = d;
                    d6 = 1.0 - d2;
                    double d10 = d6 - d3;
                    double d11 = d6 * d6 / d9;
                    double d12 = 0.0;
                    for (int i = 0; i < nArray.length - 1; ++i) {
                        int n12 = nArray[i];
                        double d13 = -d9 * dArray[i];
                        double d14 = i > 0 ? -d9 * dArray[i - 1] : 0.0;
                        d12 -= this.lfactorials[n12];
                        double d15 = Math.log1p(-Math.exp(d13 - d14));
                        double d16 = d3 + d10 * Math.exp(d13);
                        double d17 = d3 + d10 * Math.exp(d14);
                        d12 += (double)n12 * (d14 + d15 + Math.log(d11 / (d16 * d17)));
                        double d18 = Math.log(d6 / (d3 + d10 * Math.exp(d13)));
                        d12 += 2.0 * d18 + d13;
                    }
                    double d19 = d6 / (d3 + d10 * Math.exp(-d9 * dArray[n2 - 1]));
                    int n13 = nArray[n2];
                    assert (n13 > 0);
                    double d20 = d3 / d6;
                    d12 += -this.lfactorials[n13 + 1] - (double)n13 * Math.log(d9 * d20) - (double)(n13 + 1) * d9 * dArray[n2 - 1] + (double)(n13 + 1) * Math.log(d19);
                    d4 -= (d12 += this.lfactorials[n] + (double)(n - 1) * Math.log(d9 * d20));
                    break;
                }
            }
        } else {
            double d21 = this.userPDF.getArrayValue();
            d4 = Double.isNaN(d21) || Double.isInfinite(d21) ? Double.NEGATIVE_INFINITY : (d4 -= d21);
        }
        return d4;
    }

    private static double logMarginalDensity(double d, int n, double d2, int n2, boolean bl) {
        double d3;
        double d4 = d * d2;
        if (bl) {
            d3 = -2.0 * d4 + Math.log(d);
            if (n2 > 1) {
                d3 += (double)(n2 - 1) * Math.log(1.0 - Math.exp(-d4));
            }
        } else {
            assert (n2 > 1);
            d3 = -3.0 * d4 + (double)(n2 - 2) * Math.log(1.0 - Math.exp(-d4)) + Math.log(d);
            if (n == n2) {
                d3 += d4;
            }
        }
        return d3;
    }

    private static double logMarginalDensity(double d, int n, double d2, int n2, double d3, int n3) {
        assert (d2 <= d3 && n2 < n3);
        int n4 = n3 - n2;
        double d4 = Math.exp(-d * d2);
        double d5 = Math.exp(-d * d3);
        double d6 = 2.0 * Math.log(d);
        d6 += (double)(n2 - 2) * Math.log(1.0 - d4);
        d6 += (double)(n4 - 3) * Math.log(1.0 - d5);
        d6 += Math.log(1.0 - (double)(2 * n4) * d5 + (double)(2 * (n4 - 1)) * d4 - (double)(n4 * (n4 - 1)) * d5 * d4 + (double)(n4 * (n4 + 1)) / 2.0 * d5 * d5 + (double)((n4 - 1) * (n4 - 2)) / 2.0 * d4 * d4);
        d6 = n3 < n ? (d6 -= d * (d2 + 3.0 * d3)) : (d6 -= d * (d2 + 2.0 * d3));
        return d6;
    }

    private double logMarginalDensity(double d, double[] dArray, int[] nArray, CalibrationLineagesIterator calibrationLineagesIterator) {
        int n;
        double d2;
        int[][] nArray2;
        int n2;
        int n3 = calibrationLineagesIterator.setup(nArray);
        int n4 = dArray.length;
        double[] dArray2 = new double[n4 + 1];
        dArray2[0] = 0.0;
        for (n2 = 1; n2 < dArray2.length; ++n2) {
            dArray2[n2] = -d * dArray[n2 - 1];
        }
        n2 = !calibrationLineagesIterator.isRootCalibrated() ? 1 : 0;
        int n5 = n4 + (n2 != 0 ? 1 : 0);
        double[] dArray3 = new double[n5];
        for (int i = 0; i < n4; ++i) {
            double d3 = dArray2[i + 1] - dArray2[i];
            dArray3[i] = d3 != 0.0 ? dArray2[i] + Math.log1p(-Math.exp(d3)) : -50.0;
        }
        if (n2 != 0) {
            dArray3[n4] = dArray2[n4];
        }
        int[] nArray3 = new int[n5];
        int[][] nArray4 = calibrationLineagesIterator.allJoiners();
        double d4 = 0.0;
        boolean bl = true;
        while ((nArray2 = calibrationLineagesIterator.next()) != null) {
            d2 = this.countRankedTrees(n5, nArray2, nArray4, nArray3);
            if (n2 != 0) {
                nArray3[n5 - 1] = n = nArray3[n5 - 1] + 2;
                d2 -= this.lc2[n] + this.lg2;
            }
            for (n = 0; n < n5; ++n) {
                d2 += (double)nArray3[n] * dArray3[n];
            }
            if (bl) {
                d4 = d2;
                bl = false;
                continue;
            }
            if (d4 > d2) {
                d4 += Math.log1p(Math.exp(d2 - d4));
                continue;
            }
            d4 = d2 + Math.log1p(Math.exp(d4 - d2));
        }
        d2 = 0.0;
        n = 0;
        for (int i = 0; i < n3; ++i) {
            int n6 = calibrationLineagesIterator.start(i);
            if (n6 <= 0) continue;
            d2 += this.lNR[n6];
            n += n6;
        }
        double d5 = this.lfactorials[n];
        double d6 = (double)n4 * Math.log(d);
        for (int i = 1; i < n4 + 1; ++i) {
            d6 += dArray2[i];
        }
        if (n2 == 0) {
            d6 += 1.0 * dArray2[n4];
        }
        return d4 += d2 + d5 + d6;
    }

    private double countTrees(int[] nArray, CalibrationLineagesIterator calibrationLineagesIterator) {
        int[][] nArray2;
        int n = calibrationLineagesIterator.setup(nArray);
        boolean bl = !calibrationLineagesIterator.isRootCalibrated();
        int[] nArray3 = new int[n];
        int[][] nArray4 = calibrationLineagesIterator.allJoiners();
        double d = 0.0;
        boolean bl2 = true;
        while ((nArray2 = calibrationLineagesIterator.next()) != null) {
            double d2 = this.countRankedTrees(n, nArray2, nArray4, nArray3);
            if (bl) {
                int n2 = nArray3[n - 1] + 2;
                d2 -= this.lc2[n2] + this.lg2;
            }
            if (bl2) {
                d = d2;
                bl2 = false;
                continue;
            }
            if (d > d2) {
                d += Math.log1p(Math.exp(d2 - d));
                continue;
            }
            d = d2 + Math.log1p(Math.exp(d - d2));
        }
        return d;
    }

    private double countRankedTrees(int n, int[][] nArray, int[][] nArray2, int[] nArray3) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            for (int j = i; j < n; ++j) {
                int[] nArray4 = nArray[j];
                int n3 = nArray4[i];
                if (nArray2[j][i] > 0 && ++n3 > 1) {
                    d += this.lc2[n3];
                }
                int n4 = n3 - nArray4[i + 1];
                d -= this.lfactorials[n4];
                n2 += n4;
            }
            nArray3[i] = n2;
        }
        return d;
    }

    private void setUpTables(int n) {
        int n2;
        double[] dArray = new double[n];
        this.lc2 = new double[n];
        this.lfactorials = new double[n];
        this.lNR = new double[n];
        dArray[0] = Double.NEGATIVE_INFINITY;
        dArray[1] = 0.0;
        for (n2 = 2; n2 < n; ++n2) {
            dArray[n2] = Math.log(n2);
        }
        this.lc2[1] = Double.NEGATIVE_INFINITY;
        this.lc2[0] = Double.NEGATIVE_INFINITY;
        for (n2 = 2; n2 < n; ++n2) {
            this.lc2[n2] = dArray[n2] + dArray[n2 - 1] - this.lg2;
        }
        this.lfactorials[0] = 0.0;
        for (n2 = 1; n2 < n; ++n2) {
            this.lfactorials[n2] = this.lfactorials[n2 - 1] + dArray[n2];
        }
        this.lNR[0] = Double.NEGATIVE_INFINITY;
        this.lNR[1] = 0.0;
        for (n2 = 2; n2 < n; ++n2) {
            this.lNR[n2] = this.lNR[n2 - 1] + this.lc2[n2];
        }
    }

    public static boolean isMaximal(List<TaxonSet> list, int n) {
        TaxonSet taxonSet = list.get(n);
        for (int i = 0; i < list.size(); ++i) {
            if (i == n || !list.get(i).containsAll(taxonSet)) continue;
            return false;
        }
        return true;
    }

    public static int getTaxonIndex(TreeInterface treeInterface, String string) {
        for (int i = 0; i < treeInterface.getNodeCount(); ++i) {
            Node node = treeInterface.getNode(i);
            if (!node.isLeaf() || !node.getID().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static Node getCommonAncestor(Node node, Node node2) {
        while (node != node2) {
            if (node.getHeight() < node2.getHeight()) {
                node = node.getParent();
                continue;
            }
            node2 = node2.getParent();
        }
        return node;
    }

    public static Node getCommonAncestor(TreeInterface treeInterface, int[] nArray) {
        Node node = treeInterface.getNode(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            node = CalibratedBirthDeathModel.getCommonAncestor(node, treeInterface.getNode(nArray[i]));
        }
        return node;
    }

    public static int getLeafCount(Node node) {
        if (node.isLeaf()) {
            return 1;
        }
        return CalibratedBirthDeathModel.getLeafCount(node.getLeft()) + CalibratedBirthDeathModel.getLeafCount(node.getRight());
    }

    @Override
    public void init(PrintStream printStream) {
        printStream.print(this.getID() + "\t");
        if (this.calcCalibrations) {
            for (CalibrationPoint calibrationPoint : this.orderedCalibrations) {
                printStream.print(calibrationPoint.getID() + "\t");
            }
        }
    }

    @Override
    public void log(int n, PrintStream printStream) {
        printStream.print(this.getCurrentLogP() + "\t");
        if (this.calcCalibrations) {
            TreeInterface treeInterface = (TreeInterface)this.treeInput.get();
            for (int i = 0; i < this.orderedCalibrations.length; ++i) {
                CalibrationPoint calibrationPoint = this.orderedCalibrations[i];
                int[] nArray = this.xclades[i];
                Node node = nArray.length > 1 ? CalibratedBirthDeathModel.getCommonAncestor(treeInterface, nArray) : treeInterface.getNode(nArray[0]);
                if (calibrationPoint.forParent()) {
                    node = node.getParent();
                }
                double d = node.getHeight();
                printStream.print(d + "\t");
            }
        }
    }

    @Override
    protected boolean requiresRecalculation() {
        if (super.requiresRecalculation() || this.birthRateInput.get().somethingIsDirty()) {
            return true;
        }
        if (!this.isYule) {
            RealParameter realParameter = this.deathToBirthRatioInput.get();
            if (realParameter != null && realParameter.somethingIsDirty()) {
                return true;
            }
            realParameter = this.sampleProbabilityInput.get();
            if (realParameter != null && realParameter.somethingIsDirty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canHandleTipDates() {
        return false;
    }

    static enum Type {
        NONE("none"),
        OVER_ALL_TOPOS("full"),
        OVER_RANKED_COUNTS("restricted");

        private final String ename;

        private Type(String string2) {
            this.ename = string2;
        }

        public String toString() {
            return this.ename;
        }
    }
}

