/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.evolution.operators.TreeOperator;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;

@Description(value="Randomly selects true internal tree node (i.e. not the root) and move node height uniformly in interval restricted by the nodes parent and children.")
public class Uniform
extends TreeOperator {
    public Uniform() {
    }

    public Uniform(Tree tree) {
        try {
            this.initByName(this.treeInput.getName(), tree);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Failed to construct Uniform Tree Operator.");
        }
    }

    @Override
    public void initAndValidate() {
    }

    @Override
    public double proposal() {
        int n;
        Node node;
        Tree tree = (Tree)this.treeInput.get(this);
        int n2 = tree.getNodeCount();
        if (tree.getInternalNodeCount() == 1) {
            return Double.NEGATIVE_INFINITY;
        }
        while ((node = tree.getNode(n = n2 / 2 + 1 + Randomizer.nextInt(n2 / 2))).isRoot() || node.isLeaf()) {
        }
        double d = node.getParent().getHeight();
        double d2 = Math.max(node.getLeft().getHeight(), node.getRight().getHeight());
        double d3 = Randomizer.nextDouble() * (d - d2) + d2;
        node.setHeight(d3);
        return 0.0;
    }
}

