/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.operators.TreeOperator;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Description(value="Scales tip dates on a tree by randomly selecting one from (a subset of) taxa")
public class TipDatesScaler
extends TreeOperator {
    public final Input<Double> scaleFactorInput = new Input<Double>("scaleFactor", "scaling factor: larger means more bold proposals", 1.0);
    public final Input<TaxonSet> taxonsetInput = new Input("taxonset", "limit scaling to a subset of taxa. By default all tips are scaled.");
    double scaleFactor;
    int[] taxonIndices;

    @Override
    public void initAndValidate() {
        this.scaleFactor = this.scaleFactorInput.get();
        if (this.taxonsetInput.get() != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object2 : ((Tree)this.treeInput.get()).getTaxaNames()) {
                arrayList.add(object2);
            }
            List<String> list = this.taxonsetInput.get().asStringList();
            int n = list.size();
            this.taxonIndices = new int[n];
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n3 = arrayList.indexOf(string);
                if (n3 < 0) {
                    throw new IllegalArgumentException("Cannot find taxon " + string + " in tree");
                }
                this.taxonIndices[n2++] = n3;
            }
        } else {
            this.taxonIndices = new int[((Tree)this.treeInput.get()).getTaxaNames().length];
            for (int i = 0; i < this.taxonIndices.length; ++i) {
                this.taxonIndices[i] = i;
            }
        }
    }

    @Override
    public double proposal() {
        Tree tree = (Tree)this.treeInput.get(this);
        int n = Randomizer.nextInt(this.taxonIndices.length);
        Node node = tree.getNode(this.taxonIndices[n]);
        double d = node.getParent().getHeight();
        double d2 = this.scaleFactor + Randomizer.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        double d3 = node.getHeight() * d2;
        if (d3 > d) {
            return Double.NEGATIVE_INFINITY;
        }
        node.setHeight(d3);
        return -Math.log(d2);
    }

    @Override
    public double getCoercableParameterValue() {
        return this.scaleFactor;
    }

    @Override
    public void setCoercableParameterValue(double d) {
        this.scaleFactor = d;
    }

    @Override
    public void optimize(double d) {
        double d2 = this.calcDelta(d);
        this.scaleFactor = 1.0 / (Math.exp(d2 += Math.log(1.0 / this.scaleFactor - 1.0)) + 1.0);
    }

    @Override
    public String getPerformanceSuggestion() {
        double d = (double)this.m_nNrAccepted / ((double)(this.m_nNrAccepted + this.m_nNrRejected) + 0.0);
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = d / d2;
        if (d3 > 2.0) {
            d3 = 2.0;
        }
        if (d3 < 0.5) {
            d3 = 0.5;
        }
        double d4 = Math.pow(this.scaleFactor, d3);
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (d < 0.1) {
            return "Try setting scaleFactor to about " + decimalFormat.format(d4);
        }
        if (d > 0.4) {
            return "Try setting scaleFactor to about " + decimalFormat.format(d4);
        }
        return "";
    }
}

