/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.operators.TreeOperator;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Description(value="Randomly moves tip dates on a tree by randomly selecting one from (a subset of) taxa")
public class TipDatesRandomWalker
extends TreeOperator {
    public final Input<Double> windowSizeInput = new Input("windowSize", "the size of the window both up and down when using uniform interval OR standard deviation when using Gaussian", Input.Validate.REQUIRED);
    public final Input<TaxonSet> m_taxonsetInput = new Input("taxonset", "limit scaling to a subset of taxa. By default all tips are scaled.");
    public final Input<Boolean> useGaussianInput = new Input<Boolean>("useGaussian", "Use Gaussian to move instead of uniform interval. Default false.", false);
    int[] taxonIndices;
    double windowSize = 1.0;
    boolean useGaussian;
    boolean reflectValue = true;

    @Override
    public void initAndValidate() {
        this.windowSize = this.windowSizeInput.get();
        this.useGaussian = this.useGaussianInput.get();
        if (this.m_taxonsetInput.get() != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object2 : ((Tree)this.treeInput.get()).getTaxaNames()) {
                arrayList.add(object2);
            }
            List<String> list = this.m_taxonsetInput.get().asStringList();
            int n = list.size();
            this.taxonIndices = new int[n];
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n3 = arrayList.indexOf(string);
                if (n3 < 0) {
                    throw new IllegalArgumentException("Cannot find taxon " + string + " in tree");
                }
                this.taxonIndices[n2++] = n3;
            }
        } else {
            this.taxonIndices = new int[((Tree)this.treeInput.get()).getTaxaNames().length];
            for (int i = 0; i < this.taxonIndices.length; ++i) {
                this.taxonIndices[i] = i;
            }
        }
    }

    @Override
    public double proposal() {
        double d;
        int n = Randomizer.nextInt(this.taxonIndices.length);
        Node node = ((Tree)this.treeInput.get()).getNode(this.taxonIndices[n]);
        double d2 = d = node.getHeight();
        d2 = this.useGaussian ? (d2 += Randomizer.nextGaussian() * this.windowSize) : (d2 += Randomizer.nextDouble() * 2.0 * this.windowSize - this.windowSize);
        if (d2 > node.getParent().getHeight()) {
            if (this.reflectValue) {
                d2 = this.reflectValue(d2, 0.0, node.getParent().getHeight());
            } else {
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (d2 == d) {
            return Double.NEGATIVE_INFINITY;
        }
        node.setHeight(d2);
        return 0.0;
    }

    public double reflectValue(double d, double d2, double d3) {
        double d4 = d;
        if (d < d2) {
            if (Double.isInfinite(d3)) {
                d4 = d2 + (d2 - d);
            } else {
                double d5 = d2 - d;
                int n = (int)Math.floor(d5 / (d3 - d2));
                d4 = n % 2 == 0 ? d2 + d5 : d3 - (d5 -= (d3 - d2) * (double)n);
            }
        } else if (d > d3) {
            if (Double.isInfinite(d2)) {
                d4 = d3 - (d4 - d3);
            } else {
                double d6 = d - d3;
                int n = (int)Math.floor(d6 / (d3 - d2));
                d4 = n % 2 == 0 ? d3 - d6 : d2 + (d6 -= (d3 - d2) * (double)n);
            }
        }
        return d4;
    }

    @Override
    public double getCoercableParameterValue() {
        return this.windowSize;
    }

    @Override
    public void setCoercableParameterValue(double d) {
        this.windowSize = d;
    }

    @Override
    public void optimize(double d) {
        double d2 = this.calcDelta(d);
        this.windowSize = Math.exp(d2 += Math.log(this.windowSize));
    }

    @Override
    public final String getPerformanceSuggestion() {
        double d = (double)this.m_nNrAccepted / ((double)(this.m_nNrAccepted + this.m_nNrRejected) + 0.0);
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = d / d2;
        if (d3 > 2.0) {
            d3 = 2.0;
        }
        if (d3 < 0.5) {
            d3 = 0.5;
        }
        double d4 = this.windowSize * d3;
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (d < 0.1) {
            return "Try setting window size to about " + decimalFormat.format(d4);
        }
        if (d > 0.4) {
            return "Try setting window size to about " + decimalFormat.format(d4);
        }
        return "";
    }
}

