/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.alignment.distance;

import beast.core.Description;
import beast.evolution.alignment.distance.Distance;

@Description(value="Hamming distance is the mean number of characters that differ between sequences. Note that unknowns are not ignored, so if both are unknowns '?' the distance is zero.")
public class HammingDistance
extends Distance.Base {
    @Override
    public double pairwiseDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.patterns.getPatternCount(); ++i) {
            if (this.patterns.getPattern(n, i) == this.patterns.getPattern(n2, i)) continue;
            d += (double)this.patterns.getPatternWeight(i);
        }
        return d / (double)this.patterns.getSiteCount();
    }
}

