/*
 * Decompiled with CFR 0.152.
 */
package beast.core;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.Operator;
import beast.core.State;
import java.io.PrintStream;
import org.w3c.dom.Node;

@Description(value="A node that can be part of the state.")
public abstract class StateNode
extends CalculationNode
implements Loggable,
Cloneable,
Function {
    public final Input<Boolean> isEstimatedInput = new Input<Boolean>("estimate", "whether to estimate this item or keep constant to its initial value", true);
    protected State state = null;
    protected boolean hasStartedEditing = false;
    public int index = -1;

    public StateNode getCurrent() {
        if (this.state == null) {
            return this;
        }
        return this.state.getStateNode(this.index);
    }

    public StateNode getCurrentEditable(Operator operator) {
        this.startEditing(operator);
        return this;
    }

    public boolean somethingIsDirty() {
        return this.hasStartedEditing;
    }

    public void setSomethingIsDirty(boolean bl) {
        this.hasStartedEditing = bl;
    }

    public abstract void setEverythingDirty(boolean var1);

    public abstract StateNode copy();

    public abstract void assignTo(StateNode var1);

    public abstract void assignFrom(StateNode var1);

    public void assignFromWithoutID(StateNode stateNode) {
        String string = this.getID();
        this.assignFrom(stateNode);
        this.setID(string);
    }

    public abstract void assignFromFragile(StateNode var1);

    public final void toXML(PrintStream printStream) {
        printStream.print("<statenode id='" + this.normalise(this.getID()) + "'>");
        printStream.print(this.normalise(this.toString()));
        printStream.print("</statenode>\n");
    }

    public final String toXML() {
        return "<statenode id='" + this.normalise(this.getID()) + "'>" + this.normalise(this.toString()) + "</statenode>\n";
    }

    private String normalise(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("'", "&apos;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    public abstract void fromXML(Node var1);

    public abstract int scale(double var1);

    public State getState() {
        return this.state;
    }

    public int getIndex() {
        return this.index;
    }

    public void startEditing(Operator operator) {
        assert (this.isCalledFromOperator(4));
        if (this.hasStartedEditing) {
            return;
        }
        this.hasStartedEditing = true;
        this.state.getEditableStateNode(this.index, operator);
        this.store();
    }

    private boolean isCalledFromOperator(int n) {
        return true;
    }

    @Override
    protected abstract void store();

    @Override
    public abstract void restore();
}

