/*
 * Decompiled with CFR 0.152.
 */
package beast.core;

import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.OperatorSchedule;
import beast.core.StateNode;
import beast.core.util.Evaluator;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

@Description(value="Proposes a move in state space.")
public abstract class Operator
extends BEASTObject {
    public final Input<Double> m_pWeight = new Input("weight", "weight with which this operator is selected", Input.Validate.REQUIRED);
    private final String STANDARD_OPERATOR_PACKAGE = "beast.evolution.operators";
    OperatorSchedule operatorSchedule;
    protected int m_nNrRejected = 0;
    protected int m_nNrAccepted = 0;
    protected int m_nNrRejectedForCorrection = 0;
    protected int m_nNrAcceptedForCorrection = 0;
    private final boolean detailedRejection = false;
    protected int m_nNrRejectedInvalid = 0;
    protected int m_nNrRejectedOperator = 0;

    public void setOperatorSchedule(OperatorSchedule operatorSchedule) {
        this.operatorSchedule = operatorSchedule;
    }

    public Distribution getEvaluatorDistribution() {
        return null;
    }

    public double proposal(Evaluator evaluator) {
        return this.proposal();
    }

    public abstract double proposal();

    public double getWeight() {
        return this.m_pWeight.get();
    }

    public String getName() {
        String string = this.getClass().getName();
        if (string.startsWith("beast.evolution.operators")) {
            string = string.substring("beast.evolution.operators".length() + 1);
        }
        return string + "(" + (this.getID() != null ? this.getID() : "") + ")";
    }

    public void accept() {
        ++this.m_nNrAccepted;
        if (this.operatorSchedule.autoOptimizeDelayCount >= this.operatorSchedule.autoOptimizeDelay) {
            ++this.m_nNrAcceptedForCorrection;
        }
    }

    public void reject() {
        this.reject(0);
    }

    public void reject(int n) {
        ++this.m_nNrRejected;
        if (n < 0) {
            ++this.m_nNrRejectedInvalid;
            if (n == -2) {
                ++this.m_nNrRejectedOperator;
            }
        }
        if (this.operatorSchedule.autoOptimizeDelayCount >= this.operatorSchedule.autoOptimizeDelay) {
            ++this.m_nNrRejectedForCorrection;
        }
    }

    public void optimize(double d) {
    }

    protected double calcDelta(double d) {
        return this.operatorSchedule.calcDelta(this, d);
    }

    public double getTargetAcceptanceProbability() {
        return 0.234;
    }

    public double getCoercableParameterValue() {
        return Double.NaN;
    }

    public void setCoercableParameterValue(double d) {
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    public List<StateNode> listStateNodes() {
        ArrayList<StateNode> arrayList = new ArrayList<StateNode>();
        for (BEASTInterface bEASTInterface : this.listActiveBEASTObjects()) {
            if (!(bEASTInterface instanceof StateNode)) continue;
            StateNode stateNode = (StateNode)bEASTInterface;
            if (!stateNode.isEstimatedInput.get().booleanValue()) continue;
            arrayList.add(stateNode);
        }
        return arrayList;
    }

    @Override
    public String toString() {
        return OperatorSchedule.prettyPrintOperator(this, 70, 10, 4, 0.0, false);
    }

    public void storeToFile(PrintWriter printWriter) {
        try {
            JSONStringer jSONStringer = new JSONStringer();
            jSONStringer.object();
            if (this.getID() == null) {
                this.setID("unknown");
            }
            jSONStringer.key("id").value(this.getID());
            double d = this.getCoercableParameterValue();
            if (Double.isNaN(d)) {
                jSONStringer.key("p").value("NaN");
            } else if (Double.isInfinite(d)) {
                if (d > 0.0) {
                    jSONStringer.key("p").value("Infinity");
                } else {
                    jSONStringer.key("p").value("-Infinity");
                }
            } else {
                jSONStringer.key("p").value(d);
            }
            jSONStringer.key("accept").value(this.m_nNrAccepted);
            jSONStringer.key("reject").value(this.m_nNrRejected);
            jSONStringer.key("acceptFC").value(this.m_nNrAcceptedForCorrection);
            jSONStringer.key("rejectFC").value(this.m_nNrRejectedForCorrection);
            jSONStringer.key("rejectIv").value(this.m_nNrRejectedInvalid);
            jSONStringer.key("rejectOp").value(this.m_nNrRejectedOperator);
            jSONStringer.endObject();
            printWriter.print(jSONStringer.toString());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void restoreFromFile(JSONObject jSONObject) {
        try {
            if (!Double.isNaN(jSONObject.getDouble("p"))) {
                this.setCoercableParameterValue(jSONObject.getDouble("p"));
            }
            this.m_nNrAccepted = jSONObject.getInt("accept");
            this.m_nNrRejected = jSONObject.getInt("reject");
            this.m_nNrAcceptedForCorrection = jSONObject.getInt("acceptFC");
            this.m_nNrRejectedForCorrection = jSONObject.getInt("rejectFC");
            this.m_nNrRejectedInvalid = jSONObject.has("rejectIv") ? jSONObject.getInt("rejectIv") : 0;
            this.m_nNrRejectedOperator = jSONObject.has("rejectOp") ? jSONObject.getInt("rejectOp") : 0;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public boolean requiresStateInitialisation() {
        return true;
    }
}

