/*
 * Decompiled with CFR 0.152.
 */
package beast.core;

import beast.core.BEASTInterface;
import beast.core.CalculationNode;
import beast.core.Function;
import beast.core.Operator;
import beast.core.StateNode;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public class Input<T> {
    String name = "";
    String tipText = "";
    T value;
    protected Class<?> theClass;
    Validate rule = Validate.OPTIONAL;
    Input<?> other;
    public T defaultValue;
    public T[] possibleValues;

    public Input() {
    }

    public Input(String string, String string2) {
        this.name = string;
        this.tipText = string2;
        this.value = null;
        this.checkName();
    }

    public Input(String string, String string2, Class<?> clazz) {
        this(string, string2);
        this.theClass = clazz;
    }

    public Input(String string, String string2, T t) {
        this(string, string2);
        this.value = t;
        this.defaultValue = t;
    }

    public Input(String string, String string2, T t, Class<?> clazz) {
        this(string, string2, t);
        this.theClass = clazz;
    }

    public Input(String string, String string2, T t, Validate validate, Input<?> input) {
        this(string, string2, t);
        if (validate != Validate.XOR) {
            Log.err.println("Programmer error: input rule should be XOR for this Input constructor");
        }
        this.rule = validate;
        this.other = input;
        this.other.other = this;
        this.other.rule = validate;
    }

    public Input(String string, String string2, T t, Validate validate, Input<?> input, Class<?> clazz) {
        this(string, string2, t, validate, input);
        this.theClass = clazz;
    }

    public Input(String string, String string2, T t, Validate validate) {
        this(string, string2, t);
        this.rule = validate;
    }

    public Input(String string, String string2, T t, Validate validate, Class<?> clazz) {
        this(string, string2, t, validate);
        this.theClass = clazz;
    }

    public Input(String string, String string2, Validate validate) {
        this(string, string2);
        if (validate != Validate.REQUIRED) {
            Log.err.println("Programmer error: input rule should be REQUIRED for this Input constructor (" + string + ")");
        }
        this.rule = validate;
    }

    public Input(String string, String string2, Validate validate, Class<?> clazz) {
        this(string, string2, validate);
        this.theClass = clazz;
    }

    public Input(String string, String string2, Validate validate, Input<?> input) {
        this(string, string2);
        if (validate != Validate.XOR) {
            Log.err.println("Programmer error: input rule should be XOR for this Input constructor");
        }
        this.rule = validate;
        this.other = input;
        this.other.other = this;
        this.other.rule = validate;
    }

    public Input(String string, String string2, Validate validate, Input<?> input, Class<?> clazz) {
        this(string, string2, validate, input);
        this.theClass = clazz;
    }

    public Input(String string, String string2, T t, T[] TArray) {
        this.name = string;
        this.tipText = string2;
        this.value = t;
        this.defaultValue = t;
        this.possibleValues = TArray;
        this.checkName();
    }

    private void checkName() {
        if (this.name.toLowerCase().equals("id") || this.name.toLowerCase().equals("idref") || this.name.toLowerCase().equals("spec") || this.name.toLowerCase().equals("name")) {
            Log.err.println("Found an input with invalid name: " + this.name);
            Log.err.println("'id', 'idref', 'spec' and 'name' are reserved and cannot be used");
            System.exit(1);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getTipText() {
        return this.tipText;
    }

    public String getHTMLTipText() {
        return "<html>" + this.tipText.replaceAll("\n", "<br>") + "</html>";
    }

    public String getValueTipText() {
        if (this.theClass == Boolean.class) {
            return "[true|false]";
        }
        if (this.theClass == Integer.class) {
            return "<integer>";
        }
        if (this.theClass == Long.class) {
            return "<long>";
        }
        if (this.theClass == Double.class) {
            return "<double>";
        }
        if (this.theClass == Float.class) {
            return "<float>";
        }
        if (this.theClass == String.class) {
            return "<string>";
        }
        if (this.theClass == File.class) {
            return "<filename>";
        }
        if (this.theClass.isEnum()) {
            return Arrays.toString(this.possibleValues).replaceAll(",", "|");
        }
        return "";
    }

    public Class<?> getType() {
        return this.theClass;
    }

    public void setType(Class<?> clazz) {
        this.theClass = clazz;
    }

    public Validate getRule() {
        return this.rule;
    }

    public void setRule(Validate validate) {
        this.rule = validate;
    }

    public final Input<?> getOther() {
        return this.other;
    }

    public T get() {
        return this.value;
    }

    public T get(Operator operator) {
        return (T)((StateNode)this.value).getCurrentEditable(operator);
    }

    public boolean isDirty() {
        T t = this.get();
        if (t == null) {
            return false;
        }
        if (t instanceof StateNode) {
            return ((StateNode)t).somethingIsDirty();
        }
        if (t instanceof CalculationNode) {
            return ((CalculationNode)t).isDirtyCalculation();
        }
        if (t instanceof List) {
            for (Object e : (List)t) {
                if (e instanceof CalculationNode && ((CalculationNode)e).isDirtyCalculation()) {
                    return true;
                }
                if (!(e instanceof StateNode) || !((StateNode)e).somethingIsDirty()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object object, BEASTInterface bEASTInterface) {
        if (object == null) {
            if (this.value != null && this.value instanceof BEASTInterface) {
                ((BEASTInterface)this.value).getOutputs().remove(bEASTInterface);
            }
            this.value = null;
            return;
        }
        if (this.theClass == null) {
            try {
                this.determineClass(bEASTInterface);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Failed to determine class of beastobject id=" + bEASTInterface.getID());
            }
        }
        if (object instanceof String) {
            try {
                this.setStringValue((String)object, bEASTInterface);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.warning.println("Failed to set the string value to '" + object + "' for beastobject id=" + bEASTInterface.getID());
                throw new RuntimeException("Failed to set the string value to '" + object + "' for beastobject id=" + bEASTInterface.getID());
            }
        } else if (this.value != null && this.value instanceof List) {
            if (this.theClass.isAssignableFrom(object.getClass())) {
                List list = (List)this.value;
                list.add(object);
                if (!(object instanceof BEASTInterface)) return;
                ((BEASTInterface)object).getOutputs().add(bEASTInterface);
                return;
            } else {
                if (!(object instanceof List) || !this.theClass.isAssignableFrom(((List)object).get(0).getClass())) throw new RuntimeException("Input 101: type mismatch for input " + this.getName() + ". " + this.theClass.getName() + ".isAssignableFrom(" + object.getClass() + ")=false");
                List list = (List)this.value;
                for (Object e : (List)object) {
                    list.add(e);
                    if (!(e instanceof BEASTInterface)) continue;
                    ((BEASTInterface)e).getOutputs().add(bEASTInterface);
                }
            }
            return;
        } else {
            if (!this.theClass.isAssignableFrom(object.getClass())) throw new RuntimeException("Input 102: type mismatch for input " + this.getName());
            if (object instanceof BEASTInterface) {
                if (this.value != null) {
                    ((BEASTInterface)this.value).getOutputs().remove(bEASTInterface);
                }
                ((BEASTInterface)object).getOutputs().add(bEASTInterface);
            }
            this.value = object;
        }
    }

    public void set(Object object) {
        if (this.theClass == null) {
            throw new IllegalArgumentException("Progmmer error: setValue should not be called unless that datatype of the input is determined (e.g. through a call to setValue(value, beastObject))");
        }
        this.setValue(object, null);
    }

    public boolean canSetValue(Object object, BEASTInterface bEASTInterface) {
        String string = new String(this.name.charAt(0) + "").toUpperCase() + this.name.substring(1);
        try {
            Method method = bEASTInterface.getClass().getMethod("canSet" + string, Object.class);
            Object object2 = method.invoke((Object)bEASTInterface, object);
            return (Boolean)object2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.warning.println(bEASTInterface.getClass().getName() + "." + this.getName() + ": " + invocationTargetException.getCause());
            if (invocationTargetException.getCause() != null) {
                throw new RuntimeException(invocationTargetException.getCause().getMessage());
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new RuntimeException("Illegal method access attempted on beastobject id=" + bEASTInterface.getID());
        }
    }

    public void determineClass(Object object) {
        try {
            Field[] fieldArray = object.getClass().getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Input input;
                if (!fieldArray[i].getType().isAssignableFrom(Input.class) || (input = (Input)fieldArray[i].get(object)) != this) continue;
                Type type2 = fieldArray[i].getGenericType();
                Type[] typeArray = ((ParameterizedType)type2).getActualTypeArguments();
                if (this.value != null && this.value instanceof List) {
                    Type[] typeArray2 = ((ParameterizedType)typeArray[0]).getActualTypeArguments();
                    try {
                        this.theClass = (Class)typeArray2[0];
                    }
                    catch (ClassCastException classCastException) {
                        this.theClass = (Class)((ParameterizedType)typeArray2[0]).getRawType();
                    }
                } else {
                    try {
                        Type type3;
                        Type type4 = typeArray[0];
                        if (type4 instanceof ParameterizedType && (type3 = ((ParameterizedType)typeArray[0]).getRawType()).getTypeName().equals("java.util.List")) {
                            throw new RuntimeException("Programming error: Input<List> not initialised");
                        }
                        this.theClass = (Class)type4;
                    }
                    catch (Exception exception) {
                        String string = "";
                        Method method = object.getClass().getMethod("getID", new Class[0]);
                        if (method != null) {
                            string = (String)method.invoke(object, new Object[0]);
                        }
                        Log.err.println(object.getClass().getName() + " " + string + " failed. " + "Possibly template or abstract BEASTObject used " + "or if it is a list, the list was not initilised???");
                        Log.err.println("class is " + object.getClass());
                        exception.printStackTrace(System.err);
                        System.exit(1);
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setStringValue(String string, BEASTInterface bEASTInterface) {
        if (this.value instanceof List) {
            List list = (List)this.value;
            list.clear();
            String string2 = string.replaceAll("^\\s+", "");
            string2 = string2.replaceAll("\\s+$", "");
            String[] stringArray = string2.split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.theClass.equals(Integer.class)) {
                    list.add(new Integer(stringArray[i % stringArray.length]));
                    continue;
                }
                if (this.theClass.equals(Double.class)) {
                    list.add(new Double(stringArray[i % stringArray.length]));
                    continue;
                }
                if (this.theClass.equals(Boolean.class)) {
                    String string3 = stringArray[i % stringArray.length].toLowerCase();
                    list.add(string3.equals("1") || string3.equals("true") || string3.equals("yes"));
                    continue;
                }
                if (!this.theClass.equals(String.class)) continue;
                list.add(new String(stringArray[i % stringArray.length]));
            }
            return;
        }
        if (this.theClass.equals(Integer.class)) {
            this.value = new Integer(string);
            return;
        }
        if (this.theClass.equals(Long.class)) {
            this.value = new Long(string);
            return;
        }
        if (this.theClass.equals(Double.class)) {
            this.value = new Double(string);
            return;
        }
        if (this.theClass.equals(Float.class)) {
            this.value = new Float(string);
            return;
        }
        if (this.theClass.equals(Boolean.class)) {
            this.value = new Boolean(string);
            return;
        }
        if (this.theClass.equals(Function.class)) {
            RealParameter realParameter = new RealParameter();
            realParameter.initByName("value", string, "upper", 0.0, "lower", 0.0, "dimension", 1);
            realParameter.initAndValidate();
            if (this.value != null && this.value instanceof List) {
                ((List)this.value).add(realParameter);
            } else {
                this.value = realParameter;
            }
            realParameter.getOutputs().add(bEASTInterface);
            return;
        }
        if (this.theClass.isEnum()) {
            if (this.possibleValues == null) {
                this.possibleValues = this.theClass.getDeclaringClass().getEnumConstants();
            }
            for (T t : this.possibleValues) {
                if (!string.equals(t.toString())) continue;
                this.value = t;
                return;
            }
            throw new IllegalArgumentException("Input 104: value " + string + " not found. Select one of " + Arrays.toString(this.possibleValues));
        }
        try {
            Constructor<?> constructor;
            Object object = string;
            try {
                constructor = this.theClass.getDeclaredConstructor(String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    object = string.startsWith("0x") ? Integer.valueOf(Integer.parseInt(string.substring(2), 16)) : Integer.valueOf(Integer.parseInt(string));
                    constructor = this.theClass.getDeclaredConstructor(Integer.TYPE);
                }
                catch (NumberFormatException numberFormatException) {
                    object = Double.parseDouble(string);
                    constructor = this.theClass.getDeclaredConstructor(Double.TYPE);
                }
            }
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(object);
            if (this.value != null && this.value instanceof List) {
                ((List)this.value).add(obj);
            } else {
                this.value = obj;
            }
            if (obj instanceof BEASTInterface) {
                ((BEASTInterface)obj).getOutputs().add(bEASTInterface);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Input 103: type mismatch, cannot initialize input '" + this.getName() + "' with value '" + string + "'.\nExpected something of type " + this.getType().getName() + ". " + (exception.getMessage() != null ? exception.getMessage() : ""));
        }
    }

    public void validate() {
        if (this.possibleValues != null) {
            boolean bl = false;
            for (T t : this.possibleValues) {
                if (!t.equals(this.value)) continue;
                bl = true;
            }
            if (!bl) {
                throw new IllegalArgumentException("Expected one of " + Arrays.toString(this.possibleValues) + " but got " + this.value);
            }
        }
        switch (this.rule) {
            case OPTIONAL: {
                break;
            }
            case REQUIRED: {
                if (this.get() == null) {
                    throw new IllegalArgumentException("Input '" + this.getName() + "' must be specified.");
                }
                if (!(this.get() instanceof List) || ((List)this.get()).size() != 0) break;
                throw new IllegalArgumentException("At least one input of name '" + this.getName() + "' must be specified.");
            }
            case XOR: {
                if (this.get() == null) {
                    if (this.other.get() != null) break;
                    throw new IllegalArgumentException("Either input '" + this.getName() + "' or '" + this.other.getName() + "' needs to be specified");
                }
                if (this.other.get() == null) break;
                throw new IllegalArgumentException("Only one of input '" + this.getName() + "' and '" + this.other.getName() + "' must be specified (not both)");
            }
            case FORBIDDEN: {
                if (this.get() instanceof List) {
                    if (((List)this.get()).size() <= 0) break;
                    throw new IllegalArgumentException("No input of name '" + this.getName() + "' must be specified.");
                }
                if (this.get() == null) break;
                throw new IllegalArgumentException("Input '" + this.getName() + "' must not be specified.");
            }
        }
    }

    public String toString() {
        return String.format("Input(\"%s\")", this.name);
    }

    public static enum Validate {
        OPTIONAL,
        REQUIRED,
        XOR,
        FORBIDDEN;

    }
}

