/*
 * Decompiled with CFR 0.152.
 */
package beast.app.util;

import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField
implements FocusListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    protected static char MINUS_CHAR = (char)45;
    protected EventListenerList changeListeners = new EventListenerList();
    protected long min;
    protected long max;
    protected boolean range_check = false;
    protected boolean range_checked = false;
    static char[] numberSet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public WholeNumberField() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public WholeNumberField(int n, int n2) {
        this.min = n;
        this.max = n2;
        this.range_check = true;
        this.addFocusListener(this);
    }

    public WholeNumberField(long l, long l2) {
        this.min = l;
        this.max = l2;
        this.range_check = true;
        this.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.range_check && !this.range_checked) {
            this.range_checked = true;
            try {
                long l = Long.valueOf(this.getText());
                if (l < this.min || l > this.max) {
                    this.errorMsg();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.errorMsg();
            }
        }
    }

    public void setText(Integer n) {
        this.setText(n.toString());
    }

    protected void errorMsg() {
        JOptionPane.showMessageDialog(this, "Illegal entry\nValue must be between " + this.min + " and " + this.max + " inclusive", "Error", 0);
    }

    public void setValue(int n) {
        if (this.range_check && ((long)n < this.min || (long)n > this.max)) {
            this.errorMsg();
            return;
        }
        this.setText(Integer.toString(n));
    }

    public void setValue(long l) {
        if (this.range_check && (l < this.min || l > this.max)) {
            this.errorMsg();
            return;
        }
        this.setText(Long.toString(l));
    }

    public Integer getValue() {
        try {
            return new Integer(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Long getLongValue() {
        try {
            return new Long(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Integer getValue(int n) {
        Integer n2 = this.getValue();
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    public Long getValue(long l) {
        Long l2 = this.getLongValue();
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    @Override
    protected Document createDefaultModel() {
        WholeNumberFieldDocument wholeNumberFieldDocument = new WholeNumberFieldDocument();
        wholeNumberFieldDocument.addDocumentListener(this);
        return wholeNumberFieldDocument;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.range_checked = false;
        this.fireChanged();
    }

    static boolean member(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(ChangeListener.class, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    class WholeNumberFieldDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        WholeNumberFieldDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            string = string.trim();
            String string2 = this.getText(0, n) + string;
            char[] cArray = string2.toCharArray();
            if (cArray.length > 0 && cArray[0] != MINUS_CHAR && !WholeNumberField.member(cArray[0], numberSet)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            for (int i = 1; i < cArray.length; ++i) {
                if (WholeNumberField.member(cArray[i], numberSet)) continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

