/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.beauti.BeautiConfig;
import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiSubTemplate;
import beast.app.draw.BEASTObjectInputEditor;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.EnumInputEditor;
import beast.app.draw.InputEditor;
import beast.app.draw.ListInputEditor;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.util.Log;
import beast.util.AddOnManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class InputEditorFactory {
    HashMap<Class<?>, String> inputEditorMap;
    HashMap<Class<?>, String> listInputEditorMap;
    BeautiDoc doc;

    public InputEditorFactory(BeautiDoc beautiDoc) {
        this.doc = beautiDoc;
        this.init();
    }

    public void init() {
        String[] stringArray;
        this.inputEditorMap = new HashMap();
        this.listInputEditorMap = new HashMap();
        for (String string : stringArray = new String[]{"beast.app"}) {
            List<String> list = AddOnManager.find("beast.app.draw.InputEditor", string);
            this.registerInputEditors(list.toArray(new String[0]));
        }
    }

    private void registerInputEditors(String[] stringArray) {
        for (String string : stringArray) {
            if (string.contains("$")) continue;
            try {
                Class<?>[] classArray;
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(BeautiDoc.class);
                InputEditor inputEditor = (InputEditor)constructor.newInstance(this.doc);
                for (Class<?> clazz2 : classArray = inputEditor.types()) {
                    this.inputEditorMap.put(clazz2, string);
                    if (!(inputEditor instanceof ListInputEditor)) continue;
                    Class<?> clazz3 = ((ListInputEditor)inputEditor).baseType();
                    this.listInputEditorMap.put(clazz3, string);
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (Exception exception) {
                Log.err.println(exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
    }

    public List<InputEditor> addInputs(Box box, BEASTInterface bEASTInterface, InputEditor inputEditor, InputEditor inputEditor2, BeautiDoc beautiDoc) {
        List<Input<?>> list = null;
        ArrayList<InputEditor> arrayList = new ArrayList<InputEditor>();
        try {
            list = bEASTInterface.listInputs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Input<?> input : list) {
            try {
                String string = bEASTInterface.getClass().getName() + "." + input.getName();
                if (beautiDoc.beautiConfig.suppressBEASTObjects.contains(string)) continue;
                InputEditor inputEditor3 = this.createInputEditor(input, bEASTInterface, true, InputEditor.ExpandOption.FALSE, InputEditor.ButtonStatus.ALL, inputEditor, beautiDoc);
                box.add(inputEditor3.getComponent());
                box.add(Box.createVerticalStrut(5));
                if (inputEditor2 != null) {
                    inputEditor3.addValidationListener(inputEditor2);
                }
                arrayList.add(inputEditor3);
            }
            catch (Exception exception) {
                Log.err.println(exception.getClass().getName() + ": " + exception.getMessage() + "\n" + "input " + input.getName() + " could not be added.");
                exception.printStackTrace();
                JOptionPane.showMessageDialog(null, "Could not add entry for " + input.getName());
            }
        }
        box.add(Box.createVerticalGlue());
        return arrayList;
    }

    public InputEditor createInputEditor(Input<?> input, BEASTInterface bEASTInterface, BeautiDoc beautiDoc) throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.createInputEditor(input, bEASTInterface, true, InputEditor.ExpandOption.FALSE, InputEditor.ButtonStatus.ALL, null, beautiDoc);
    }

    public InputEditor createInputEditor(Input<?> input, BEASTInterface bEASTInterface, boolean bl, InputEditor.ExpandOption expandOption, InputEditor.ButtonStatus buttonStatus, InputEditor inputEditor, BeautiDoc beautiDoc) throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.createInputEditor(input, -1, bEASTInterface, bl, expandOption, buttonStatus, inputEditor, beautiDoc);
    }

    public InputEditor createInputEditor(Input<?> input, int n, BEASTInterface bEASTInterface, boolean bl, InputEditor.ExpandOption expandOption, InputEditor.ButtonStatus buttonStatus, InputEditor inputEditor, BeautiDoc beautiDoc) throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?> constructor;
        InputEditor inputEditor2;
        Object object;
        Object object2;
        Class<?> clazz;
        if (input.getType() == null) {
            input.determineClass(bEASTInterface);
        }
        if ((clazz = input.getType()) == null) {
            return null;
        }
        if (n >= 0) {
            clazz = ((List)input.get()).get(n).getClass();
        } else if (input.get() != null && !input.get().getClass().equals(clazz) && !(input.get() instanceof ArrayList)) {
            Log.trace.println(input.get().getClass() + " != " + clazz);
            clazz = input.get().getClass();
        }
        if (inputEditor != null) {
            try {
                String string = input.getName();
                string = new String(string.charAt(0) + "").toUpperCase() + string.substring(1);
                string = "create" + string + "Editor";
                Class<?> clazz2 = inputEditor.getClass();
                Method method = clazz2.getMethod(string, new Class[0]);
                InputEditor inputEditor3 = (InputEditor)method.invoke((Object)inputEditor, new Object[0]);
                return inputEditor3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < 0 && (List.class.isAssignableFrom(clazz) || input.get() != null && input.get() instanceof List)) {
            if (this.listInputEditorMap.containsKey(clazz)) {
                object2 = this.listInputEditorMap.get(clazz);
                object = Class.forName(object2).getConstructor(BeautiDoc.class);
                inputEditor2 = (InputEditor)((Constructor)object).newInstance(beautiDoc);
            } else {
                inputEditor2 = new ListInputEditor(beautiDoc);
            }
            ((ListInputEditor)inputEditor2).setButtonStatus(buttonStatus);
        } else if (input.possibleValues != null) {
            inputEditor2 = new EnumInputEditor(beautiDoc);
        } else {
            for (object2 = clazz; object2 != null && !this.inputEditorMap.containsKey(object2); object2 = ((Class)object2).getSuperclass()) {
            }
            if (object2 == null) {
                inputEditor2 = new BEASTObjectInputEditor(beautiDoc);
            } else {
                object = this.inputEditorMap.get(object2);
                constructor = Class.forName((String)object).getConstructor(BeautiDoc.class);
                inputEditor2 = (InputEditor)constructor.newInstance(beautiDoc);
            }
        }
        object2 = bEASTInterface.getClass().getName() + "." + input.getName();
        object = expandOption;
        if (beautiDoc.beautiConfig.inlineBEASTObject.contains(object2) || expandOption == InputEditor.ExpandOption.TRUE_START_COLLAPSED) {
            object = InputEditor.ExpandOption.TRUE;
            if ((beautiDoc.beautiConfig.collapsedBEASTObjects.contains(object2) || expandOption == InputEditor.ExpandOption.TRUE_START_COLLAPSED) && input.get() != null) {
                String string;
                constructor = input.get();
                if (constructor instanceof ArrayList) {
                    for (Object e : (ArrayList)((Object)constructor)) {
                        String string2;
                        if (!(e instanceof BEASTInterface) || ListInputEditor.g_initiallyCollapsedIDs.contains(string2 = ((BEASTInterface)e).getID())) continue;
                        ListInputEditor.g_initiallyCollapsedIDs.add(string2);
                        ListInputEditor.g_collapsedIDs.add(string2);
                    }
                } else if (constructor instanceof BEASTInterface && !ListInputEditor.g_initiallyCollapsedIDs.contains(string = ((BEASTInterface)((Object)constructor)).getID())) {
                    ListInputEditor.g_initiallyCollapsedIDs.add(string);
                    ListInputEditor.g_collapsedIDs.add(string);
                }
            }
        }
        inputEditor2.setDoc(beautiDoc);
        inputEditor2.init(input, bEASTInterface, n, (InputEditor.ExpandOption)((Object)object), bl);
        ((JComponent)((Object)inputEditor2)).setBorder(BorderFactory.createEmptyBorder());
        inputEditor2.getComponent().setVisible(true);
        return inputEditor2;
    }

    public List<String> getAvailablePlugins(Input<?> input, BEASTInterface bEASTInterface, List<String> list, BeautiDoc beautiDoc) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (arrayList != null) {
            return arrayList;
        }
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (!beautiDoc.isExpertMode()) {
            for (BEASTInterface object : BEASTObjectPanel.listAscendants(bEASTInterface, beautiDoc.pluginmap.values())) {
                list.add(object.getID());
            }
        }
        arrayList = new ArrayList();
        for (BEASTInterface bEASTInterface2 : beautiDoc.pluginmap.values()) {
            if (!input.getType().isAssignableFrom(bEASTInterface2.getClass())) continue;
            boolean bl = false;
            if (list != null) {
                for (String string : list) {
                    if (!string.equals(bEASTInterface2.getID())) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            try {
                if (!input.canSetValue(bEASTInterface2, bEASTInterface)) continue;
                arrayList.add(bEASTInterface2.getID());
            }
            catch (Exception exception) {}
        }
        if (beautiDoc.isExpertMode()) {
            List<String> list2 = AddOnManager.find(input.getType(), "beast");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    Iterator<String> iterator2 = Class.forName(string).newInstance();
                    if (!input.canSetValue(iterator2, bEASTInterface)) continue;
                    arrayList.add("new " + string);
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    public List<BeautiSubTemplate> getAvailableTemplates(Input<?> input, BEASTInterface bEASTInterface, List<String> list, BeautiDoc beautiDoc) {
        Class<?> clazz = input.getType();
        List<BeautiSubTemplate> list2 = beautiDoc.beautiConfig.getInputCandidates(bEASTInterface, input, clazz);
        if (input.getRule().equals((Object)Input.Validate.OPTIONAL)) {
            list2.add(BeautiConfig.getNullTemplate(beautiDoc));
        }
        return list2;
    }
}

