/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti.guiutil;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class S11InitialSelection
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    JComboBox<Object> comboBox;
    ComboBoxModel<Object> model;
    JTextComponent editor;
    boolean selecting = false;

    public S11InitialSelection(final JComboBox<Object> jComboBox) {
        this.comboBox = jComboBox;
        this.model = jComboBox.getModel();
        this.editor = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        this.editor.setDocument(this);
        jComboBox.addActionListener(actionEvent -> {
            if (!this.selecting) {
                this.highlightCompletedText(0);
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (jComboBox.isDisplayable()) {
                    jComboBox.setPopupVisible(true);
                }
            }
        });
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.setText(object.toString());
        }
        this.highlightCompletedText(0);
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.remove(n, n2);
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(n, string, attributeSet);
        Object object = this.lookupItem(this.getText(0, this.getLength()));
        if (object != null) {
            this.setSelectedItem(object);
        } else {
            object = this.comboBox.getSelectedItem();
            n -= string.length();
            this.comboBox.getToolkit().beep();
        }
        this.setText(object.toString());
        this.highlightCompletedText(n + string.length());
    }

    private void setText(String string) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    private void highlightCompletedText(int n) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(n);
    }

    private void setSelectedItem(Object object) {
        this.selecting = true;
        this.model.setSelectedItem(object);
        this.selecting = false;
    }

    private Object lookupItem(String string) {
        Object object = this.model.getSelectedItem();
        if (object != null && this.startsWithIgnoreCase(object.toString(), string)) {
            return object;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.model.getElementAt(i);
            if (!this.startsWithIgnoreCase(e.toString(), string)) continue;
            return e;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }

    private static void createAndShowGUI() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
        jComboBox.setEditable(true);
        new S11InitialSelection(jComboBox);
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(jComboBox);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                S11InitialSelection.createAndShowGUI();
            }
        });
    }
}

