/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.draw.InputEditor;
import beast.app.draw.ListInputEditor;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.Operator;
import beast.core.StateNode;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OperatorListInputEditor
extends ListInputEditor {
    private static final long serialVersionUID = 1L;
    List<JTextField> textFields = new ArrayList<JTextField>();
    List<Operator> operators = new ArrayList<Operator>();

    public OperatorListInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return List.class;
    }

    @Override
    public Class<?> baseType() {
        return Operator.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(25));
        box.add(new JLabel("Operator"));
        box.add(Box.createGlue());
        box.add(new JLabel("Weight"));
        box.add(Box.createHorizontalStrut(20));
        this.add(box);
        this.m_buttonStatus = InputEditor.ButtonStatus.NONE;
        super.init(input, bEASTInterface, n, expandOption, bl);
    }

    @Override
    protected InputEditor addPluginItem(Box box, BEASTInterface bEASTInterface) {
        Operator operator = (Operator)bEASTInterface;
        JTextField jTextField = new JTextField(" " + this.getLabel(operator));
        jTextField.setMinimumSize(new Dimension(200, 16));
        this.m_entries.add(jTextField);
        jTextField.setBackground(this.getBackground());
        jTextField.setBorder(null);
        box.add(Box.createRigidArea(new Dimension(5, 1)));
        box.add(jTextField);
        jTextField.setEditable(false);
        box.add(Box.createHorizontalGlue());
        JTextField jTextField2 = new JTextField();
        jTextField2.setToolTipText(operator.m_pWeight.getHTMLTipText());
        jTextField2.setText(operator.m_pWeight.get() + "");
        jTextField2.getDocument().addDocumentListener(new OperatorDocumentListener(operator, jTextField2));
        Dimension dimension = new Dimension(50, 25);
        jTextField2.setMinimumSize(dimension);
        jTextField2.setPreferredSize(dimension);
        int n = jTextField2.getFont().getSize();
        jTextField2.setMaximumSize(new Dimension(50 * n / 13, 50 * n / 13));
        box.add(jTextField2);
        return this;
    }

    @Override
    public void updateState() {
        super.updateState();
        for (int i = 0; i < this.textFields.size(); ++i) {
            this.textFields.get(i).setText(this.operators.get((int)i).m_pWeight.get() + "");
            ((JTextField)this.m_entries.get(i)).setText(this.getLabel(this.operators.get(i)));
        }
    }

    String getLabel(Operator operator) {
        String string = operator.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        if ((string = string.replaceAll("Operator", "")).matches(".*[A-Z].*")) {
            string = string.replaceAll("(.)([A-Z])", "$1 $2");
        }
        string = string + ": ";
        try {
            for (BEASTInterface bEASTInterface : operator.listActiveBEASTObjects()) {
                if (bEASTInterface instanceof StateNode && ((StateNode)bEASTInterface).isEstimatedInput.get().booleanValue()) {
                    string = string + bEASTInterface.getID() + " ";
                }
                if (string.length() <= 100) continue;
                string = string + "... ";
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = this.getDoc().tipTextMap.get(operator.getID());
        if (string2 != null) {
            string = string + " " + (String)string2;
        }
        return string;
    }

    class OperatorDocumentListener
    implements DocumentListener {
        Operator m_operator;
        JTextField m_weightEntry;

        OperatorDocumentListener(Operator operator, JTextField jTextField) {
            this.m_operator = operator;
            this.m_weightEntry = jTextField;
            OperatorListInputEditor.this.textFields.add(jTextField);
            OperatorListInputEditor.this.operators.add(operator);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.processEntry();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.processEntry();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.processEntry();
        }

        void processEntry() {
            try {
                Double d = Double.parseDouble(this.m_weightEntry.getText());
                this.m_operator.m_pWeight.setValue(d, this.m_operator);
            }
            catch (Exception exception) {
                // empty catch block
            }
            OperatorListInputEditor.this.validate();
        }
    }
}

