/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.util.AddOnManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

public class JPackageRepositoryDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public JPackageRepositoryDialog(JFrame jFrame) {
        super(jFrame);
        List<URL> list;
        this.setModal(true);
        this.setTitle("BEAST 2 Package Repository Manager");
        try {
            list = AddOnManager.getRepositoryURLs();
        }
        catch (MalformedURLException malformedURLException) {
            list = new ArrayList<URL>();
            try {
                list.add(new URL("https://raw.githubusercontent.com/CompEvol/CBAN/master/packages.xml"));
            }
            catch (MalformedURLException malformedURLException2) {
                malformedURLException2.printStackTrace();
            }
        }
        RepoTableModel repoTableModel = new RepoTableModel(list);
        JTable jTable = new JTable(repoTableModel);
        int n = jTable.getFont().getSize();
        jTable.setRowHeight(20 * n / 13);
        jTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getContentPane().add((Component)jScrollPane, "Center");
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Add URL");
        jButton.addActionListener(actionEvent -> {
            String string = (String)JOptionPane.showInputDialog(jFrame, "Enter package repository URL", "Add repository URL", -1, null, null, "http://");
            if (string == null) {
                return;
            }
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(jFrame, "Invalid URL.");
                return;
            }
            if (repoTableModel.urls.contains(uRL)) {
                JOptionPane.showMessageDialog(jFrame, "Repository already exists!");
                return;
            }
            try {
                if (uRL.getHost() == null) {
                    return;
                }
                InputStream inputStream = uRL.openStream();
                inputStream.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFrame, "Could not access URL.");
                return;
            }
            repoTableModel.urls.add(uRL);
            repoTableModel.fireTableDataChanged();
        });
        box.add(jButton);
        JButton jButton2 = new JButton("Delete selected URL");
        jButton2.addActionListener(actionEvent -> {
            if (JOptionPane.showConfirmDialog(jFrame, "Really delete this repository?") == 0) {
                repoTableModel.urls.remove(jTable.getSelectedRow());
                repoTableModel.fireTableDataChanged();
            }
        });
        jButton2.setEnabled(false);
        box.add(jButton2);
        JButton jButton3 = new JButton("Done");
        jButton3.addActionListener(actionEvent -> {
            AddOnManager.saveRepositoryURLs(repoTableModel.urls);
            this.setVisible(false);
        });
        box.add(jButton3);
        this.getContentPane().add((Component)box, "Last");
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionEvent -> {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (listSelectionModel.isSelectedIndex(0)) {
                jButton2.setEnabled(false);
            } else {
                jButton2.setEnabled(true);
            }
        });
        Dimension dimension = jScrollPane.getPreferredSize();
        Dimension dimension2 = box.getPreferredSize();
        this.setSize(dimension.width + 30, dimension.height + dimension2.height + 30);
        Point point = jFrame.getLocation();
        Dimension dimension3 = jFrame.getSize();
        this.setLocation(point.x + dimension3.width / 2 - dimension.width / 2, point.y + dimension3.height / 2 - dimension.height / 2);
    }

    class RepoTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public List<URL> urls;

        public RepoTableModel(List<URL> list) {
            this.urls = list;
        }

        @Override
        public int getRowCount() {
            return this.urls.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return "Package repository URLs";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.urls.get(n);
        }
    }
}

