/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.draw.InputEditor;
import beast.app.draw.ListInputEditor;
import beast.app.draw.SmallLabel;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.MCMC;
import beast.core.Operator;
import beast.core.parameter.IntegerParameter;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.operators.DeltaExchangeOperator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class ClockModelListInputEditor
extends ListInputEditor {
    private static final long serialVersionUID = 1L;
    List<JTextField> textFields = new ArrayList<JTextField>();
    List<Operator> operators = new ArrayList<Operator>();
    JCheckBox fixMeanRatesCheckBox;
    DeltaExchangeOperator operator;
    protected SmallLabel fixMeanRatesValidateLabel;

    public ClockModelListInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return List.class;
    }

    @Override
    public Class<?> baseType() {
        return ClockModelListInputEditor.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.fixMeanRatesCheckBox = new JCheckBox("Fix mean rate of clock models");
        this.m_buttonStatus = InputEditor.ButtonStatus.NONE;
        super.init(input, bEASTInterface, n, expandOption, bl);
        List<Operator> list = ((MCMC)this.doc.mcmc.get()).operatorsInput.get();
        this.fixMeanRatesCheckBox.addActionListener(actionEvent -> {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            boolean bl = jCheckBox.isSelected();
            List<Operator> list = ((MCMC)this.doc.mcmc.get()).operatorsInput.get();
            if (bl) {
                if (!list.contains(this.operator)) {
                    list.add(this.operator);
                }
                this.setUpOperator();
            } else {
                list.remove(this.operator);
                this.fixMeanRatesValidateLabel.setVisible(false);
                this.repaint();
            }
        });
        this.operator = (DeltaExchangeOperator)this.doc.pluginmap.get("FixMeanRatesOperator");
        if (this.operator == null) {
            this.operator = new DeltaExchangeOperator();
            try {
                this.operator.setID("FixMeanRatesOperator");
                this.operator.initByName("weight", 2.0, "delta", 0.75);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doc.addPlugin(this.operator);
        }
        this.fixMeanRatesCheckBox.setSelected(list.contains(this.operator));
        Box box = Box.createHorizontalBox();
        box.add(this.fixMeanRatesCheckBox);
        box.add(Box.createHorizontalGlue());
        this.fixMeanRatesValidateLabel = new SmallLabel("x", Color.GREEN);
        this.fixMeanRatesValidateLabel.setVisible(false);
        box.add(this.fixMeanRatesValidateLabel);
        if (((List)input.get()).size() > 1 && this.operator != null) {
            this.add(box);
        }
        this.setUpOperator();
    }

    @Override
    public void validateInput() {
        super.validateInput();
        Log.warning.println("validateInput()");
    }

    private void setUpOperator() {
        String string = "";
        List<RealParameter> list = this.operator.parameterInput.get();
        list.clear();
        double d = -1.0;
        boolean bl = true;
        try {
            for (int i = 0; i < this.doc.alignments.size(); ++i) {
                Alignment alignment = this.doc.alignments.get(i);
                int n = alignment.getSiteCount();
                BranchRateModel.Base base = (BranchRateModel.Base)this.doc.clockModels.get(i);
                RealParameter realParameter = base.meanRateInput.get();
                if (!((Boolean)realParameter.isEstimatedInput.get()).booleanValue()) continue;
                if (d < 0.0) {
                    d = (Double)((List)realParameter.valuesInput.get()).get(0);
                } else if (Math.abs(d - (Double)((List)realParameter.valuesInput.get()).get(0)) > 1.0E-10) {
                    bl = false;
                }
                string = string + n + " ";
                list.add(realParameter);
            }
            if (!this.fixMeanRatesCheckBox.isSelected()) {
                this.fixMeanRatesValidateLabel.setVisible(false);
                return;
            }
            if (list.size() == 0) {
                this.fixMeanRatesValidateLabel.setVisible(true);
                this.fixMeanRatesValidateLabel.m_circleColor = Color.red;
                this.fixMeanRatesValidateLabel.setToolTipText("The model is invalid: At least one clock rate should be estimated.");
                return;
            }
            IntegerParameter integerParameter = new IntegerParameter(string);
            integerParameter.setID("weightparameter");
            integerParameter.isEstimatedInput.setValue(false, integerParameter);
            this.operator.parameterWeightsInput.setValue(integerParameter, this.operator);
            if (!bl) {
                this.fixMeanRatesValidateLabel.setVisible(true);
                this.fixMeanRatesValidateLabel.m_circleColor = Color.orange;
                this.fixMeanRatesValidateLabel.setToolTipText("Not all clocks are equal. Are you sure this is what you want?");
            } else if (list.size() == 1) {
                this.fixMeanRatesValidateLabel.setVisible(true);
                this.fixMeanRatesValidateLabel.m_circleColor = Color.orange;
                this.fixMeanRatesValidateLabel.setToolTipText("At least 2 clock models should have their rate estimated");
            } else if (list.size() < this.doc.alignments.size()) {
                this.fixMeanRatesValidateLabel.setVisible(true);
                this.fixMeanRatesValidateLabel.m_circleColor = Color.orange;
                this.fixMeanRatesValidateLabel.setToolTipText("Not all partitions have their rate estimated");
            } else {
                this.fixMeanRatesValidateLabel.setVisible(false);
            }
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

