/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiAlignmentProvider;
import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiPanelConfig;
import beast.app.beauti.BeautiSubTemplate;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.evolution.alignment.Alignment;
import beast.math.distributions.MRCAPrior;
import beast.util.XMLParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

@Description(value="Beauti configuration object, used to find Beauti configuration information from Beauti template files.")
public class BeautiConfig
extends BEASTObject {
    public final Input<String> inlineInput = new Input("inlinePlugins", "comma separated list of inputs that should go inline, e.g. beast.evolution.sitemodel.SiteModel.substModel");
    public final Input<String> collapsedInput = new Input("collapsedPlugins", "comma separated list of inputs that should go inline, but are initially collapsed, e.g. beast.core.MCMC.logger");
    public final Input<String> suppressInputs = new Input("suppressPlugins", "comma separated list of inputs that should be suppressed. e.g. beast.core.MCMC.operator");
    public final Input<String> inputLabelMapInput = new Input("inputLabelMap", "comma separated list of inputs and their display labels separated by a '=', e.g. beast.core.MCMC.logger=Loggers ");
    public final Input<String> buttonLabelMapInput = new Input("buttonLabelMap", "comma separated list of buttons in dialogs and their display labels separated by a '=', e.g. beast.app.beauti.BeautiInitDlg.&gt;&gt; details=Edit parameters");
    public final Input<String> disableMenus = new Input("disableMenus", "comma separated list of menus that should not be visible, e.g., View.Show Data Panel,Mode");
    public final Input<String> disableButtons = new Input("disableButtons", "comma separated list of buttons that should not be visible, e.g., beast.app.beauti.BeautiInitDlg.Analysis template:");
    public final Input<List<BeautiPanelConfig>> panelsInput = new Input("panel", "define custom panels and their properties", new ArrayList());
    public final Input<Boolean> isExpertInput = new Input<Boolean>("isExpert", "flag to indicate Beauti should start in expert mode", false);
    public final Input<BeautiSubTemplate> partitionTemplate = new Input("partitiontemplate", "defines template used when creating a partition", Input.Validate.REQUIRED);
    public final Input<List<BeautiSubTemplate>> subTemplatesInput = new Input("subtemplate", "defines subtemplates for creating selected classes", new ArrayList());
    public final Input<List<BeautiAlignmentProvider>> alignmentProviderInput = new Input("alignmentProvider", "defines providers for adding new alignments", new ArrayList());
    public Set<String> inlineBEASTObject = new HashSet<String>();
    public Set<String> collapsedBEASTObjects = new HashSet<String>();
    public Set<String> suppressBEASTObjects = new HashSet<String>();
    public HashMap<String, String> inputLabelMap = new HashMap();
    public HashMap<String, String> buttonLabelMap = new HashMap();
    public Set<String> disabledMenus = new HashSet<String>();
    public Set<String> disabledButtons = new HashSet<String>();
    public List<BeautiPanelConfig> panels = new ArrayList<BeautiPanelConfig>();
    public List<BeautiSubTemplate> subTemplates;
    public List<BeautiAlignmentProvider> alignmentProvider;
    public BeautiSubTemplate hyperPriorTemplate = null;
    static final String HYPER_PRIOR_XML = "    <beast version='2.0'\n    \t       namespace='beast.app.beauti:beast.core:beast.evolution.branchratemodel:beast.evolution.speciation:beast.evolution.tree.coalescent:beast.core.util:beast.evolution.nuc:beast.evolution.operators:beast.evolution.sitemodel:beast.evolution.substitutionmodel:beast.evolution.likelihood:beast.evolution:beast.math.distributions'>\n    \t<!-- Parameter Hyper Prior -->\n    \t        <subtemplate spec='beast.app.beauti.BeautiSubTemplate' id='HyperPrior' class='beast.math.distributions.Prior' mainid='HyperPrior.$(n)'>\n    \t<![CDATA[\n    \t        <beastObject id='HyperPrior.$(n)' spec='Prior' x='@parameter.$(n)'>\n    \t            <distr spec='OneOnX'/>\n    \t\t\t</beastObject>\n\n    \t        <beastObject id='hyperScaler.$(n)' spec='ScaleOperator' scaleFactor='0.5' weight='0.1' parameter='@parameter.$(n)'/>\n    \t]]>\n    \t            <connect spec='beast.app.beauti.BeautiConnector' srcID='parameter.$(n)'            targetID='state' inputName='stateNode' if='inposterior(parameter.$(n)) and parameter.$(n)/estimate=true'/>\n\n    \t            <connect spec='beast.app.beauti.BeautiConnector' srcID='hyperScaler.$(n)'          targetID='mcmc' inputName='operator' if='inposterior(parameter.$(n)) and parameter.$(n)/estimate=true'>Scale hyper parameter $(n)</connect>\n\n    \t            <connect spec='beast.app.beauti.BeautiConnector' srcID='parameter.$(n)'            targetID='tracelog' inputName='log'  if='inposterior(parameter.$(n)) and parameter.$(n)/estimate=true'/>\n    \t            <connect spec='beast.app.beauti.BeautiConnector' srcID='HyperPrior.$(n)'           targetID='tracelog' inputName='log'  if='inposterior(parameter.$(n)) and parameter.$(n)/estimate=true'/>\n\n    \t            <connect spec='beast.app.beauti.BeautiConnector' srcID='HyperPrior.$(n)'           targetID='prior' inputName='distribution' if='inposterior(parameter.$(n)) and parameter.$(n)/estimate=true'>Hyper prior for parameter $(n)</connect>\n    \t        </subtemplate>\n    \t</beast>\n";
    static BeautiSubTemplate NULL_TEMPLATE = new BeautiSubTemplate();

    @Override
    public void initAndValidate() {
        this.parseSet(this.inlineInput.get(), null, this.inlineBEASTObject);
        this.parseSet(this.collapsedInput.get(), null, this.collapsedBEASTObjects);
        this.inlineBEASTObject.addAll(this.collapsedBEASTObjects);
        this.parseSet(this.suppressInputs.get(), null, this.suppressBEASTObjects);
        this.parseSet(this.disableMenus.get(), null, this.disabledMenus);
        this.parseSet(this.disableButtons.get(), null, this.disabledButtons);
        this.parseMap(this.inputLabelMapInput.get(), this.inputLabelMap);
        this.parseMap(this.buttonLabelMapInput.get(), this.buttonLabelMap);
        block2: for (BeautiPanelConfig beautiPanelConfig : this.panelsInput.get()) {
            this.panels.add(beautiPanelConfig);
            for (BeautiPanelConfig beautiPanelConfig2 : this.panels) {
                if (!beautiPanelConfig2.nameInput.get().equals(beautiPanelConfig.nameInput.get()) || beautiPanelConfig2 == beautiPanelConfig) continue;
                this.panels.remove(this.panels.size() - 1);
                continue block2;
            }
        }
        this.subTemplates = this.subTemplatesInput.get();
        this.alignmentProvider = this.alignmentProviderInput.get();
        try {
            XMLParser xMLParser = new XMLParser();
            this.hyperPriorTemplate = (BeautiSubTemplate)xMLParser.parseBareFragment(HYPER_PRIOR_XML, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDoc(BeautiDoc beautiDoc) {
        this.partitionTemplate.get().setDoc(beautiDoc);
        for (BeautiSubTemplate beautiSubTemplate : this.subTemplates) {
            beautiSubTemplate.setDoc(beautiDoc);
        }
        beautiDoc.setExpertMode(this.isExpertInput.get());
        this.hyperPriorTemplate.doc = beautiDoc;
    }

    public void clear() {
        this.inlineBEASTObject = new HashSet<String>();
        this.collapsedBEASTObjects = new HashSet<String>();
        this.suppressBEASTObjects = new HashSet<String>();
        this.inputLabelMap = new HashMap();
        this.buttonLabelMap = new HashMap();
        this.disabledMenus = new HashSet<String>();
        this.disabledButtons = new HashSet<String>();
        this.panels = new ArrayList<BeautiPanelConfig>();
    }

    public List<BEASTInterface> selectAlignments(BeautiDoc beautiDoc, JComponent jComponent, File[] fileArray) {
        List<BeautiAlignmentProvider> list = this.alignmentProvider;
        BeautiAlignmentProvider beautiAlignmentProvider = null;
        if (list.size() == 1) {
            beautiAlignmentProvider = list.get(0);
        } else {
            beautiAlignmentProvider = (BeautiAlignmentProvider)JOptionPane.showInputDialog(jComponent, "Select what to add", "Add partition", 3, null, list.toArray(), list.get(0));
            if (beautiAlignmentProvider == null) {
                return null;
            }
        }
        List<BEASTInterface> list2 = beautiAlignmentProvider.getAlignments(beautiDoc, fileArray);
        if (list2 != null) {
            for (BEASTInterface bEASTInterface : list2) {
                if (!(bEASTInterface instanceof Alignment)) continue;
                try {
                    BeautiDoc.createTaxonSet((Alignment)bEASTInterface, beautiDoc);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        beautiDoc.connectModel();
        if (list2 != null) {
            for (BEASTInterface bEASTInterface : list2) {
                if (!(bEASTInterface instanceof MRCAPrior)) continue;
                beautiDoc.addMRCAPrior((MRCAPrior)bEASTInterface);
            }
        }
        return list2;
    }

    public List<BeautiSubTemplate> getInputCandidates(BEASTInterface bEASTInterface, Input<?> input, Class<?> clazz) {
        ArrayList<BeautiSubTemplate> arrayList = new ArrayList<BeautiSubTemplate>();
        for (BeautiSubTemplate beautiSubTemplate : this.subTemplates) {
            if (!clazz.isAssignableFrom(beautiSubTemplate._class)) continue;
            try {
                if (!input.canSetValue(beautiSubTemplate.instance, bEASTInterface)) continue;
                arrayList.add(beautiSubTemplate);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private void parseMap(String string, HashMap<String, String> hashMap) {
        if (string != null) {
            for (String string2 : string.split(",")) {
                String[] stringArray = string2.split("=");
                hashMap.put(this.normalize(stringArray[0]), this.normalize(stringArray.length == 1 ? "" : stringArray[1]));
            }
        }
    }

    private void parseSet(String string, String string2, Set<String> set) {
        if (string == null) {
            string = string2;
        }
        if (string != null) {
            for (String string3 : string.split(",")) {
                set.add(this.normalize(string3));
            }
        }
    }

    String normalize(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        while (n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1))) {
            --n2;
        }
        return string.substring(n, n2);
    }

    public String getButtonLabel(String string, String string2) {
        if (this.buttonLabelMap.containsKey(string + "." + string2)) {
            return this.buttonLabelMap.get(string + "." + string2);
        }
        return string2;
    }

    public String getButtonLabel(Object object, String string) {
        if (this.buttonLabelMap.containsKey(object.getClass().getName() + "." + string)) {
            return this.buttonLabelMap.get(object.getClass().getName() + "." + string);
        }
        return string;
    }

    public String getInputLabel(BEASTInterface bEASTInterface, String string) {
        if (this.inputLabelMap.containsKey(bEASTInterface.getClass().getName() + "." + string)) {
            string = this.inputLabelMap.get(bEASTInterface.getClass().getName() + "." + string);
        }
        return string;
    }

    public boolean menuIsInvisible(String string) {
        return this.disabledMenus.contains(string);
    }

    public static BeautiSubTemplate getNullTemplate(BeautiDoc beautiDoc) {
        NULL_TEMPLATE.setID("[none]");
        BeautiConfig.NULL_TEMPLATE._class = Object.class;
        BeautiConfig.NULL_TEMPLATE.doc = beautiDoc;
        return NULL_TEMPLATE;
    }
}

