/*
 * Decompiled with CFR 0.152.
 */
package beast.app;

import beast.app.BEASTVersion2;
import beast.core.BEASTObject;
import beast.core.Citation;
import beast.core.Description;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.util.Log;
import beast.util.AddOnManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DocMaker {
    String m_sDir = "/tmp";
    List<String> m_beastObjectNames;
    HashMap<String, String[]> m_isa;
    HashMap<String, List<String>> m_ancestors;
    HashMap<String, String> m_descriptions;
    Set<String> m_sLoggables;
    BEASTVersion2 version = new BEASTVersion2();

    public DocMaker(String[] stringArray) {
        this();
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-javadoc")) {
                this.makeJavaDoc();
                System.exit(0);
            }
            this.m_sDir = stringArray[0];
        }
    }

    public DocMaker() {
        this.m_beastObjectNames = AddOnManager.find(BEASTObject.class, AddOnManager.IMPLEMENTATION_DIR);
        this.m_isa = new HashMap();
        this.m_ancestors = new HashMap();
        this.m_descriptions = new HashMap();
        this.m_sLoggables = new HashSet<String>();
        for (String string : this.m_beastObjectNames) {
            this.m_ancestors.put(string, new ArrayList());
        }
        for (String string : this.m_beastObjectNames) {
            try {
                Class<?> clazz = Class.forName(string);
                BEASTObject bEASTObject = (BEASTObject)clazz.newInstance();
                String string2 = this.getInheritableDescription(bEASTObject.getClass());
                Log.warning.println(string + " => " + string2);
                this.m_descriptions.put(string, string2);
                String[] stringArray = this.getImplementations(bEASTObject);
                this.m_isa.put(string, stringArray);
                for (String string3 : stringArray) {
                    this.m_ancestors.get(string3).add(string);
                }
                if (!(bEASTObject instanceof Loggable)) continue;
                this.m_sLoggables.add(string);
            }
            catch (Exception exception) {
                Log.err.println(string + " not documented :" + exception.getMessage());
            }
        }
    }

    void makeJavaDoc() {
        for (String string : this.m_beastObjectNames) {
            try {
                BEASTObject bEASTObject = (BEASTObject)Class.forName(string).newInstance();
                Log.info.println(string + ":@description:" + bEASTObject.getDescription());
                for (Input<?> input : bEASTObject.listInputs()) {
                    Log.info.println(string + ":" + input.getName() + ":" + input.getTipText());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void createCSS() throws FileNotFoundException {
        PrintStream printStream = new PrintStream(this.m_sDir + "/doc.css");
        printStream.println(this.getCSS());
        printStream.close();
    }

    String getCSS() {
        return "<!--\na.summary-letter {text-decoration: none}\nblockquote.smallquotation {font-size: smaller}\ndiv.display {margin-left: 3.2em}\ndiv.example {margin-left: 3.2em}\ndiv.indentedblock {margin-left: 3.2em}\ndiv.lisp {margin-left: 3.2em}\ndiv.smalldisplay {margin-left: 3.2em}\ndiv.smallexample {margin-left: 3.2em}\ndiv.smallindentedblock {margin-left: 3.2em; font-size: smaller}\ndiv.smalllisp {margin-left: 3.2em}\nkbd {font-style:oblique}\npre.display {font-family: inherit}\npre.format {font-family: inherit}\npre.menu-comment {font-family: serif}\npre.menu-preformatted {font-family: serif}\npre.smalldisplay {font-family: inherit; font-size: smaller}\npre.smallexample {font-size: smaller}\npre.smallformat {font-family: inherit; font-size: smaller}\npre.smalllisp {font-size: smaller}\nspan.nocodebreak {white-space:nowrap}\nspan.nolinebreak {white-space:nowrap}\nspan.roman {font-family:serif; font-weight:normal}\nspan.sansserif {font-family:sans-serif; font-weight:normal}\nul.no-bullet {list-style: none}\nbody {margin-left: 5%; margin-right: 5%;}\n\nH1 {             \n    background: white;\n    color: rgb(25%, 25%, 25%);\n    font-family: monospace;\n    font-size: xx-large;\n    text-align: center\n}\n\nH2 {\n    background: white;\n    color: rgb(40%, 40%, 40%);\n    font-family: monospace;\n    font-size: x-large;\n    text-align: center\n}\n\nH3 {\n    background: white;\n    color: rgb(40%, 40%, 40%);\n    font-family: monospace;\n    font-size: large\n}\n\nH4 {\n    background: white;\n    color: rgb(40%, 40%, 40%);\n    font-family: monospace\n}\n\nspan.samp{font-family: monospace}\nspan.command{font-family: monospace}\nspan.option{font-family: monospace}\nspan.file{font-family: monospace}\nspan.env{font-family: monospace}\n\nul {\n    margin-top: 0.25ex;\n    margin-bottom: 0.25ex;\n}\nli {\n    margin-top: 0.25ex;\n    margin-bottom: 0.25ex;\n}\np {\n    margin-top: 0.6ex;\n    margin-bottom: 1.2ex;\n}\ncaption {\n\tfont:  20pt Arial, Helvetica, sans-serif;\n\ttext-align: left;\n\theight: 45px;\n\tcolor: #243D02;\n\tborder-top: 1px solid #243D02;\n}\ntable, th, td {border: 0px;)\n";
    }

    void createIndex() throws FileNotFoundException {
        Object object;
        Object object2;
        Closeable closeable = new PrintStream(this.m_sDir + "/index.html");
        ((PrintStream)closeable).println("<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Frameset//EN'\n\t\t   'http://www.w3.org/TR/html4/frameset.dtd'>\n\t\t<HTML>\n\t\t<HEAD>\n\t\t<TITLE>BEAST " + this.version.getVersionString() + " Documentation</TITLE>\n" + "\t\t</HEAD>\n" + "\t\t<FRAMESET cols='20%, 80%'>\n" + "\t\t  <FRAMESET rows='50, 200'>\n" + "\t\t      <FRAME src='beast.png' align='center'>\n" + "\t\t      <FRAME src='contents.html'>\n" + "\t\t  </FRAMESET>\n" + "\t\t  <FRAME name='display' src='contents.html'>\n" + "\t\t</FRAMESET>\n" + "\t\t</HTML>");
        ((PrintStream)closeable).close();
        try {
            int n;
            closeable = new FileInputStream(new File("src/beast/app/draw/icons/beast.png"));
            object2 = new FileOutputStream(new File(this.m_sDir + "/beast.png"));
            object = new byte[1024];
            while ((n = ((InputStream)closeable).read((byte[])object)) > 0) {
                ((OutputStream)object2).write((byte[])object, 0, n);
            }
            ((InputStream)closeable).close();
            ((OutputStream)object2).close();
        }
        catch (Exception exception) {
            Log.warning.println("WARNING: something went wrong copying beast.png image:" + exception.getMessage());
        }
        closeable = new PrintStream(this.m_sDir + "/contents.html");
        ((PrintStream)closeable).println("<html>\n<head><title>BEAST " + this.version.getVersionString() + " Documentation index</title>\n" + "<link rel='StyleSheet' href='doc.css' type='text/css'>\n" + "</head>\n");
        ((PrintStream)closeable).println("<body>\n");
        ((PrintStream)closeable).println("<h1>BEAST " + this.version.getVersionString() + " Documentation index</h1>\n");
        object2 = null;
        object = null;
        for (String string : this.m_beastObjectNames) {
            String string2 = string.substring(0, string.indexOf(46));
            if (object2 != null && !string2.equals(object2)) {
                ((PrintStream)closeable).println("<hr/>");
            }
            object2 = string2;
            String string3 = string.substring(string.lastIndexOf(46) + 1);
            String string4 = string.substring(0, string.lastIndexOf(46));
            int n = 0;
            while (string.indexOf(46, n) > 0) {
                string3 = "." + string3;
                n = string.indexOf(46, n) + 1;
            }
            Log.warning.println(string3 + " <= " + string);
            if (object == null || !string4.equals(object)) {
                ((PrintStream)closeable).println("<span style='color:grey'>" + string4 + "</span><br/>");
            }
            ((PrintStream)closeable).println("<a href='" + string + ".html' target='display'>" + string3 + "</a><br/>");
            object = string4;
        }
        ((PrintStream)closeable).println("</body>\n");
        ((PrintStream)closeable).println("</html>\n");
        ((PrintStream)closeable).close();
    }

    String[] getImplementations(BEASTObject bEASTObject) {
        String string = bEASTObject.getClass().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.m_beastObjectNames) {
            try {
                if (string2.equals(string) || !bEASTObject.getClass().isAssignableFrom(Class.forName(string2))) continue;
                arrayList.add(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return arrayList.toArray(new String[0]);
    }

    String getInheritableDescription(Class<?> clazz) {
        Object object;
        String string = "";
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (object = this.getInheritableDescription(clazz2)) != null) {
            string = string + (String)object + "<br/>";
        }
        for (Annotation annotation : object = clazz.getAnnotations()) {
            if (!(annotation instanceof Description)) continue;
            Description description = (Description)annotation;
            if (description.isInheritable()) {
                string = string + description.value();
                continue;
            }
            return null;
        }
        return string;
    }

    void createBEASTObjectPage(String string) throws FileNotFoundException {
        PrintStream printStream = new PrintStream(this.m_sDir + "/" + string + ".html");
        try {
            printStream.print(this.getHTML(string, true));
        }
        catch (Exception exception) {
            Log.warning.println("Page creation failed for " + string + ": " + exception.getMessage());
        }
        printStream.close();
    }

    public String getHTML(String string, boolean bl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n<head>\n<title>BEAST " + this.version.getVersionString() + " Documentation: " + string + "</title>\n");
        if (bl) {
            stringBuffer.append("<link rel='StyleSheet' href='/tmp/styles.css' type='text/css'>\n");
        } else {
            stringBuffer.append("<style type='text/css'>\n");
            stringBuffer.append(this.getCSS());
            stringBuffer.append("</style>\n");
        }
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("<h1>BEAST " + this.version.getVersionString() + " Documentation: " + string + "</h1>\n");
        BEASTObject bEASTObject = (BEASTObject)Class.forName(string).newInstance();
        String[] stringArray = this.m_isa.get(string);
        if (stringArray == null) {
            stringBuffer.append("No documentation available for " + string + ". Perhaps it is not in the ClassDiscovery path\n");
            stringBuffer.append("</body>\n");
            stringBuffer.append("</html>\n");
            return stringBuffer.toString();
        }
        if (stringArray.length > 0) {
            stringBuffer.append("<table border='1px'>\n");
            stringBuffer.append("<thead><tr><td>implemented by the following</td></tr></thead>\n");
            for (String string2 : stringArray) {
                stringBuffer.append("<tr><td><a href='" + string2 + ".html'>" + string2 + "</a></td></tr>\n");
            }
            stringBuffer.append("</table>\n");
        }
        stringBuffer.append("<p>" + this.m_descriptions.get(string) + "</p>\n");
        for (Citation citation : bEASTObject.getCitationList()) {
            stringBuffer.append("<h2>Reference:</h2><p>" + citation.value() + "</p>\n");
            if (citation.DOI().length() <= 0) continue;
            stringBuffer.append("<p><a href=\"http://dx.doi.org/" + citation.DOI() + "\">doi:" + citation.DOI() + "</a></p>\n");
        }
        if (this.m_sLoggables.contains(string)) {
            stringBuffer.append("<p>Logable:");
            stringBuffer.append(" yes, this can be used in a log.");
            stringBuffer.append("</p>\n");
        }
        stringBuffer.append("<h2>Inputs:</h2>\n");
        stringBuffer.append("<p>");
        List<Input<?>> list = bEASTObject.listInputs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Input input = (Input)iterator.next();
            stringBuffer.append("<a href='#" + input.getName() + "'>" + input.getName() + "</a>, ");
        }
        stringBuffer.delete(stringBuffer.length() - 3, stringBuffer.length() - 1);
        stringBuffer.append("</p>\n");
        if (list.size() == 0) {
            stringBuffer.append("&lt;none&gt;");
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            Input input = (Input)iterator.next();
            stringBuffer.append("<p>&nbsp</p>");
            stringBuffer.append("<table id='" + input.getName() + "' border='1px' width='90%'>\n");
            stringBuffer.append("<caption>" + input.getName() + "</caption>\n");
            stringBuffer.append("<thead><tr bgcolor='#AAAAAA'><td>type: " + this.getType(bEASTObject, input.getName()) + "</td></tr></thead>\n");
            stringBuffer.append("<tr><td>" + input.getTipText() + "</td></tr>\n");
            stringBuffer.append("<tr><td>\n");
            switch (input.getRule()) {
                case OPTIONAL: {
                    stringBuffer.append("Optional input");
                    if (input.defaultValue == null || !(input.defaultValue instanceof Integer) && !(input.defaultValue instanceof Double) && !(input.defaultValue instanceof Boolean) && !(input.defaultValue instanceof String)) break;
                    stringBuffer.append(". Default: " + input.defaultValue.toString());
                    break;
                }
                case REQUIRED: {
                    stringBuffer.append("Required input");
                    break;
                }
                case XOR: {
                    stringBuffer.append("Either this, or " + input.getOther().getName() + " needs to be specified");
                    break;
                }
                case FORBIDDEN: {
                    stringBuffer.append("Forbidden: must not be specified");
                }
            }
            stringBuffer.append("</td></tr>\n");
            stringBuffer.append("</table>\n");
        }
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        return stringBuffer.toString();
    }

    String getType(BEASTObject bEASTObject, String string) {
        try {
            Field[] fieldArray = bEASTObject.getClass().getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Class clazz;
                Input input;
                if (!fieldArray[i].getType().isAssignableFrom(Input.class) || !(input = (Input)fieldArray[i].get(bEASTObject)).getName().equals(string)) continue;
                Type type2 = fieldArray[i].getGenericType();
                Type[] typeArray = ((ParameterizedType)type2).getActualTypeArguments();
                if (input.getType() != null) {
                    return (input.getType().isAssignableFrom(BEASTObject.class) ? "<a href='" + input.getType().getName() + ".html'>" : "") + input.getType().getName() + (input.get() != null && input.get() instanceof List ? "***" : "") + (input.getType().isAssignableFrom(BEASTObject.class) ? "</a>" : "");
                }
                if (input.get() != null && input.get() instanceof List) {
                    Type[] typeArray2 = ((ParameterizedType)typeArray[0]).getActualTypeArguments();
                    Class clazz2 = (Class)typeArray2[0];
                    Object var10_13 = null;
                    try {
                        var10_13 = Class.forName(clazz2.getName()).newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (var10_13 != null && var10_13 instanceof BEASTObject) {
                        return "<a href='" + clazz2.getName() + ".html'>" + clazz2.getName() + "***</a>";
                    }
                    return clazz2.getName() + "***";
                }
                Class clazz3 = clazz = (Class)typeArray[0];
                Object var10_14 = null;
                try {
                    var10_14 = Class.forName(clazz3.getName()).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (var10_14 != null && var10_14 instanceof BEASTObject) {
                    return "<a href='" + clazz3.getName() + ".html'>" + clazz3.getName() + "</a>";
                }
                return clazz3.getName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "?";
    }

    public void generateDocs() throws FileNotFoundException {
        this.createCSS();
        this.createIndex();
        for (String string : this.m_beastObjectNames) {
            this.createBEASTObjectPage(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.err.println("Producing documentation...");
            AddOnManager.loadExternalJars();
            DocMaker docMaker = new DocMaker(stringArray);
            docMaker.generateDocs();
            System.err.println("Done!!!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

