/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.NGram;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NGramTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testConstants() {
        Assert.assertThat((Object)3, (Matcher)CoreMatchers.is((Object)3));
        Assert.assertEquals((long)3L, (long)3L);
    }

    @Test
    public final void testNormalizeWithLatin() {
        Assert.assertEquals((long)NGram.normalize('\u0000'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('\t'), (long)32L);
        Assert.assertEquals((long)NGram.normalize(' '), (long)32L);
        Assert.assertEquals((long)NGram.normalize('0'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('@'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('A'), (long)65L);
        Assert.assertEquals((long)NGram.normalize('Z'), (long)90L);
        Assert.assertEquals((long)NGram.normalize('['), (long)32L);
        Assert.assertEquals((long)NGram.normalize('`'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('a'), (long)97L);
        Assert.assertEquals((long)NGram.normalize('z'), (long)122L);
        Assert.assertEquals((long)NGram.normalize('{'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('\u007f'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('\u0080'), (long)128L);
        Assert.assertEquals((long)NGram.normalize('\u00a0'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('\u00a1'), (long)161L);
    }

    @Test
    public final void testNormalizeWithCJKKanji() {
        Assert.assertEquals((long)NGram.normalize('\u4e00'), (long)19968L);
        Assert.assertEquals((long)NGram.normalize('\u4e01'), (long)19969L);
        Assert.assertEquals((long)NGram.normalize('\u4e02'), (long)19970L);
        Assert.assertEquals((long)NGram.normalize('\u4e03'), (long)19969L);
        Assert.assertEquals((long)NGram.normalize('\u4e04'), (long)19972L);
        Assert.assertEquals((long)NGram.normalize('\u4e05'), (long)19973L);
        Assert.assertEquals((long)NGram.normalize('\u4e06'), (long)19974L);
        Assert.assertEquals((long)NGram.normalize('\u4e07'), (long)19975L);
        Assert.assertEquals((long)NGram.normalize('\u4e08'), (long)19976L);
        Assert.assertEquals((long)NGram.normalize('\u4e09'), (long)19977L);
        Assert.assertEquals((long)NGram.normalize('\u4e10'), (long)19984L);
        Assert.assertEquals((long)NGram.normalize('\u4e11'), (long)19985L);
        Assert.assertEquals((long)NGram.normalize('\u4e12'), (long)19986L);
        Assert.assertEquals((long)NGram.normalize('\u4e13'), (long)19987L);
        Assert.assertEquals((long)NGram.normalize('\u4e14'), (long)19988L);
        Assert.assertEquals((long)NGram.normalize('\u4e15'), (long)19989L);
        Assert.assertEquals((long)NGram.normalize('\u4e1e'), (long)19998L);
        Assert.assertEquals((long)NGram.normalize('\u4e1f'), (long)19999L);
        Assert.assertEquals((long)NGram.normalize('\u4e20'), (long)20000L);
        Assert.assertEquals((long)NGram.normalize('\u4e21'), (long)20001L);
        Assert.assertEquals((long)NGram.normalize('\u4e22'), (long)20002L);
        Assert.assertEquals((long)NGram.normalize('\u4e23'), (long)20003L);
        Assert.assertEquals((long)NGram.normalize('\u4e24'), (long)19987L);
        Assert.assertEquals((long)NGram.normalize('\u4e25'), (long)19987L);
        Assert.assertEquals((long)NGram.normalize('\u4e30'), (long)20016L);
    }

    @Test
    public final void testNormalizeForRomanian() {
        Assert.assertEquals((long)NGram.normalize('\u015f'), (long)351L);
        Assert.assertEquals((long)NGram.normalize('\u0163'), (long)355L);
        Assert.assertEquals((long)NGram.normalize('\u0219'), (long)351L);
        Assert.assertEquals((long)NGram.normalize('\u021b'), (long)355L);
    }

    @Test
    public final void testNGram() {
        NGram ngram = new NGram();
        Assert.assertEquals((Object)ngram.get(0), null);
        Assert.assertEquals((Object)ngram.get(1), null);
        Assert.assertEquals((Object)ngram.get(2), null);
        Assert.assertEquals((Object)ngram.get(3), null);
        Assert.assertEquals((Object)ngram.get(4), null);
        ngram.addChar(' ');
        Assert.assertEquals((Object)ngram.get(1), null);
        Assert.assertEquals((Object)ngram.get(2), null);
        Assert.assertEquals((Object)ngram.get(3), null);
        ngram.addChar('A');
        Assert.assertEquals((Object)ngram.get(1), (Object)"A");
        Assert.assertEquals((Object)ngram.get(2), (Object)" A");
        Assert.assertEquals((Object)ngram.get(3), null);
        ngram.addChar('\u06cc');
        Assert.assertEquals((Object)ngram.get(1), (Object)"\u064a");
        Assert.assertEquals((Object)ngram.get(2), (Object)"A\u064a");
        Assert.assertEquals((Object)ngram.get(3), (Object)" A\u064a");
        ngram.addChar('\u1ea0');
        Assert.assertEquals((Object)ngram.get(1), (Object)"\u1ec3");
        Assert.assertEquals((Object)ngram.get(2), (Object)"\u064a\u1ec3");
        Assert.assertEquals((Object)ngram.get(3), (Object)"A\u064a\u1ec3");
        ngram.addChar('\u3044');
        Assert.assertEquals((Object)ngram.get(1), (Object)"\u3042");
        Assert.assertEquals((Object)ngram.get(2), (Object)"\u1ec3\u3042");
        Assert.assertEquals((Object)ngram.get(3), (Object)"\u064a\u1ec3\u3042");
        ngram.addChar('\u30a4');
        Assert.assertEquals((Object)ngram.get(1), (Object)"\u30a2");
        Assert.assertEquals((Object)ngram.get(2), (Object)"\u3042\u30a2");
        Assert.assertEquals((Object)ngram.get(3), (Object)"\u1ec3\u3042\u30a2");
        ngram.addChar('\u3106');
        Assert.assertEquals((Object)ngram.get(1), (Object)"\u3105");
        Assert.assertEquals((Object)ngram.get(2), (Object)"\u30a2\u3105");
        Assert.assertEquals((Object)ngram.get(3), (Object)"\u3042\u30a2\u3105");
        ngram.addChar('\uac01');
        Assert.assertEquals((Object)ngram.get(1), (Object)"\uac00");
        Assert.assertEquals((Object)ngram.get(2), (Object)"\u3105\uac00");
        Assert.assertEquals((Object)ngram.get(3), (Object)"\u30a2\u3105\uac00");
        ngram.addChar('\u2010');
        Assert.assertEquals((Object)ngram.get(1), null);
        Assert.assertEquals((Object)ngram.get(2), (Object)"\uac00 ");
        Assert.assertEquals((Object)ngram.get(3), (Object)"\u3105\uac00 ");
        ngram.addChar('a');
        Assert.assertEquals((Object)ngram.get(1), (Object)"a");
        Assert.assertEquals((Object)ngram.get(2), (Object)" a");
        Assert.assertEquals((Object)ngram.get(3), null);
    }

    @Test
    public final void testNGram3() {
        NGram ngram = new NGram();
        ngram.addChar('A');
        Assert.assertEquals((Object)ngram.get(1), (Object)"A");
        Assert.assertEquals((Object)ngram.get(2), (Object)" A");
        Assert.assertEquals((Object)ngram.get(3), null);
        ngram.addChar('1');
        Assert.assertEquals((Object)ngram.get(1), null);
        Assert.assertEquals((Object)ngram.get(2), (Object)"A ");
        Assert.assertEquals((Object)ngram.get(3), (Object)" A ");
        ngram.addChar('B');
        Assert.assertEquals((Object)ngram.get(1), (Object)"B");
        Assert.assertEquals((Object)ngram.get(2), (Object)" B");
        Assert.assertEquals((Object)ngram.get(3), null);
    }

    @Test
    public final void testNormalizeVietnamese() {
        Assert.assertEquals((Object)NGram.normalize_vi(""), (Object)"");
        Assert.assertEquals((Object)NGram.normalize_vi("ABC"), (Object)"ABC");
        Assert.assertEquals((Object)NGram.normalize_vi("012"), (Object)"012");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00c0"), (Object)"\u00c0");
        Assert.assertEquals((Object)NGram.normalize_vi("A\u0300"), (Object)"\u00c0");
        Assert.assertEquals((Object)NGram.normalize_vi("E\u0300"), (Object)"\u00c8");
        Assert.assertEquals((Object)NGram.normalize_vi("I\u0300"), (Object)"\u00cc");
        Assert.assertEquals((Object)NGram.normalize_vi("O\u0300"), (Object)"\u00d2");
        Assert.assertEquals((Object)NGram.normalize_vi("U\u0300"), (Object)"\u00d9");
        Assert.assertEquals((Object)NGram.normalize_vi("Y\u0300"), (Object)"\u1ef2");
        Assert.assertEquals((Object)NGram.normalize_vi("a\u0300"), (Object)"\u00e0");
        Assert.assertEquals((Object)NGram.normalize_vi("e\u0300"), (Object)"\u00e8");
        Assert.assertEquals((Object)NGram.normalize_vi("i\u0300"), (Object)"\u00ec");
        Assert.assertEquals((Object)NGram.normalize_vi("o\u0300"), (Object)"\u00f2");
        Assert.assertEquals((Object)NGram.normalize_vi("u\u0300"), (Object)"\u00f9");
        Assert.assertEquals((Object)NGram.normalize_vi("y\u0300"), (Object)"\u1ef3");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00c2\u0300"), (Object)"\u1ea6");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ca\u0300"), (Object)"\u1ec0");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00d4\u0300"), (Object)"\u1ed2");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00e2\u0300"), (Object)"\u1ea7");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ea\u0300"), (Object)"\u1ec1");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00f4\u0300"), (Object)"\u1ed3");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0102\u0300"), (Object)"\u1eb0");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0103\u0300"), (Object)"\u1eb1");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a0\u0300"), (Object)"\u1edc");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a1\u0300"), (Object)"\u1edd");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01af\u0300"), (Object)"\u1eea");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01b0\u0300"), (Object)"\u1eeb");
        Assert.assertEquals((Object)NGram.normalize_vi("A\u0301"), (Object)"\u00c1");
        Assert.assertEquals((Object)NGram.normalize_vi("E\u0301"), (Object)"\u00c9");
        Assert.assertEquals((Object)NGram.normalize_vi("I\u0301"), (Object)"\u00cd");
        Assert.assertEquals((Object)NGram.normalize_vi("O\u0301"), (Object)"\u00d3");
        Assert.assertEquals((Object)NGram.normalize_vi("U\u0301"), (Object)"\u00da");
        Assert.assertEquals((Object)NGram.normalize_vi("Y\u0301"), (Object)"\u00dd");
        Assert.assertEquals((Object)NGram.normalize_vi("a\u0301"), (Object)"\u00e1");
        Assert.assertEquals((Object)NGram.normalize_vi("e\u0301"), (Object)"\u00e9");
        Assert.assertEquals((Object)NGram.normalize_vi("i\u0301"), (Object)"\u00ed");
        Assert.assertEquals((Object)NGram.normalize_vi("o\u0301"), (Object)"\u00f3");
        Assert.assertEquals((Object)NGram.normalize_vi("u\u0301"), (Object)"\u00fa");
        Assert.assertEquals((Object)NGram.normalize_vi("y\u0301"), (Object)"\u00fd");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00c2\u0301"), (Object)"\u1ea4");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ca\u0301"), (Object)"\u1ebe");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00d4\u0301"), (Object)"\u1ed0");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00e2\u0301"), (Object)"\u1ea5");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ea\u0301"), (Object)"\u1ebf");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00f4\u0301"), (Object)"\u1ed1");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0102\u0301"), (Object)"\u1eae");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0103\u0301"), (Object)"\u1eaf");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a0\u0301"), (Object)"\u1eda");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a1\u0301"), (Object)"\u1edb");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01af\u0301"), (Object)"\u1ee8");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01b0\u0301"), (Object)"\u1ee9");
        Assert.assertEquals((Object)NGram.normalize_vi("A\u0303"), (Object)"\u00c3");
        Assert.assertEquals((Object)NGram.normalize_vi("E\u0303"), (Object)"\u1ebc");
        Assert.assertEquals((Object)NGram.normalize_vi("I\u0303"), (Object)"\u0128");
        Assert.assertEquals((Object)NGram.normalize_vi("O\u0303"), (Object)"\u00d5");
        Assert.assertEquals((Object)NGram.normalize_vi("U\u0303"), (Object)"\u0168");
        Assert.assertEquals((Object)NGram.normalize_vi("Y\u0303"), (Object)"\u1ef8");
        Assert.assertEquals((Object)NGram.normalize_vi("a\u0303"), (Object)"\u00e3");
        Assert.assertEquals((Object)NGram.normalize_vi("e\u0303"), (Object)"\u1ebd");
        Assert.assertEquals((Object)NGram.normalize_vi("i\u0303"), (Object)"\u0129");
        Assert.assertEquals((Object)NGram.normalize_vi("o\u0303"), (Object)"\u00f5");
        Assert.assertEquals((Object)NGram.normalize_vi("u\u0303"), (Object)"\u0169");
        Assert.assertEquals((Object)NGram.normalize_vi("y\u0303"), (Object)"\u1ef9");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00c2\u0303"), (Object)"\u1eaa");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ca\u0303"), (Object)"\u1ec4");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00d4\u0303"), (Object)"\u1ed6");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00e2\u0303"), (Object)"\u1eab");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ea\u0303"), (Object)"\u1ec5");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00f4\u0303"), (Object)"\u1ed7");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0102\u0303"), (Object)"\u1eb4");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0103\u0303"), (Object)"\u1eb5");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a0\u0303"), (Object)"\u1ee0");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a1\u0303"), (Object)"\u1ee1");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01af\u0303"), (Object)"\u1eee");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01b0\u0303"), (Object)"\u1eef");
        Assert.assertEquals((Object)NGram.normalize_vi("A\u0309"), (Object)"\u1ea2");
        Assert.assertEquals((Object)NGram.normalize_vi("E\u0309"), (Object)"\u1eba");
        Assert.assertEquals((Object)NGram.normalize_vi("I\u0309"), (Object)"\u1ec8");
        Assert.assertEquals((Object)NGram.normalize_vi("O\u0309"), (Object)"\u1ece");
        Assert.assertEquals((Object)NGram.normalize_vi("U\u0309"), (Object)"\u1ee6");
        Assert.assertEquals((Object)NGram.normalize_vi("Y\u0309"), (Object)"\u1ef6");
        Assert.assertEquals((Object)NGram.normalize_vi("a\u0309"), (Object)"\u1ea3");
        Assert.assertEquals((Object)NGram.normalize_vi("e\u0309"), (Object)"\u1ebb");
        Assert.assertEquals((Object)NGram.normalize_vi("i\u0309"), (Object)"\u1ec9");
        Assert.assertEquals((Object)NGram.normalize_vi("o\u0309"), (Object)"\u1ecf");
        Assert.assertEquals((Object)NGram.normalize_vi("u\u0309"), (Object)"\u1ee7");
        Assert.assertEquals((Object)NGram.normalize_vi("y\u0309"), (Object)"\u1ef7");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00c2\u0309"), (Object)"\u1ea8");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ca\u0309"), (Object)"\u1ec2");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00d4\u0309"), (Object)"\u1ed4");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00e2\u0309"), (Object)"\u1ea9");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ea\u0309"), (Object)"\u1ec3");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00f4\u0309"), (Object)"\u1ed5");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0102\u0309"), (Object)"\u1eb2");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0103\u0309"), (Object)"\u1eb3");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a0\u0309"), (Object)"\u1ede");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a1\u0309"), (Object)"\u1edf");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01af\u0309"), (Object)"\u1eec");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01b0\u0309"), (Object)"\u1eed");
        Assert.assertEquals((Object)NGram.normalize_vi("A\u0323"), (Object)"\u1ea0");
        Assert.assertEquals((Object)NGram.normalize_vi("E\u0323"), (Object)"\u1eb8");
        Assert.assertEquals((Object)NGram.normalize_vi("I\u0323"), (Object)"\u1eca");
        Assert.assertEquals((Object)NGram.normalize_vi("O\u0323"), (Object)"\u1ecc");
        Assert.assertEquals((Object)NGram.normalize_vi("U\u0323"), (Object)"\u1ee4");
        Assert.assertEquals((Object)NGram.normalize_vi("Y\u0323"), (Object)"\u1ef4");
        Assert.assertEquals((Object)NGram.normalize_vi("a\u0323"), (Object)"\u1ea1");
        Assert.assertEquals((Object)NGram.normalize_vi("e\u0323"), (Object)"\u1eb9");
        Assert.assertEquals((Object)NGram.normalize_vi("i\u0323"), (Object)"\u1ecb");
        Assert.assertEquals((Object)NGram.normalize_vi("o\u0323"), (Object)"\u1ecd");
        Assert.assertEquals((Object)NGram.normalize_vi("u\u0323"), (Object)"\u1ee5");
        Assert.assertEquals((Object)NGram.normalize_vi("y\u0323"), (Object)"\u1ef5");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00c2\u0323"), (Object)"\u1eac");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ca\u0323"), (Object)"\u1ec6");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00d4\u0323"), (Object)"\u1ed8");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00e2\u0323"), (Object)"\u1ead");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00ea\u0323"), (Object)"\u1ec7");
        Assert.assertEquals((Object)NGram.normalize_vi("\u00f4\u0323"), (Object)"\u1ed9");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0102\u0323"), (Object)"\u1eb6");
        Assert.assertEquals((Object)NGram.normalize_vi("\u0103\u0323"), (Object)"\u1eb7");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a0\u0323"), (Object)"\u1ee2");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01a1\u0323"), (Object)"\u1ee3");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01af\u0323"), (Object)"\u1ef0");
        Assert.assertEquals((Object)NGram.normalize_vi("\u01b0\u0323"), (Object)"\u1ef1");
    }
}

